/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.pinpointsmsvoicev2.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.pinpointsmsvoicev2.PinpointSmsVoiceV2Client;
import software.amazon.awssdk.services.pinpointsmsvoicev2.internal.UserAgentUtils;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.ListRegistrationAssociationsRequest;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.ListRegistrationAssociationsResponse;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.RegistrationAssociationMetadata;

public class ListRegistrationAssociationsIterable
implements SdkIterable<ListRegistrationAssociationsResponse> {
    private final PinpointSmsVoiceV2Client client;
    private final ListRegistrationAssociationsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListRegistrationAssociationsIterable(PinpointSmsVoiceV2Client client, ListRegistrationAssociationsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListRegistrationAssociationsResponseFetcher();
    }

    public Iterator<ListRegistrationAssociationsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<RegistrationAssociationMetadata> registrationAssociations() {
        Function<ListRegistrationAssociationsResponse, Iterator> getIterator = response -> {
            if (response != null && response.registrationAssociations() != null) {
                return response.registrationAssociations().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListRegistrationAssociationsResponseFetcher
    implements SyncPageFetcher<ListRegistrationAssociationsResponse> {
        private ListRegistrationAssociationsResponseFetcher() {
        }

        public boolean hasNextPage(ListRegistrationAssociationsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListRegistrationAssociationsResponse nextPage(ListRegistrationAssociationsResponse previousPage) {
            if (previousPage == null) {
                return ListRegistrationAssociationsIterable.this.client.listRegistrationAssociations(ListRegistrationAssociationsIterable.this.firstRequest);
            }
            return ListRegistrationAssociationsIterable.this.client.listRegistrationAssociations((ListRegistrationAssociationsRequest)((Object)ListRegistrationAssociationsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

