/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.pinpointsmsvoicev2.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.MessageType;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.PoolStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class PoolInformation
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, PoolInformation> {
    private static final SdkField<String> POOL_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PoolArn").getter(PoolInformation.getter(PoolInformation::poolArn)).setter(PoolInformation.setter(Builder::poolArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PoolArn").build()}).build();
    private static final SdkField<String> POOL_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PoolId").getter(PoolInformation.getter(PoolInformation::poolId)).setter(PoolInformation.setter(Builder::poolId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PoolId").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Status").getter(PoolInformation.getter(PoolInformation::statusAsString)).setter(PoolInformation.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()}).build();
    private static final SdkField<String> MESSAGE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("MessageType").getter(PoolInformation.getter(PoolInformation::messageTypeAsString)).setter(PoolInformation.setter(Builder::messageType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MessageType").build()}).build();
    private static final SdkField<Boolean> TWO_WAY_ENABLED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("TwoWayEnabled").getter(PoolInformation.getter(PoolInformation::twoWayEnabled)).setter(PoolInformation.setter(Builder::twoWayEnabled)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TwoWayEnabled").build()}).build();
    private static final SdkField<String> TWO_WAY_CHANNEL_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TwoWayChannelArn").getter(PoolInformation.getter(PoolInformation::twoWayChannelArn)).setter(PoolInformation.setter(Builder::twoWayChannelArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TwoWayChannelArn").build()}).build();
    private static final SdkField<Boolean> SELF_MANAGED_OPT_OUTS_ENABLED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("SelfManagedOptOutsEnabled").getter(PoolInformation.getter(PoolInformation::selfManagedOptOutsEnabled)).setter(PoolInformation.setter(Builder::selfManagedOptOutsEnabled)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SelfManagedOptOutsEnabled").build()}).build();
    private static final SdkField<String> OPT_OUT_LIST_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("OptOutListName").getter(PoolInformation.getter(PoolInformation::optOutListName)).setter(PoolInformation.setter(Builder::optOutListName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OptOutListName").build()}).build();
    private static final SdkField<Boolean> SHARED_ROUTES_ENABLED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("SharedRoutesEnabled").getter(PoolInformation.getter(PoolInformation::sharedRoutesEnabled)).setter(PoolInformation.setter(Builder::sharedRoutesEnabled)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SharedRoutesEnabled").build()}).build();
    private static final SdkField<Boolean> DELETION_PROTECTION_ENABLED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("DeletionProtectionEnabled").getter(PoolInformation.getter(PoolInformation::deletionProtectionEnabled)).setter(PoolInformation.setter(Builder::deletionProtectionEnabled)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeletionProtectionEnabled").build()}).build();
    private static final SdkField<Instant> CREATED_TIMESTAMP_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CreatedTimestamp").getter(PoolInformation.getter(PoolInformation::createdTimestamp)).setter(PoolInformation.setter(Builder::createdTimestamp)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedTimestamp").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(POOL_ARN_FIELD, POOL_ID_FIELD, STATUS_FIELD, MESSAGE_TYPE_FIELD, TWO_WAY_ENABLED_FIELD, TWO_WAY_CHANNEL_ARN_FIELD, SELF_MANAGED_OPT_OUTS_ENABLED_FIELD, OPT_OUT_LIST_NAME_FIELD, SHARED_ROUTES_ENABLED_FIELD, DELETION_PROTECTION_ENABLED_FIELD, CREATED_TIMESTAMP_FIELD));
    private static final long serialVersionUID = 1L;
    private final String poolArn;
    private final String poolId;
    private final String status;
    private final String messageType;
    private final Boolean twoWayEnabled;
    private final String twoWayChannelArn;
    private final Boolean selfManagedOptOutsEnabled;
    private final String optOutListName;
    private final Boolean sharedRoutesEnabled;
    private final Boolean deletionProtectionEnabled;
    private final Instant createdTimestamp;

    private PoolInformation(BuilderImpl builder) {
        this.poolArn = builder.poolArn;
        this.poolId = builder.poolId;
        this.status = builder.status;
        this.messageType = builder.messageType;
        this.twoWayEnabled = builder.twoWayEnabled;
        this.twoWayChannelArn = builder.twoWayChannelArn;
        this.selfManagedOptOutsEnabled = builder.selfManagedOptOutsEnabled;
        this.optOutListName = builder.optOutListName;
        this.sharedRoutesEnabled = builder.sharedRoutesEnabled;
        this.deletionProtectionEnabled = builder.deletionProtectionEnabled;
        this.createdTimestamp = builder.createdTimestamp;
    }

    public final String poolArn() {
        return this.poolArn;
    }

    public final String poolId() {
        return this.poolId;
    }

    public final PoolStatus status() {
        return PoolStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final MessageType messageType() {
        return MessageType.fromValue(this.messageType);
    }

    public final String messageTypeAsString() {
        return this.messageType;
    }

    public final Boolean twoWayEnabled() {
        return this.twoWayEnabled;
    }

    public final String twoWayChannelArn() {
        return this.twoWayChannelArn;
    }

    public final Boolean selfManagedOptOutsEnabled() {
        return this.selfManagedOptOutsEnabled;
    }

    public final String optOutListName() {
        return this.optOutListName;
    }

    public final Boolean sharedRoutesEnabled() {
        return this.sharedRoutesEnabled;
    }

    public final Boolean deletionProtectionEnabled() {
        return this.deletionProtectionEnabled;
    }

    public final Instant createdTimestamp() {
        return this.createdTimestamp;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.poolArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.poolId());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.messageTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.twoWayEnabled());
        hashCode = 31 * hashCode + Objects.hashCode(this.twoWayChannelArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.selfManagedOptOutsEnabled());
        hashCode = 31 * hashCode + Objects.hashCode(this.optOutListName());
        hashCode = 31 * hashCode + Objects.hashCode(this.sharedRoutesEnabled());
        hashCode = 31 * hashCode + Objects.hashCode(this.deletionProtectionEnabled());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdTimestamp());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PoolInformation)) {
            return false;
        }
        PoolInformation other = (PoolInformation)obj;
        return Objects.equals(this.poolArn(), other.poolArn()) && Objects.equals(this.poolId(), other.poolId()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.messageTypeAsString(), other.messageTypeAsString()) && Objects.equals(this.twoWayEnabled(), other.twoWayEnabled()) && Objects.equals(this.twoWayChannelArn(), other.twoWayChannelArn()) && Objects.equals(this.selfManagedOptOutsEnabled(), other.selfManagedOptOutsEnabled()) && Objects.equals(this.optOutListName(), other.optOutListName()) && Objects.equals(this.sharedRoutesEnabled(), other.sharedRoutesEnabled()) && Objects.equals(this.deletionProtectionEnabled(), other.deletionProtectionEnabled()) && Objects.equals(this.createdTimestamp(), other.createdTimestamp());
    }

    public final String toString() {
        return ToString.builder((String)"PoolInformation").add("PoolArn", (Object)this.poolArn()).add("PoolId", (Object)this.poolId()).add("Status", (Object)this.statusAsString()).add("MessageType", (Object)this.messageTypeAsString()).add("TwoWayEnabled", (Object)this.twoWayEnabled()).add("TwoWayChannelArn", (Object)this.twoWayChannelArn()).add("SelfManagedOptOutsEnabled", (Object)this.selfManagedOptOutsEnabled()).add("OptOutListName", (Object)this.optOutListName()).add("SharedRoutesEnabled", (Object)this.sharedRoutesEnabled()).add("DeletionProtectionEnabled", (Object)this.deletionProtectionEnabled()).add("CreatedTimestamp", (Object)this.createdTimestamp()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "PoolArn": {
                return Optional.ofNullable(clazz.cast(this.poolArn()));
            }
            case "PoolId": {
                return Optional.ofNullable(clazz.cast(this.poolId()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "MessageType": {
                return Optional.ofNullable(clazz.cast(this.messageTypeAsString()));
            }
            case "TwoWayEnabled": {
                return Optional.ofNullable(clazz.cast(this.twoWayEnabled()));
            }
            case "TwoWayChannelArn": {
                return Optional.ofNullable(clazz.cast(this.twoWayChannelArn()));
            }
            case "SelfManagedOptOutsEnabled": {
                return Optional.ofNullable(clazz.cast(this.selfManagedOptOutsEnabled()));
            }
            case "OptOutListName": {
                return Optional.ofNullable(clazz.cast(this.optOutListName()));
            }
            case "SharedRoutesEnabled": {
                return Optional.ofNullable(clazz.cast(this.sharedRoutesEnabled()));
            }
            case "DeletionProtectionEnabled": {
                return Optional.ofNullable(clazz.cast(this.deletionProtectionEnabled()));
            }
            case "CreatedTimestamp": {
                return Optional.ofNullable(clazz.cast(this.createdTimestamp()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PoolInformation, T> g) {
        return obj -> g.apply((PoolInformation)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String poolArn;
        private String poolId;
        private String status;
        private String messageType;
        private Boolean twoWayEnabled;
        private String twoWayChannelArn;
        private Boolean selfManagedOptOutsEnabled;
        private String optOutListName;
        private Boolean sharedRoutesEnabled;
        private Boolean deletionProtectionEnabled;
        private Instant createdTimestamp;

        private BuilderImpl() {
        }

        private BuilderImpl(PoolInformation model) {
            this.poolArn(model.poolArn);
            this.poolId(model.poolId);
            this.status(model.status);
            this.messageType(model.messageType);
            this.twoWayEnabled(model.twoWayEnabled);
            this.twoWayChannelArn(model.twoWayChannelArn);
            this.selfManagedOptOutsEnabled(model.selfManagedOptOutsEnabled);
            this.optOutListName(model.optOutListName);
            this.sharedRoutesEnabled(model.sharedRoutesEnabled);
            this.deletionProtectionEnabled(model.deletionProtectionEnabled);
            this.createdTimestamp(model.createdTimestamp);
        }

        public final String getPoolArn() {
            return this.poolArn;
        }

        public final void setPoolArn(String poolArn) {
            this.poolArn = poolArn;
        }

        @Override
        public final Builder poolArn(String poolArn) {
            this.poolArn = poolArn;
            return this;
        }

        public final String getPoolId() {
            return this.poolId;
        }

        public final void setPoolId(String poolId) {
            this.poolId = poolId;
        }

        @Override
        public final Builder poolId(String poolId) {
            this.poolId = poolId;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(PoolStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getMessageType() {
            return this.messageType;
        }

        public final void setMessageType(String messageType) {
            this.messageType = messageType;
        }

        @Override
        public final Builder messageType(String messageType) {
            this.messageType = messageType;
            return this;
        }

        @Override
        public final Builder messageType(MessageType messageType) {
            this.messageType(messageType == null ? null : messageType.toString());
            return this;
        }

        public final Boolean getTwoWayEnabled() {
            return this.twoWayEnabled;
        }

        public final void setTwoWayEnabled(Boolean twoWayEnabled) {
            this.twoWayEnabled = twoWayEnabled;
        }

        @Override
        public final Builder twoWayEnabled(Boolean twoWayEnabled) {
            this.twoWayEnabled = twoWayEnabled;
            return this;
        }

        public final String getTwoWayChannelArn() {
            return this.twoWayChannelArn;
        }

        public final void setTwoWayChannelArn(String twoWayChannelArn) {
            this.twoWayChannelArn = twoWayChannelArn;
        }

        @Override
        public final Builder twoWayChannelArn(String twoWayChannelArn) {
            this.twoWayChannelArn = twoWayChannelArn;
            return this;
        }

        public final Boolean getSelfManagedOptOutsEnabled() {
            return this.selfManagedOptOutsEnabled;
        }

        public final void setSelfManagedOptOutsEnabled(Boolean selfManagedOptOutsEnabled) {
            this.selfManagedOptOutsEnabled = selfManagedOptOutsEnabled;
        }

        @Override
        public final Builder selfManagedOptOutsEnabled(Boolean selfManagedOptOutsEnabled) {
            this.selfManagedOptOutsEnabled = selfManagedOptOutsEnabled;
            return this;
        }

        public final String getOptOutListName() {
            return this.optOutListName;
        }

        public final void setOptOutListName(String optOutListName) {
            this.optOutListName = optOutListName;
        }

        @Override
        public final Builder optOutListName(String optOutListName) {
            this.optOutListName = optOutListName;
            return this;
        }

        public final Boolean getSharedRoutesEnabled() {
            return this.sharedRoutesEnabled;
        }

        public final void setSharedRoutesEnabled(Boolean sharedRoutesEnabled) {
            this.sharedRoutesEnabled = sharedRoutesEnabled;
        }

        @Override
        public final Builder sharedRoutesEnabled(Boolean sharedRoutesEnabled) {
            this.sharedRoutesEnabled = sharedRoutesEnabled;
            return this;
        }

        public final Boolean getDeletionProtectionEnabled() {
            return this.deletionProtectionEnabled;
        }

        public final void setDeletionProtectionEnabled(Boolean deletionProtectionEnabled) {
            this.deletionProtectionEnabled = deletionProtectionEnabled;
        }

        @Override
        public final Builder deletionProtectionEnabled(Boolean deletionProtectionEnabled) {
            this.deletionProtectionEnabled = deletionProtectionEnabled;
            return this;
        }

        public final Instant getCreatedTimestamp() {
            return this.createdTimestamp;
        }

        public final void setCreatedTimestamp(Instant createdTimestamp) {
            this.createdTimestamp = createdTimestamp;
        }

        @Override
        public final Builder createdTimestamp(Instant createdTimestamp) {
            this.createdTimestamp = createdTimestamp;
            return this;
        }

        public PoolInformation build() {
            return new PoolInformation(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, PoolInformation> {
        public Builder poolArn(String var1);

        public Builder poolId(String var1);

        public Builder status(String var1);

        public Builder status(PoolStatus var1);

        public Builder messageType(String var1);

        public Builder messageType(MessageType var1);

        public Builder twoWayEnabled(Boolean var1);

        public Builder twoWayChannelArn(String var1);

        public Builder selfManagedOptOutsEnabled(Boolean var1);

        public Builder optOutListName(String var1);

        public Builder sharedRoutesEnabled(Boolean var1);

        public Builder deletionProtectionEnabled(Boolean var1);

        public Builder createdTimestamp(Instant var1);
    }
}

