/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.pinpointsmsvoicev2.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.pinpointsmsvoicev2.PinpointSmsVoiceV2Client;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.DescribePoolsRequest;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.DescribePoolsResponse;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.PoolInformation;

public class DescribePoolsIterable
implements SdkIterable<DescribePoolsResponse> {
    private final PinpointSmsVoiceV2Client client;
    private final DescribePoolsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public DescribePoolsIterable(PinpointSmsVoiceV2Client client, DescribePoolsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new DescribePoolsResponseFetcher();
    }

    public Iterator<DescribePoolsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<PoolInformation> pools() {
        Function<DescribePoolsResponse, Iterator> getIterator = response -> {
            if (response != null && response.pools() != null) {
                return response.pools().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class DescribePoolsResponseFetcher
    implements SyncPageFetcher<DescribePoolsResponse> {
        private DescribePoolsResponseFetcher() {
        }

        public boolean hasNextPage(DescribePoolsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public DescribePoolsResponse nextPage(DescribePoolsResponse previousPage) {
            if (previousPage == null) {
                return DescribePoolsIterable.this.client.describePools(DescribePoolsIterable.this.firstRequest);
            }
            return DescribePoolsIterable.this.client.describePools((DescribePoolsRequest)((Object)DescribePoolsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

