/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.pinpointsmsvoicev2.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.pinpointsmsvoicev2.PinpointSmsVoiceV2Client;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.DescribeOptedOutNumbersRequest;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.DescribeOptedOutNumbersResponse;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.OptedOutNumberInformation;

public class DescribeOptedOutNumbersIterable
implements SdkIterable<DescribeOptedOutNumbersResponse> {
    private final PinpointSmsVoiceV2Client client;
    private final DescribeOptedOutNumbersRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public DescribeOptedOutNumbersIterable(PinpointSmsVoiceV2Client client, DescribeOptedOutNumbersRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new DescribeOptedOutNumbersResponseFetcher();
    }

    public Iterator<DescribeOptedOutNumbersResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<OptedOutNumberInformation> optedOutNumbers() {
        Function<DescribeOptedOutNumbersResponse, Iterator> getIterator = response -> {
            if (response != null && response.optedOutNumbers() != null) {
                return response.optedOutNumbers().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class DescribeOptedOutNumbersResponseFetcher
    implements SyncPageFetcher<DescribeOptedOutNumbersResponse> {
        private DescribeOptedOutNumbersResponseFetcher() {
        }

        public boolean hasNextPage(DescribeOptedOutNumbersResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public DescribeOptedOutNumbersResponse nextPage(DescribeOptedOutNumbersResponse previousPage) {
            if (previousPage == null) {
                return DescribeOptedOutNumbersIterable.this.client.describeOptedOutNumbers(DescribeOptedOutNumbersIterable.this.firstRequest);
            }
            return DescribeOptedOutNumbersIterable.this.client.describeOptedOutNumbers((DescribeOptedOutNumbersRequest)((Object)DescribeOptedOutNumbersIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

