/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.pinpointsmsvoice.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.pinpointsmsvoice.model.EventDestination;
import software.amazon.awssdk.services.pinpointsmsvoice.model.EventDestinationsCopier;
import software.amazon.awssdk.services.pinpointsmsvoice.model.PinpointSmsVoiceResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetConfigurationSetEventDestinationsResponse
extends PinpointSmsVoiceResponse
implements ToCopyableBuilder<Builder, GetConfigurationSetEventDestinationsResponse> {
    private static final SdkField<List<EventDestination>> EVENT_DESTINATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("EventDestinations").getter(GetConfigurationSetEventDestinationsResponse.getter(GetConfigurationSetEventDestinationsResponse::eventDestinations)).setter(GetConfigurationSetEventDestinationsResponse.setter(Builder::eventDestinations)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EventDestinations").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(EventDestination::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EVENT_DESTINATIONS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = GetConfigurationSetEventDestinationsResponse.memberNameToFieldInitializer();
    private final List<EventDestination> eventDestinations;

    private GetConfigurationSetEventDestinationsResponse(BuilderImpl builder) {
        super(builder);
        this.eventDestinations = builder.eventDestinations;
    }

    public final boolean hasEventDestinations() {
        return this.eventDestinations != null && !(this.eventDestinations instanceof SdkAutoConstructList);
    }

    public final List<EventDestination> eventDestinations() {
        return this.eventDestinations;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasEventDestinations() ? this.eventDestinations() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetConfigurationSetEventDestinationsResponse)) {
            return false;
        }
        GetConfigurationSetEventDestinationsResponse other = (GetConfigurationSetEventDestinationsResponse)((Object)obj);
        return this.hasEventDestinations() == other.hasEventDestinations() && Objects.equals(this.eventDestinations(), other.eventDestinations());
    }

    public final String toString() {
        return ToString.builder((String)"GetConfigurationSetEventDestinationsResponse").add("EventDestinations", this.hasEventDestinations() ? this.eventDestinations() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "EventDestinations": {
                return Optional.ofNullable(clazz.cast(this.eventDestinations()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<List<EventDestination>>> map = new HashMap<String, SdkField<List<EventDestination>>>();
        map.put("EventDestinations", EVENT_DESTINATIONS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetConfigurationSetEventDestinationsResponse, T> g) {
        return obj -> g.apply((GetConfigurationSetEventDestinationsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends PinpointSmsVoiceResponse.BuilderImpl
    implements Builder {
        private List<EventDestination> eventDestinations = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GetConfigurationSetEventDestinationsResponse model) {
            super(model);
            this.eventDestinations(model.eventDestinations);
        }

        public final List<EventDestination.Builder> getEventDestinations() {
            List<EventDestination.Builder> result = EventDestinationsCopier.copyToBuilder(this.eventDestinations);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setEventDestinations(Collection<EventDestination.BuilderImpl> eventDestinations) {
            this.eventDestinations = EventDestinationsCopier.copyFromBuilder(eventDestinations);
        }

        @Override
        public final Builder eventDestinations(Collection<EventDestination> eventDestinations) {
            this.eventDestinations = EventDestinationsCopier.copy(eventDestinations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder eventDestinations(EventDestination ... eventDestinations) {
            this.eventDestinations(Arrays.asList(eventDestinations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder eventDestinations(Consumer<EventDestination.Builder> ... eventDestinations) {
            this.eventDestinations(Stream.of(eventDestinations).map(c -> (EventDestination)((EventDestination.Builder)EventDestination.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public GetConfigurationSetEventDestinationsResponse build() {
            return new GetConfigurationSetEventDestinationsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends PinpointSmsVoiceResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetConfigurationSetEventDestinationsResponse> {
        public Builder eventDestinations(Collection<EventDestination> var1);

        public Builder eventDestinations(EventDestination ... var1);

        public Builder eventDestinations(Consumer<EventDestination.Builder> ... var1);
    }
}

