/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.pinpointsmsvoice.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SSMLMessageType
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, SSMLMessageType> {
    private static final SdkField<String> LANGUAGE_CODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("LanguageCode").getter(SSMLMessageType.getter(SSMLMessageType::languageCode)).setter(SSMLMessageType.setter(Builder::languageCode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LanguageCode").build()}).build();
    private static final SdkField<String> TEXT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Text").getter(SSMLMessageType.getter(SSMLMessageType::text)).setter(SSMLMessageType.setter(Builder::text)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Text").build()}).build();
    private static final SdkField<String> VOICE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("VoiceId").getter(SSMLMessageType.getter(SSMLMessageType::voiceId)).setter(SSMLMessageType.setter(Builder::voiceId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VoiceId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LANGUAGE_CODE_FIELD, TEXT_FIELD, VOICE_ID_FIELD));
    private static final long serialVersionUID = 1L;
    private final String languageCode;
    private final String text;
    private final String voiceId;

    private SSMLMessageType(BuilderImpl builder) {
        this.languageCode = builder.languageCode;
        this.text = builder.text;
        this.voiceId = builder.voiceId;
    }

    public final String languageCode() {
        return this.languageCode;
    }

    public final String text() {
        return this.text;
    }

    public final String voiceId() {
        return this.voiceId;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.languageCode());
        hashCode = 31 * hashCode + Objects.hashCode(this.text());
        hashCode = 31 * hashCode + Objects.hashCode(this.voiceId());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SSMLMessageType)) {
            return false;
        }
        SSMLMessageType other = (SSMLMessageType)obj;
        return Objects.equals(this.languageCode(), other.languageCode()) && Objects.equals(this.text(), other.text()) && Objects.equals(this.voiceId(), other.voiceId());
    }

    public final String toString() {
        return ToString.builder((String)"SSMLMessageType").add("LanguageCode", (Object)this.languageCode()).add("Text", (Object)this.text()).add("VoiceId", (Object)this.voiceId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "LanguageCode": {
                return Optional.ofNullable(clazz.cast(this.languageCode()));
            }
            case "Text": {
                return Optional.ofNullable(clazz.cast(this.text()));
            }
            case "VoiceId": {
                return Optional.ofNullable(clazz.cast(this.voiceId()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SSMLMessageType, T> g) {
        return obj -> g.apply((SSMLMessageType)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String languageCode;
        private String text;
        private String voiceId;

        private BuilderImpl() {
        }

        private BuilderImpl(SSMLMessageType model) {
            this.languageCode(model.languageCode);
            this.text(model.text);
            this.voiceId(model.voiceId);
        }

        public final String getLanguageCode() {
            return this.languageCode;
        }

        public final void setLanguageCode(String languageCode) {
            this.languageCode = languageCode;
        }

        @Override
        @Transient
        public final Builder languageCode(String languageCode) {
            this.languageCode = languageCode;
            return this;
        }

        public final String getText() {
            return this.text;
        }

        public final void setText(String text) {
            this.text = text;
        }

        @Override
        @Transient
        public final Builder text(String text) {
            this.text = text;
            return this;
        }

        public final String getVoiceId() {
            return this.voiceId;
        }

        public final void setVoiceId(String voiceId) {
            this.voiceId = voiceId;
        }

        @Override
        @Transient
        public final Builder voiceId(String voiceId) {
            this.voiceId = voiceId;
            return this;
        }

        public SSMLMessageType build() {
            return new SSMLMessageType(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, SSMLMessageType> {
        public Builder languageCode(String var1);

        public Builder text(String var1);

        public Builder voiceId(String var1);
    }
}

