/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.pinpointemail.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.pinpointemail.model.DeliverabilityTestReport;
import software.amazon.awssdk.services.pinpointemail.model.IspPlacement;
import software.amazon.awssdk.services.pinpointemail.model.IspPlacementsCopier;
import software.amazon.awssdk.services.pinpointemail.model.PinpointEmailResponse;
import software.amazon.awssdk.services.pinpointemail.model.PlacementStatistics;
import software.amazon.awssdk.services.pinpointemail.model.Tag;
import software.amazon.awssdk.services.pinpointemail.model.TagListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetDeliverabilityTestReportResponse
extends PinpointEmailResponse
implements ToCopyableBuilder<Builder, GetDeliverabilityTestReportResponse> {
    private static final SdkField<DeliverabilityTestReport> DELIVERABILITY_TEST_REPORT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(GetDeliverabilityTestReportResponse.getter(GetDeliverabilityTestReportResponse::deliverabilityTestReport)).setter(GetDeliverabilityTestReportResponse.setter(Builder::deliverabilityTestReport)).constructor(DeliverabilityTestReport::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeliverabilityTestReport").build()}).build();
    private static final SdkField<PlacementStatistics> OVERALL_PLACEMENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(GetDeliverabilityTestReportResponse.getter(GetDeliverabilityTestReportResponse::overallPlacement)).setter(GetDeliverabilityTestReportResponse.setter(Builder::overallPlacement)).constructor(PlacementStatistics::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OverallPlacement").build()}).build();
    private static final SdkField<List<IspPlacement>> ISP_PLACEMENTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(GetDeliverabilityTestReportResponse.getter(GetDeliverabilityTestReportResponse::ispPlacements)).setter(GetDeliverabilityTestReportResponse.setter(Builder::ispPlacements)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IspPlacements").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(IspPlacement::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> MESSAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(GetDeliverabilityTestReportResponse.getter(GetDeliverabilityTestReportResponse::message)).setter(GetDeliverabilityTestReportResponse.setter(Builder::message)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Message").build()}).build();
    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(GetDeliverabilityTestReportResponse.getter(GetDeliverabilityTestReportResponse::tags)).setter(GetDeliverabilityTestReportResponse.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Tag::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DELIVERABILITY_TEST_REPORT_FIELD, OVERALL_PLACEMENT_FIELD, ISP_PLACEMENTS_FIELD, MESSAGE_FIELD, TAGS_FIELD));
    private final DeliverabilityTestReport deliverabilityTestReport;
    private final PlacementStatistics overallPlacement;
    private final List<IspPlacement> ispPlacements;
    private final String message;
    private final List<Tag> tags;

    private GetDeliverabilityTestReportResponse(BuilderImpl builder) {
        super(builder);
        this.deliverabilityTestReport = builder.deliverabilityTestReport;
        this.overallPlacement = builder.overallPlacement;
        this.ispPlacements = builder.ispPlacements;
        this.message = builder.message;
        this.tags = builder.tags;
    }

    public DeliverabilityTestReport deliverabilityTestReport() {
        return this.deliverabilityTestReport;
    }

    public PlacementStatistics overallPlacement() {
        return this.overallPlacement;
    }

    public List<IspPlacement> ispPlacements() {
        return this.ispPlacements;
    }

    public String message() {
        return this.message;
    }

    public List<Tag> tags() {
        return this.tags;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.deliverabilityTestReport());
        hashCode = 31 * hashCode + Objects.hashCode(this.overallPlacement());
        hashCode = 31 * hashCode + Objects.hashCode(this.ispPlacements());
        hashCode = 31 * hashCode + Objects.hashCode(this.message());
        hashCode = 31 * hashCode + Objects.hashCode(this.tags());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetDeliverabilityTestReportResponse)) {
            return false;
        }
        GetDeliverabilityTestReportResponse other = (GetDeliverabilityTestReportResponse)((Object)obj);
        return Objects.equals(this.deliverabilityTestReport(), other.deliverabilityTestReport()) && Objects.equals(this.overallPlacement(), other.overallPlacement()) && Objects.equals(this.ispPlacements(), other.ispPlacements()) && Objects.equals(this.message(), other.message()) && Objects.equals(this.tags(), other.tags());
    }

    public String toString() {
        return ToString.builder((String)"GetDeliverabilityTestReportResponse").add("DeliverabilityTestReport", (Object)this.deliverabilityTestReport()).add("OverallPlacement", (Object)this.overallPlacement()).add("IspPlacements", this.ispPlacements()).add("Message", (Object)this.message()).add("Tags", this.tags()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DeliverabilityTestReport": {
                return Optional.ofNullable(clazz.cast(this.deliverabilityTestReport()));
            }
            case "OverallPlacement": {
                return Optional.ofNullable(clazz.cast(this.overallPlacement()));
            }
            case "IspPlacements": {
                return Optional.ofNullable(clazz.cast(this.ispPlacements()));
            }
            case "Message": {
                return Optional.ofNullable(clazz.cast(this.message()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetDeliverabilityTestReportResponse, T> g) {
        return obj -> g.apply((GetDeliverabilityTestReportResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends PinpointEmailResponse.BuilderImpl
    implements Builder {
        private DeliverabilityTestReport deliverabilityTestReport;
        private PlacementStatistics overallPlacement;
        private List<IspPlacement> ispPlacements = DefaultSdkAutoConstructList.getInstance();
        private String message;
        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GetDeliverabilityTestReportResponse model) {
            super(model);
            this.deliverabilityTestReport(model.deliverabilityTestReport);
            this.overallPlacement(model.overallPlacement);
            this.ispPlacements(model.ispPlacements);
            this.message(model.message);
            this.tags(model.tags);
        }

        public final DeliverabilityTestReport.Builder getDeliverabilityTestReport() {
            return this.deliverabilityTestReport != null ? this.deliverabilityTestReport.toBuilder() : null;
        }

        @Override
        public final Builder deliverabilityTestReport(DeliverabilityTestReport deliverabilityTestReport) {
            this.deliverabilityTestReport = deliverabilityTestReport;
            return this;
        }

        public final void setDeliverabilityTestReport(DeliverabilityTestReport.BuilderImpl deliverabilityTestReport) {
            this.deliverabilityTestReport = deliverabilityTestReport != null ? deliverabilityTestReport.build() : null;
        }

        public final PlacementStatistics.Builder getOverallPlacement() {
            return this.overallPlacement != null ? this.overallPlacement.toBuilder() : null;
        }

        @Override
        public final Builder overallPlacement(PlacementStatistics overallPlacement) {
            this.overallPlacement = overallPlacement;
            return this;
        }

        public final void setOverallPlacement(PlacementStatistics.BuilderImpl overallPlacement) {
            this.overallPlacement = overallPlacement != null ? overallPlacement.build() : null;
        }

        public final Collection<IspPlacement.Builder> getIspPlacements() {
            return this.ispPlacements != null ? (Collection)this.ispPlacements.stream().map(IspPlacement::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder ispPlacements(Collection<IspPlacement> ispPlacements) {
            this.ispPlacements = IspPlacementsCopier.copy(ispPlacements);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ispPlacements(IspPlacement ... ispPlacements) {
            this.ispPlacements(Arrays.asList(ispPlacements));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ispPlacements(Consumer<IspPlacement.Builder> ... ispPlacements) {
            this.ispPlacements(Stream.of(ispPlacements).map(c -> (IspPlacement)((IspPlacement.Builder)IspPlacement.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setIspPlacements(Collection<IspPlacement.BuilderImpl> ispPlacements) {
            this.ispPlacements = IspPlacementsCopier.copyFromBuilder(ispPlacements);
        }

        public final String getMessage() {
            return this.message;
        }

        @Override
        public final Builder message(String message) {
            this.message = message;
            return this;
        }

        public final void setMessage(String message) {
            this.message = message;
        }

        public final Collection<Tag.Builder> getTags() {
            return this.tags != null ? (Collection)this.tags.stream().map(Tag::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder> ... tags) {
            this.tags(Stream.of(tags).map(c -> (Tag)((Tag.Builder)Tag.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        public GetDeliverabilityTestReportResponse build() {
            return new GetDeliverabilityTestReportResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends PinpointEmailResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetDeliverabilityTestReportResponse> {
        public Builder deliverabilityTestReport(DeliverabilityTestReport var1);

        default public Builder deliverabilityTestReport(Consumer<DeliverabilityTestReport.Builder> deliverabilityTestReport) {
            return this.deliverabilityTestReport((DeliverabilityTestReport)((DeliverabilityTestReport.Builder)DeliverabilityTestReport.builder().applyMutation(deliverabilityTestReport)).build());
        }

        public Builder overallPlacement(PlacementStatistics var1);

        default public Builder overallPlacement(Consumer<PlacementStatistics.Builder> overallPlacement) {
            return this.overallPlacement((PlacementStatistics)((PlacementStatistics.Builder)PlacementStatistics.builder().applyMutation(overallPlacement)).build());
        }

        public Builder ispPlacements(Collection<IspPlacement> var1);

        public Builder ispPlacements(IspPlacement ... var1);

        public Builder ispPlacements(Consumer<IspPlacement.Builder> ... var1);

        public Builder message(String var1);

        public Builder tags(Collection<Tag> var1);

        public Builder tags(Tag ... var1);

        public Builder tags(Consumer<Tag.Builder> ... var1);
    }
}

