/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.pinpointemail.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.pinpointemail.model.InboxPlacementTrackingOption;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DomainDeliverabilityTrackingOption
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, DomainDeliverabilityTrackingOption> {
    private static final SdkField<String> DOMAIN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(DomainDeliverabilityTrackingOption.getter(DomainDeliverabilityTrackingOption::domain)).setter(DomainDeliverabilityTrackingOption.setter(Builder::domain)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Domain").build()}).build();
    private static final SdkField<Instant> SUBSCRIPTION_START_DATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).getter(DomainDeliverabilityTrackingOption.getter(DomainDeliverabilityTrackingOption::subscriptionStartDate)).setter(DomainDeliverabilityTrackingOption.setter(Builder::subscriptionStartDate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SubscriptionStartDate").build()}).build();
    private static final SdkField<InboxPlacementTrackingOption> INBOX_PLACEMENT_TRACKING_OPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(DomainDeliverabilityTrackingOption.getter(DomainDeliverabilityTrackingOption::inboxPlacementTrackingOption)).setter(DomainDeliverabilityTrackingOption.setter(Builder::inboxPlacementTrackingOption)).constructor(InboxPlacementTrackingOption::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InboxPlacementTrackingOption").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DOMAIN_FIELD, SUBSCRIPTION_START_DATE_FIELD, INBOX_PLACEMENT_TRACKING_OPTION_FIELD));
    private static final long serialVersionUID = 1L;
    private final String domain;
    private final Instant subscriptionStartDate;
    private final InboxPlacementTrackingOption inboxPlacementTrackingOption;

    private DomainDeliverabilityTrackingOption(BuilderImpl builder) {
        this.domain = builder.domain;
        this.subscriptionStartDate = builder.subscriptionStartDate;
        this.inboxPlacementTrackingOption = builder.inboxPlacementTrackingOption;
    }

    public String domain() {
        return this.domain;
    }

    public Instant subscriptionStartDate() {
        return this.subscriptionStartDate;
    }

    public InboxPlacementTrackingOption inboxPlacementTrackingOption() {
        return this.inboxPlacementTrackingOption;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.domain());
        hashCode = 31 * hashCode + Objects.hashCode(this.subscriptionStartDate());
        hashCode = 31 * hashCode + Objects.hashCode(this.inboxPlacementTrackingOption());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DomainDeliverabilityTrackingOption)) {
            return false;
        }
        DomainDeliverabilityTrackingOption other = (DomainDeliverabilityTrackingOption)obj;
        return Objects.equals(this.domain(), other.domain()) && Objects.equals(this.subscriptionStartDate(), other.subscriptionStartDate()) && Objects.equals(this.inboxPlacementTrackingOption(), other.inboxPlacementTrackingOption());
    }

    public String toString() {
        return ToString.builder((String)"DomainDeliverabilityTrackingOption").add("Domain", (Object)this.domain()).add("SubscriptionStartDate", (Object)this.subscriptionStartDate()).add("InboxPlacementTrackingOption", (Object)this.inboxPlacementTrackingOption()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Domain": {
                return Optional.ofNullable(clazz.cast(this.domain()));
            }
            case "SubscriptionStartDate": {
                return Optional.ofNullable(clazz.cast(this.subscriptionStartDate()));
            }
            case "InboxPlacementTrackingOption": {
                return Optional.ofNullable(clazz.cast(this.inboxPlacementTrackingOption()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DomainDeliverabilityTrackingOption, T> g) {
        return obj -> g.apply((DomainDeliverabilityTrackingOption)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String domain;
        private Instant subscriptionStartDate;
        private InboxPlacementTrackingOption inboxPlacementTrackingOption;

        private BuilderImpl() {
        }

        private BuilderImpl(DomainDeliverabilityTrackingOption model) {
            this.domain(model.domain);
            this.subscriptionStartDate(model.subscriptionStartDate);
            this.inboxPlacementTrackingOption(model.inboxPlacementTrackingOption);
        }

        public final String getDomain() {
            return this.domain;
        }

        @Override
        public final Builder domain(String domain) {
            this.domain = domain;
            return this;
        }

        public final void setDomain(String domain) {
            this.domain = domain;
        }

        public final Instant getSubscriptionStartDate() {
            return this.subscriptionStartDate;
        }

        @Override
        public final Builder subscriptionStartDate(Instant subscriptionStartDate) {
            this.subscriptionStartDate = subscriptionStartDate;
            return this;
        }

        public final void setSubscriptionStartDate(Instant subscriptionStartDate) {
            this.subscriptionStartDate = subscriptionStartDate;
        }

        public final InboxPlacementTrackingOption.Builder getInboxPlacementTrackingOption() {
            return this.inboxPlacementTrackingOption != null ? this.inboxPlacementTrackingOption.toBuilder() : null;
        }

        @Override
        public final Builder inboxPlacementTrackingOption(InboxPlacementTrackingOption inboxPlacementTrackingOption) {
            this.inboxPlacementTrackingOption = inboxPlacementTrackingOption;
            return this;
        }

        public final void setInboxPlacementTrackingOption(InboxPlacementTrackingOption.BuilderImpl inboxPlacementTrackingOption) {
            this.inboxPlacementTrackingOption = inboxPlacementTrackingOption != null ? inboxPlacementTrackingOption.build() : null;
        }

        public DomainDeliverabilityTrackingOption build() {
            return new DomainDeliverabilityTrackingOption(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, DomainDeliverabilityTrackingOption> {
        public Builder domain(String var1);

        public Builder subscriptionStartDate(Instant var1);

        public Builder inboxPlacementTrackingOption(InboxPlacementTrackingOption var1);

        default public Builder inboxPlacementTrackingOption(Consumer<InboxPlacementTrackingOption.Builder> inboxPlacementTrackingOption) {
            return this.inboxPlacementTrackingOption((InboxPlacementTrackingOption)((InboxPlacementTrackingOption.Builder)InboxPlacementTrackingOption.builder().applyMutation(inboxPlacementTrackingOption)).build());
        }
    }
}

