/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.pinpointemail.paginators;

import java.util.Collections;
import java.util.Iterator;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.pinpointemail.PinpointEmailClient;
import software.amazon.awssdk.services.pinpointemail.model.ListConfigurationSetsRequest;
import software.amazon.awssdk.services.pinpointemail.model.ListConfigurationSetsResponse;

public class ListConfigurationSetsIterable
implements SdkIterable<ListConfigurationSetsResponse> {
    private final PinpointEmailClient client;
    private final ListConfigurationSetsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListConfigurationSetsIterable(PinpointEmailClient client, ListConfigurationSetsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListConfigurationSetsResponseFetcher();
    }

    public Iterator<ListConfigurationSetsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    private final ListConfigurationSetsIterable resume(ListConfigurationSetsResponse lastSuccessfulPage) {
        if (this.nextPageFetcher.hasNextPage((Object)lastSuccessfulPage)) {
            return new ListConfigurationSetsIterable(this.client, (ListConfigurationSetsRequest)((Object)this.firstRequest.toBuilder().nextToken(lastSuccessfulPage.nextToken()).build()));
        }
        return new ListConfigurationSetsIterable(this.client, this.firstRequest){

            @Override
            public Iterator<ListConfigurationSetsResponse> iterator() {
                return Collections.emptyIterator();
            }
        };
    }

    private class ListConfigurationSetsResponseFetcher
    implements SyncPageFetcher<ListConfigurationSetsResponse> {
        private ListConfigurationSetsResponseFetcher() {
        }

        public boolean hasNextPage(ListConfigurationSetsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListConfigurationSetsResponse nextPage(ListConfigurationSetsResponse previousPage) {
            if (previousPage == null) {
                return ListConfigurationSetsIterable.this.client.listConfigurationSets(ListConfigurationSetsIterable.this.firstRequest);
            }
            return ListConfigurationSetsIterable.this.client.listConfigurationSets((ListConfigurationSetsRequest)((Object)ListConfigurationSetsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

