/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.pinpoint.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.pinpoint.model.DimensionType;
import software.amazon.awssdk.services.pinpoint.model.ListOf__stringCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SetDimension
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, SetDimension> {
    private static final SdkField<String> DIMENSION_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(SetDimension.getter(SetDimension::dimensionTypeAsString)).setter(SetDimension.setter(Builder::dimensionType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DimensionType").build()}).build();
    private static final SdkField<List<String>> VALUES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(SetDimension.getter(SetDimension::values)).setter(SetDimension.setter(Builder::values)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Values").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DIMENSION_TYPE_FIELD, VALUES_FIELD));
    private static final long serialVersionUID = 1L;
    private final String dimensionType;
    private final List<String> values;

    private SetDimension(BuilderImpl builder) {
        this.dimensionType = builder.dimensionType;
        this.values = builder.values;
    }

    public DimensionType dimensionType() {
        return DimensionType.fromValue(this.dimensionType);
    }

    public String dimensionTypeAsString() {
        return this.dimensionType;
    }

    public List<String> values() {
        return this.values;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.dimensionTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.values());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SetDimension)) {
            return false;
        }
        SetDimension other = (SetDimension)obj;
        return Objects.equals(this.dimensionTypeAsString(), other.dimensionTypeAsString()) && Objects.equals(this.values(), other.values());
    }

    public String toString() {
        return ToString.builder((String)"SetDimension").add("DimensionType", (Object)this.dimensionTypeAsString()).add("Values", this.values()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DimensionType": {
                return Optional.ofNullable(clazz.cast(this.dimensionTypeAsString()));
            }
            case "Values": {
                return Optional.ofNullable(clazz.cast(this.values()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SetDimension, T> g) {
        return obj -> g.apply((SetDimension)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String dimensionType;
        private List<String> values = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(SetDimension model) {
            this.dimensionType(model.dimensionType);
            this.values(model.values);
        }

        public final String getDimensionTypeAsString() {
            return this.dimensionType;
        }

        @Override
        public final Builder dimensionType(String dimensionType) {
            this.dimensionType = dimensionType;
            return this;
        }

        @Override
        public final Builder dimensionType(DimensionType dimensionType) {
            this.dimensionType(dimensionType == null ? null : dimensionType.toString());
            return this;
        }

        public final void setDimensionType(String dimensionType) {
            this.dimensionType = dimensionType;
        }

        public final Collection<String> getValues() {
            return this.values;
        }

        @Override
        public final Builder values(Collection<String> values) {
            this.values = ListOf__stringCopier.copy(values);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder values(String ... values) {
            this.values(Arrays.asList(values));
            return this;
        }

        public final void setValues(Collection<String> values) {
            this.values = ListOf__stringCopier.copy(values);
        }

        public SetDimension build() {
            return new SetDimension(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, SetDimension> {
        public Builder dimensionType(String var1);

        public Builder dimensionType(DimensionType var1);

        public Builder values(Collection<String> var1);

        public Builder values(String ... var1);
    }
}

