/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.pinpoint.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.PayloadTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.pinpoint.model.EmailChannelRequest;
import software.amazon.awssdk.services.pinpoint.model.PinpointRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateEmailChannelRequest
extends PinpointRequest
implements ToCopyableBuilder<Builder, UpdateEmailChannelRequest> {
    private static final SdkField<String> APPLICATION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(UpdateEmailChannelRequest.getter(UpdateEmailChannelRequest::applicationId)).setter(UpdateEmailChannelRequest.setter(Builder::applicationId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("application-id").build()}).build();
    private static final SdkField<EmailChannelRequest> EMAIL_CHANNEL_REQUEST_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(UpdateEmailChannelRequest.getter(UpdateEmailChannelRequest::emailChannelRequest)).setter(UpdateEmailChannelRequest.setter(Builder::emailChannelRequest)).constructor(EmailChannelRequest::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EmailChannelRequest").build(), PayloadTrait.create()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APPLICATION_ID_FIELD, EMAIL_CHANNEL_REQUEST_FIELD));
    private final String applicationId;
    private final EmailChannelRequest emailChannelRequest;

    private UpdateEmailChannelRequest(BuilderImpl builder) {
        super(builder);
        this.applicationId = builder.applicationId;
        this.emailChannelRequest = builder.emailChannelRequest;
    }

    public String applicationId() {
        return this.applicationId;
    }

    public EmailChannelRequest emailChannelRequest() {
        return this.emailChannelRequest;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.applicationId());
        hashCode = 31 * hashCode + Objects.hashCode(this.emailChannelRequest());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateEmailChannelRequest)) {
            return false;
        }
        UpdateEmailChannelRequest other = (UpdateEmailChannelRequest)((Object)obj);
        return Objects.equals(this.applicationId(), other.applicationId()) && Objects.equals(this.emailChannelRequest(), other.emailChannelRequest());
    }

    public String toString() {
        return ToString.builder((String)"UpdateEmailChannelRequest").add("ApplicationId", (Object)this.applicationId()).add("EmailChannelRequest", (Object)this.emailChannelRequest()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ApplicationId": {
                return Optional.ofNullable(clazz.cast(this.applicationId()));
            }
            case "EmailChannelRequest": {
                return Optional.ofNullable(clazz.cast(this.emailChannelRequest()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateEmailChannelRequest, T> g) {
        return obj -> g.apply((UpdateEmailChannelRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends PinpointRequest.BuilderImpl
    implements Builder {
        private String applicationId;
        private EmailChannelRequest emailChannelRequest;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateEmailChannelRequest model) {
            super(model);
            this.applicationId(model.applicationId);
            this.emailChannelRequest(model.emailChannelRequest);
        }

        public final String getApplicationId() {
            return this.applicationId;
        }

        @Override
        public final Builder applicationId(String applicationId) {
            this.applicationId = applicationId;
            return this;
        }

        public final void setApplicationId(String applicationId) {
            this.applicationId = applicationId;
        }

        public final EmailChannelRequest.Builder getEmailChannelRequest() {
            return this.emailChannelRequest != null ? this.emailChannelRequest.toBuilder() : null;
        }

        @Override
        public final Builder emailChannelRequest(EmailChannelRequest emailChannelRequest) {
            this.emailChannelRequest = emailChannelRequest;
            return this;
        }

        public final void setEmailChannelRequest(EmailChannelRequest.BuilderImpl emailChannelRequest) {
            this.emailChannelRequest = emailChannelRequest != null ? emailChannelRequest.build() : null;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateEmailChannelRequest build() {
            return new UpdateEmailChannelRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends PinpointRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateEmailChannelRequest> {
        public Builder applicationId(String var1);

        public Builder emailChannelRequest(EmailChannelRequest var1);

        default public Builder emailChannelRequest(Consumer<EmailChannelRequest.Builder> emailChannelRequest) {
            return this.emailChannelRequest((EmailChannelRequest)((EmailChannelRequest.Builder)EmailChannelRequest.builder().applyMutation(emailChannelRequest)).build());
        }

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

