/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.pinpoint.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.pinpoint.model.PinpointRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetApplicationDateRangeKpiRequest
extends PinpointRequest
implements ToCopyableBuilder<Builder, GetApplicationDateRangeKpiRequest> {
    private static final SdkField<String> APPLICATION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(GetApplicationDateRangeKpiRequest.getter(GetApplicationDateRangeKpiRequest::applicationId)).setter(GetApplicationDateRangeKpiRequest.setter(Builder::applicationId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("application-id").build()}).build();
    private static final SdkField<Instant> END_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).getter(GetApplicationDateRangeKpiRequest.getter(GetApplicationDateRangeKpiRequest::endTime)).setter(GetApplicationDateRangeKpiRequest.setter(Builder::endTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("end-time").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<String> KPI_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(GetApplicationDateRangeKpiRequest.getter(GetApplicationDateRangeKpiRequest::kpiName)).setter(GetApplicationDateRangeKpiRequest.setter(Builder::kpiName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("kpi-name").build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(GetApplicationDateRangeKpiRequest.getter(GetApplicationDateRangeKpiRequest::nextToken)).setter(GetApplicationDateRangeKpiRequest.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("next-token").build()}).build();
    private static final SdkField<String> PAGE_SIZE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(GetApplicationDateRangeKpiRequest.getter(GetApplicationDateRangeKpiRequest::pageSize)).setter(GetApplicationDateRangeKpiRequest.setter(Builder::pageSize)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("page-size").build()}).build();
    private static final SdkField<Instant> START_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).getter(GetApplicationDateRangeKpiRequest.getter(GetApplicationDateRangeKpiRequest::startTime)).setter(GetApplicationDateRangeKpiRequest.setter(Builder::startTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("start-time").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APPLICATION_ID_FIELD, END_TIME_FIELD, KPI_NAME_FIELD, NEXT_TOKEN_FIELD, PAGE_SIZE_FIELD, START_TIME_FIELD));
    private final String applicationId;
    private final Instant endTime;
    private final String kpiName;
    private final String nextToken;
    private final String pageSize;
    private final Instant startTime;

    private GetApplicationDateRangeKpiRequest(BuilderImpl builder) {
        super(builder);
        this.applicationId = builder.applicationId;
        this.endTime = builder.endTime;
        this.kpiName = builder.kpiName;
        this.nextToken = builder.nextToken;
        this.pageSize = builder.pageSize;
        this.startTime = builder.startTime;
    }

    public String applicationId() {
        return this.applicationId;
    }

    public Instant endTime() {
        return this.endTime;
    }

    public String kpiName() {
        return this.kpiName;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public String pageSize() {
        return this.pageSize;
    }

    public Instant startTime() {
        return this.startTime;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.applicationId());
        hashCode = 31 * hashCode + Objects.hashCode(this.endTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.kpiName());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.pageSize());
        hashCode = 31 * hashCode + Objects.hashCode(this.startTime());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetApplicationDateRangeKpiRequest)) {
            return false;
        }
        GetApplicationDateRangeKpiRequest other = (GetApplicationDateRangeKpiRequest)((Object)obj);
        return Objects.equals(this.applicationId(), other.applicationId()) && Objects.equals(this.endTime(), other.endTime()) && Objects.equals(this.kpiName(), other.kpiName()) && Objects.equals(this.nextToken(), other.nextToken()) && Objects.equals(this.pageSize(), other.pageSize()) && Objects.equals(this.startTime(), other.startTime());
    }

    public String toString() {
        return ToString.builder((String)"GetApplicationDateRangeKpiRequest").add("ApplicationId", (Object)this.applicationId()).add("EndTime", (Object)this.endTime()).add("KpiName", (Object)this.kpiName()).add("NextToken", (Object)this.nextToken()).add("PageSize", (Object)this.pageSize()).add("StartTime", (Object)this.startTime()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ApplicationId": {
                return Optional.ofNullable(clazz.cast(this.applicationId()));
            }
            case "EndTime": {
                return Optional.ofNullable(clazz.cast(this.endTime()));
            }
            case "KpiName": {
                return Optional.ofNullable(clazz.cast(this.kpiName()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "PageSize": {
                return Optional.ofNullable(clazz.cast(this.pageSize()));
            }
            case "StartTime": {
                return Optional.ofNullable(clazz.cast(this.startTime()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetApplicationDateRangeKpiRequest, T> g) {
        return obj -> g.apply((GetApplicationDateRangeKpiRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends PinpointRequest.BuilderImpl
    implements Builder {
        private String applicationId;
        private Instant endTime;
        private String kpiName;
        private String nextToken;
        private String pageSize;
        private Instant startTime;

        private BuilderImpl() {
        }

        private BuilderImpl(GetApplicationDateRangeKpiRequest model) {
            super(model);
            this.applicationId(model.applicationId);
            this.endTime(model.endTime);
            this.kpiName(model.kpiName);
            this.nextToken(model.nextToken);
            this.pageSize(model.pageSize);
            this.startTime(model.startTime);
        }

        public final String getApplicationId() {
            return this.applicationId;
        }

        @Override
        public final Builder applicationId(String applicationId) {
            this.applicationId = applicationId;
            return this;
        }

        public final void setApplicationId(String applicationId) {
            this.applicationId = applicationId;
        }

        public final Instant getEndTime() {
            return this.endTime;
        }

        @Override
        public final Builder endTime(Instant endTime) {
            this.endTime = endTime;
            return this;
        }

        public final void setEndTime(Instant endTime) {
            this.endTime = endTime;
        }

        public final String getKpiName() {
            return this.kpiName;
        }

        @Override
        public final Builder kpiName(String kpiName) {
            this.kpiName = kpiName;
            return this;
        }

        public final void setKpiName(String kpiName) {
            this.kpiName = kpiName;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public final String getPageSize() {
            return this.pageSize;
        }

        @Override
        public final Builder pageSize(String pageSize) {
            this.pageSize = pageSize;
            return this;
        }

        public final void setPageSize(String pageSize) {
            this.pageSize = pageSize;
        }

        public final Instant getStartTime() {
            return this.startTime;
        }

        @Override
        public final Builder startTime(Instant startTime) {
            this.startTime = startTime;
            return this;
        }

        public final void setStartTime(Instant startTime) {
            this.startTime = startTime;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetApplicationDateRangeKpiRequest build() {
            return new GetApplicationDateRangeKpiRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends PinpointRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetApplicationDateRangeKpiRequest> {
        public Builder applicationId(String var1);

        public Builder endTime(Instant var1);

        public Builder kpiName(String var1);

        public Builder nextToken(String var1);

        public Builder pageSize(String var1);

        public Builder startTime(Instant var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

