/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.pinpoint.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.services.pinpoint.model.ItemResponse;
import software.amazon.awssdk.services.pinpoint.model.MapOfItemResponseCopier;
import software.amazon.awssdk.utils.CollectionUtils;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class EventsResponse
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, EventsResponse> {
    private static final SdkField<Map<String, ItemResponse>> RESULTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).getter(EventsResponse.getter(EventsResponse::results)).setter(EventsResponse.setter(Builder::results)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Results").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ItemResponse::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RESULTS_FIELD));
    private static final long serialVersionUID = 1L;
    private final Map<String, ItemResponse> results;

    private EventsResponse(BuilderImpl builder) {
        this.results = builder.results;
    }

    public Map<String, ItemResponse> results() {
        return this.results;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.results());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EventsResponse)) {
            return false;
        }
        EventsResponse other = (EventsResponse)obj;
        return Objects.equals(this.results(), other.results());
    }

    public String toString() {
        return ToString.builder((String)"EventsResponse").add("Results", this.results()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Results": {
                return Optional.ofNullable(clazz.cast(this.results()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<EventsResponse, T> g) {
        return obj -> g.apply((EventsResponse)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Map<String, ItemResponse> results = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(EventsResponse model) {
            this.results(model.results);
        }

        public final Map<String, ItemResponse.Builder> getResults() {
            return this.results != null ? CollectionUtils.mapValues(this.results, ItemResponse::toBuilder) : null;
        }

        @Override
        public final Builder results(Map<String, ItemResponse> results) {
            this.results = MapOfItemResponseCopier.copy(results);
            return this;
        }

        public final void setResults(Map<String, ItemResponse.BuilderImpl> results) {
            this.results = MapOfItemResponseCopier.copyFromBuilder(results);
        }

        public EventsResponse build() {
            return new EventsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, EventsResponse> {
        public Builder results(Map<String, ItemResponse> var1);
    }
}

