/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.pinpoint.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GPSCoordinates
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, GPSCoordinates> {
    private static final SdkField<Double> LATITUDE_FIELD = SdkField.builder((MarshallingType)MarshallingType.DOUBLE).getter(GPSCoordinates.getter(GPSCoordinates::latitude)).setter(GPSCoordinates.setter(Builder::latitude)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Latitude").build()}).build();
    private static final SdkField<Double> LONGITUDE_FIELD = SdkField.builder((MarshallingType)MarshallingType.DOUBLE).getter(GPSCoordinates.getter(GPSCoordinates::longitude)).setter(GPSCoordinates.setter(Builder::longitude)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Longitude").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LATITUDE_FIELD, LONGITUDE_FIELD));
    private static final long serialVersionUID = 1L;
    private final Double latitude;
    private final Double longitude;

    private GPSCoordinates(BuilderImpl builder) {
        this.latitude = builder.latitude;
        this.longitude = builder.longitude;
    }

    public Double latitude() {
        return this.latitude;
    }

    public Double longitude() {
        return this.longitude;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.latitude());
        hashCode = 31 * hashCode + Objects.hashCode(this.longitude());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GPSCoordinates)) {
            return false;
        }
        GPSCoordinates other = (GPSCoordinates)obj;
        return Objects.equals(this.latitude(), other.latitude()) && Objects.equals(this.longitude(), other.longitude());
    }

    public String toString() {
        return ToString.builder((String)"GPSCoordinates").add("Latitude", (Object)this.latitude()).add("Longitude", (Object)this.longitude()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Latitude": {
                return Optional.ofNullable(clazz.cast(this.latitude()));
            }
            case "Longitude": {
                return Optional.ofNullable(clazz.cast(this.longitude()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GPSCoordinates, T> g) {
        return obj -> g.apply((GPSCoordinates)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Double latitude;
        private Double longitude;

        private BuilderImpl() {
        }

        private BuilderImpl(GPSCoordinates model) {
            this.latitude(model.latitude);
            this.longitude(model.longitude);
        }

        public final Double getLatitude() {
            return this.latitude;
        }

        @Override
        public final Builder latitude(Double latitude) {
            this.latitude = latitude;
            return this;
        }

        public final void setLatitude(Double latitude) {
            this.latitude = latitude;
        }

        public final Double getLongitude() {
            return this.longitude;
        }

        @Override
        public final Builder longitude(Double longitude) {
            this.longitude = longitude;
            return this;
        }

        public final void setLongitude(Double longitude) {
            this.longitude = longitude;
        }

        public GPSCoordinates build() {
            return new GPSCoordinates(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, GPSCoordinates> {
        public Builder latitude(Double var1);

        public Builder longitude(Double var1);
    }
}

