/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.pinpoint.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.pinpoint.model.MessageType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CampaignSmsMessage
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, CampaignSmsMessage> {
    private static final SdkField<String> BODY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CampaignSmsMessage.getter(CampaignSmsMessage::body)).setter(CampaignSmsMessage.setter(Builder::body)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Body").build()}).build();
    private static final SdkField<String> MESSAGE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CampaignSmsMessage.getter(CampaignSmsMessage::messageTypeAsString)).setter(CampaignSmsMessage.setter(Builder::messageType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MessageType").build()}).build();
    private static final SdkField<String> SENDER_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CampaignSmsMessage.getter(CampaignSmsMessage::senderId)).setter(CampaignSmsMessage.setter(Builder::senderId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SenderId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BODY_FIELD, MESSAGE_TYPE_FIELD, SENDER_ID_FIELD));
    private static final long serialVersionUID = 1L;
    private final String body;
    private final String messageType;
    private final String senderId;

    private CampaignSmsMessage(BuilderImpl builder) {
        this.body = builder.body;
        this.messageType = builder.messageType;
        this.senderId = builder.senderId;
    }

    public String body() {
        return this.body;
    }

    public MessageType messageType() {
        return MessageType.fromValue(this.messageType);
    }

    public String messageTypeAsString() {
        return this.messageType;
    }

    public String senderId() {
        return this.senderId;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.body());
        hashCode = 31 * hashCode + Objects.hashCode(this.messageTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.senderId());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CampaignSmsMessage)) {
            return false;
        }
        CampaignSmsMessage other = (CampaignSmsMessage)obj;
        return Objects.equals(this.body(), other.body()) && Objects.equals(this.messageTypeAsString(), other.messageTypeAsString()) && Objects.equals(this.senderId(), other.senderId());
    }

    public String toString() {
        return ToString.builder((String)"CampaignSmsMessage").add("Body", (Object)this.body()).add("MessageType", (Object)this.messageTypeAsString()).add("SenderId", (Object)this.senderId()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Body": {
                return Optional.ofNullable(clazz.cast(this.body()));
            }
            case "MessageType": {
                return Optional.ofNullable(clazz.cast(this.messageTypeAsString()));
            }
            case "SenderId": {
                return Optional.ofNullable(clazz.cast(this.senderId()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CampaignSmsMessage, T> g) {
        return obj -> g.apply((CampaignSmsMessage)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String body;
        private String messageType;
        private String senderId;

        private BuilderImpl() {
        }

        private BuilderImpl(CampaignSmsMessage model) {
            this.body(model.body);
            this.messageType(model.messageType);
            this.senderId(model.senderId);
        }

        public final String getBody() {
            return this.body;
        }

        @Override
        public final Builder body(String body) {
            this.body = body;
            return this;
        }

        public final void setBody(String body) {
            this.body = body;
        }

        public final String getMessageTypeAsString() {
            return this.messageType;
        }

        @Override
        public final Builder messageType(String messageType) {
            this.messageType = messageType;
            return this;
        }

        @Override
        public final Builder messageType(MessageType messageType) {
            this.messageType(messageType.toString());
            return this;
        }

        public final void setMessageType(String messageType) {
            this.messageType = messageType;
        }

        public final String getSenderId() {
            return this.senderId;
        }

        @Override
        public final Builder senderId(String senderId) {
            this.senderId = senderId;
            return this;
        }

        public final void setSenderId(String senderId) {
            this.senderId = senderId;
        }

        public CampaignSmsMessage build() {
            return new CampaignSmsMessage(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, CampaignSmsMessage> {
        public Builder body(String var1);

        public Builder messageType(String var1);

        public Builder messageType(MessageType var1);

        public Builder senderId(String var1);
    }
}

