/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.pinpoint.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.PayloadTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.pinpoint.model.APNSSandboxChannelRequest;
import software.amazon.awssdk.services.pinpoint.model.PinpointRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateApnsSandboxChannelRequest
extends PinpointRequest
implements ToCopyableBuilder<Builder, UpdateApnsSandboxChannelRequest> {
    private static final SdkField<APNSSandboxChannelRequest> APNS_SANDBOX_CHANNEL_REQUEST_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(UpdateApnsSandboxChannelRequest.getter(UpdateApnsSandboxChannelRequest::apnsSandboxChannelRequest)).setter(UpdateApnsSandboxChannelRequest.setter(Builder::apnsSandboxChannelRequest)).constructor(APNSSandboxChannelRequest::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("APNSSandboxChannelRequest").build(), PayloadTrait.create()}).build();
    private static final SdkField<String> APPLICATION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(UpdateApnsSandboxChannelRequest.getter(UpdateApnsSandboxChannelRequest::applicationId)).setter(UpdateApnsSandboxChannelRequest.setter(Builder::applicationId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("application-id").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APNS_SANDBOX_CHANNEL_REQUEST_FIELD, APPLICATION_ID_FIELD));
    private final APNSSandboxChannelRequest apnsSandboxChannelRequest;
    private final String applicationId;

    private UpdateApnsSandboxChannelRequest(BuilderImpl builder) {
        super(builder);
        this.apnsSandboxChannelRequest = builder.apnsSandboxChannelRequest;
        this.applicationId = builder.applicationId;
    }

    public APNSSandboxChannelRequest apnsSandboxChannelRequest() {
        return this.apnsSandboxChannelRequest;
    }

    public String applicationId() {
        return this.applicationId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.apnsSandboxChannelRequest());
        hashCode = 31 * hashCode + Objects.hashCode(this.applicationId());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateApnsSandboxChannelRequest)) {
            return false;
        }
        UpdateApnsSandboxChannelRequest other = (UpdateApnsSandboxChannelRequest)((Object)obj);
        return Objects.equals(this.apnsSandboxChannelRequest(), other.apnsSandboxChannelRequest()) && Objects.equals(this.applicationId(), other.applicationId());
    }

    public String toString() {
        return ToString.builder((String)"UpdateApnsSandboxChannelRequest").add("APNSSandboxChannelRequest", (Object)this.apnsSandboxChannelRequest()).add("ApplicationId", (Object)this.applicationId()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "APNSSandboxChannelRequest": {
                return Optional.ofNullable(clazz.cast(this.apnsSandboxChannelRequest()));
            }
            case "ApplicationId": {
                return Optional.ofNullable(clazz.cast(this.applicationId()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateApnsSandboxChannelRequest, T> g) {
        return obj -> g.apply((UpdateApnsSandboxChannelRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends PinpointRequest.BuilderImpl
    implements Builder {
        private APNSSandboxChannelRequest apnsSandboxChannelRequest;
        private String applicationId;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateApnsSandboxChannelRequest model) {
            super(model);
            this.apnsSandboxChannelRequest(model.apnsSandboxChannelRequest);
            this.applicationId(model.applicationId);
        }

        public final APNSSandboxChannelRequest.Builder getApnsSandboxChannelRequest() {
            return this.apnsSandboxChannelRequest != null ? this.apnsSandboxChannelRequest.toBuilder() : null;
        }

        @Override
        public final Builder apnsSandboxChannelRequest(APNSSandboxChannelRequest apnsSandboxChannelRequest) {
            this.apnsSandboxChannelRequest = apnsSandboxChannelRequest;
            return this;
        }

        public final void setApnsSandboxChannelRequest(APNSSandboxChannelRequest.BuilderImpl apnsSandboxChannelRequest) {
            this.apnsSandboxChannelRequest = apnsSandboxChannelRequest != null ? apnsSandboxChannelRequest.build() : null;
        }

        public final String getApplicationId() {
            return this.applicationId;
        }

        @Override
        public final Builder applicationId(String applicationId) {
            this.applicationId = applicationId;
            return this;
        }

        public final void setApplicationId(String applicationId) {
            this.applicationId = applicationId;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateApnsSandboxChannelRequest build() {
            return new UpdateApnsSandboxChannelRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends PinpointRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateApnsSandboxChannelRequest> {
        public Builder apnsSandboxChannelRequest(APNSSandboxChannelRequest var1);

        default public Builder apnsSandboxChannelRequest(Consumer<APNSSandboxChannelRequest.Builder> apnsSandboxChannelRequest) {
            return this.apnsSandboxChannelRequest((APNSSandboxChannelRequest)((APNSSandboxChannelRequest.Builder)APNSSandboxChannelRequest.builder().applyMutation(apnsSandboxChannelRequest)).build());
        }

        public Builder applicationId(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

