/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.pinpoint.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.pinpoint.model.Activity;
import software.amazon.awssdk.services.pinpoint.model.ClosedDays;
import software.amazon.awssdk.services.pinpoint.model.JourneyChannelSettings;
import software.amazon.awssdk.services.pinpoint.model.JourneyLimits;
import software.amazon.awssdk.services.pinpoint.model.JourneySchedule;
import software.amazon.awssdk.services.pinpoint.model.ListOf__TimezoneEstimationMethodsElementCopier;
import software.amazon.awssdk.services.pinpoint.model.MapOfActivityCopier;
import software.amazon.awssdk.services.pinpoint.model.MapOf__stringCopier;
import software.amazon.awssdk.services.pinpoint.model.OpenHours;
import software.amazon.awssdk.services.pinpoint.model.QuietTime;
import software.amazon.awssdk.services.pinpoint.model.StartCondition;
import software.amazon.awssdk.services.pinpoint.model.State;
import software.amazon.awssdk.services.pinpoint.model.__TimezoneEstimationMethodsElement;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class JourneyResponse
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, JourneyResponse> {
    private static final SdkField<Map<String, Activity>> ACTIVITIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("Activities").getter(JourneyResponse.getter(JourneyResponse::activities)).setter(JourneyResponse.setter(Builder::activities)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Activities").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Activity::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<String> APPLICATION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ApplicationId").getter(JourneyResponse.getter(JourneyResponse::applicationId)).setter(JourneyResponse.setter(Builder::applicationId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ApplicationId").build()}).build();
    private static final SdkField<String> CREATION_DATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CreationDate").getter(JourneyResponse.getter(JourneyResponse::creationDate)).setter(JourneyResponse.setter(Builder::creationDate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationDate").build()}).build();
    private static final SdkField<String> ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Id").getter(JourneyResponse.getter(JourneyResponse::id)).setter(JourneyResponse.setter(Builder::id)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Id").build()}).build();
    private static final SdkField<String> LAST_MODIFIED_DATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("LastModifiedDate").getter(JourneyResponse.getter(JourneyResponse::lastModifiedDate)).setter(JourneyResponse.setter(Builder::lastModifiedDate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastModifiedDate").build()}).build();
    private static final SdkField<JourneyLimits> LIMITS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Limits").getter(JourneyResponse.getter(JourneyResponse::limits)).setter(JourneyResponse.setter(Builder::limits)).constructor(JourneyLimits::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Limits").build()}).build();
    private static final SdkField<Boolean> LOCAL_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("LocalTime").getter(JourneyResponse.getter(JourneyResponse::localTime)).setter(JourneyResponse.setter(Builder::localTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LocalTime").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(JourneyResponse.getter(JourneyResponse::name)).setter(JourneyResponse.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<QuietTime> QUIET_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("QuietTime").getter(JourneyResponse.getter(JourneyResponse::quietTime)).setter(JourneyResponse.setter(Builder::quietTime)).constructor(QuietTime::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("QuietTime").build()}).build();
    private static final SdkField<String> REFRESH_FREQUENCY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RefreshFrequency").getter(JourneyResponse.getter(JourneyResponse::refreshFrequency)).setter(JourneyResponse.setter(Builder::refreshFrequency)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RefreshFrequency").build()}).build();
    private static final SdkField<JourneySchedule> SCHEDULE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Schedule").getter(JourneyResponse.getter(JourneyResponse::schedule)).setter(JourneyResponse.setter(Builder::schedule)).constructor(JourneySchedule::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Schedule").build()}).build();
    private static final SdkField<String> START_ACTIVITY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("StartActivity").getter(JourneyResponse.getter(JourneyResponse::startActivity)).setter(JourneyResponse.setter(Builder::startActivity)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StartActivity").build()}).build();
    private static final SdkField<StartCondition> START_CONDITION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("StartCondition").getter(JourneyResponse.getter(JourneyResponse::startCondition)).setter(JourneyResponse.setter(Builder::startCondition)).constructor(StartCondition::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StartCondition").build()}).build();
    private static final SdkField<String> STATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("State").getter(JourneyResponse.getter(JourneyResponse::stateAsString)).setter(JourneyResponse.setter(Builder::state)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("State").build()}).build();
    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("tags").getter(JourneyResponse.getter(JourneyResponse::tags)).setter(JourneyResponse.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<Boolean> WAIT_FOR_QUIET_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("WaitForQuietTime").getter(JourneyResponse.getter(JourneyResponse::waitForQuietTime)).setter(JourneyResponse.setter(Builder::waitForQuietTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WaitForQuietTime").build()}).build();
    private static final SdkField<Boolean> REFRESH_ON_SEGMENT_UPDATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("RefreshOnSegmentUpdate").getter(JourneyResponse.getter(JourneyResponse::refreshOnSegmentUpdate)).setter(JourneyResponse.setter(Builder::refreshOnSegmentUpdate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RefreshOnSegmentUpdate").build()}).build();
    private static final SdkField<JourneyChannelSettings> JOURNEY_CHANNEL_SETTINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("JourneyChannelSettings").getter(JourneyResponse.getter(JourneyResponse::journeyChannelSettings)).setter(JourneyResponse.setter(Builder::journeyChannelSettings)).constructor(JourneyChannelSettings::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("JourneyChannelSettings").build()}).build();
    private static final SdkField<Boolean> SENDING_SCHEDULE_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("SendingSchedule").getter(JourneyResponse.getter(JourneyResponse::sendingSchedule)).setter(JourneyResponse.setter(Builder::sendingSchedule)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SendingSchedule").build()}).build();
    private static final SdkField<OpenHours> OPEN_HOURS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("OpenHours").getter(JourneyResponse.getter(JourneyResponse::openHours)).setter(JourneyResponse.setter(Builder::openHours)).constructor(OpenHours::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OpenHours").build()}).build();
    private static final SdkField<ClosedDays> CLOSED_DAYS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ClosedDays").getter(JourneyResponse.getter(JourneyResponse::closedDays)).setter(JourneyResponse.setter(Builder::closedDays)).constructor(ClosedDays::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClosedDays").build()}).build();
    private static final SdkField<List<String>> TIMEZONE_ESTIMATION_METHODS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("TimezoneEstimationMethods").getter(JourneyResponse.getter(JourneyResponse::timezoneEstimationMethodsAsStrings)).setter(JourneyResponse.setter(Builder::timezoneEstimationMethodsWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TimezoneEstimationMethods").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACTIVITIES_FIELD, APPLICATION_ID_FIELD, CREATION_DATE_FIELD, ID_FIELD, LAST_MODIFIED_DATE_FIELD, LIMITS_FIELD, LOCAL_TIME_FIELD, NAME_FIELD, QUIET_TIME_FIELD, REFRESH_FREQUENCY_FIELD, SCHEDULE_FIELD, START_ACTIVITY_FIELD, START_CONDITION_FIELD, STATE_FIELD, TAGS_FIELD, WAIT_FOR_QUIET_TIME_FIELD, REFRESH_ON_SEGMENT_UPDATE_FIELD, JOURNEY_CHANNEL_SETTINGS_FIELD, SENDING_SCHEDULE_FIELD, OPEN_HOURS_FIELD, CLOSED_DAYS_FIELD, TIMEZONE_ESTIMATION_METHODS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = JourneyResponse.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final Map<String, Activity> activities;
    private final String applicationId;
    private final String creationDate;
    private final String id;
    private final String lastModifiedDate;
    private final JourneyLimits limits;
    private final Boolean localTime;
    private final String name;
    private final QuietTime quietTime;
    private final String refreshFrequency;
    private final JourneySchedule schedule;
    private final String startActivity;
    private final StartCondition startCondition;
    private final String state;
    private final Map<String, String> tags;
    private final Boolean waitForQuietTime;
    private final Boolean refreshOnSegmentUpdate;
    private final JourneyChannelSettings journeyChannelSettings;
    private final Boolean sendingSchedule;
    private final OpenHours openHours;
    private final ClosedDays closedDays;
    private final List<String> timezoneEstimationMethods;

    private JourneyResponse(BuilderImpl builder) {
        this.activities = builder.activities;
        this.applicationId = builder.applicationId;
        this.creationDate = builder.creationDate;
        this.id = builder.id;
        this.lastModifiedDate = builder.lastModifiedDate;
        this.limits = builder.limits;
        this.localTime = builder.localTime;
        this.name = builder.name;
        this.quietTime = builder.quietTime;
        this.refreshFrequency = builder.refreshFrequency;
        this.schedule = builder.schedule;
        this.startActivity = builder.startActivity;
        this.startCondition = builder.startCondition;
        this.state = builder.state;
        this.tags = builder.tags;
        this.waitForQuietTime = builder.waitForQuietTime;
        this.refreshOnSegmentUpdate = builder.refreshOnSegmentUpdate;
        this.journeyChannelSettings = builder.journeyChannelSettings;
        this.sendingSchedule = builder.sendingSchedule;
        this.openHours = builder.openHours;
        this.closedDays = builder.closedDays;
        this.timezoneEstimationMethods = builder.timezoneEstimationMethods;
    }

    public final boolean hasActivities() {
        return this.activities != null && !(this.activities instanceof SdkAutoConstructMap);
    }

    public final Map<String, Activity> activities() {
        return this.activities;
    }

    public final String applicationId() {
        return this.applicationId;
    }

    public final String creationDate() {
        return this.creationDate;
    }

    public final String id() {
        return this.id;
    }

    public final String lastModifiedDate() {
        return this.lastModifiedDate;
    }

    public final JourneyLimits limits() {
        return this.limits;
    }

    public final Boolean localTime() {
        return this.localTime;
    }

    public final String name() {
        return this.name;
    }

    public final QuietTime quietTime() {
        return this.quietTime;
    }

    public final String refreshFrequency() {
        return this.refreshFrequency;
    }

    public final JourneySchedule schedule() {
        return this.schedule;
    }

    public final String startActivity() {
        return this.startActivity;
    }

    public final StartCondition startCondition() {
        return this.startCondition;
    }

    public final State state() {
        return State.fromValue(this.state);
    }

    public final String stateAsString() {
        return this.state;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> tags() {
        return this.tags;
    }

    public final Boolean waitForQuietTime() {
        return this.waitForQuietTime;
    }

    public final Boolean refreshOnSegmentUpdate() {
        return this.refreshOnSegmentUpdate;
    }

    public final JourneyChannelSettings journeyChannelSettings() {
        return this.journeyChannelSettings;
    }

    public final Boolean sendingSchedule() {
        return this.sendingSchedule;
    }

    public final OpenHours openHours() {
        return this.openHours;
    }

    public final ClosedDays closedDays() {
        return this.closedDays;
    }

    public final List<__TimezoneEstimationMethodsElement> timezoneEstimationMethods() {
        return ListOf__TimezoneEstimationMethodsElementCopier.copyStringToEnum(this.timezoneEstimationMethods);
    }

    public final boolean hasTimezoneEstimationMethods() {
        return this.timezoneEstimationMethods != null && !(this.timezoneEstimationMethods instanceof SdkAutoConstructList);
    }

    public final List<String> timezoneEstimationMethodsAsStrings() {
        return this.timezoneEstimationMethods;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasActivities() ? this.activities() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.applicationId());
        hashCode = 31 * hashCode + Objects.hashCode(this.creationDate());
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastModifiedDate());
        hashCode = 31 * hashCode + Objects.hashCode(this.limits());
        hashCode = 31 * hashCode + Objects.hashCode(this.localTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.quietTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.refreshFrequency());
        hashCode = 31 * hashCode + Objects.hashCode(this.schedule());
        hashCode = 31 * hashCode + Objects.hashCode(this.startActivity());
        hashCode = 31 * hashCode + Objects.hashCode(this.startCondition());
        hashCode = 31 * hashCode + Objects.hashCode(this.stateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.waitForQuietTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.refreshOnSegmentUpdate());
        hashCode = 31 * hashCode + Objects.hashCode(this.journeyChannelSettings());
        hashCode = 31 * hashCode + Objects.hashCode(this.sendingSchedule());
        hashCode = 31 * hashCode + Objects.hashCode(this.openHours());
        hashCode = 31 * hashCode + Objects.hashCode(this.closedDays());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTimezoneEstimationMethods() ? this.timezoneEstimationMethodsAsStrings() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof JourneyResponse)) {
            return false;
        }
        JourneyResponse other = (JourneyResponse)obj;
        return this.hasActivities() == other.hasActivities() && Objects.equals(this.activities(), other.activities()) && Objects.equals(this.applicationId(), other.applicationId()) && Objects.equals(this.creationDate(), other.creationDate()) && Objects.equals(this.id(), other.id()) && Objects.equals(this.lastModifiedDate(), other.lastModifiedDate()) && Objects.equals(this.limits(), other.limits()) && Objects.equals(this.localTime(), other.localTime()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.quietTime(), other.quietTime()) && Objects.equals(this.refreshFrequency(), other.refreshFrequency()) && Objects.equals(this.schedule(), other.schedule()) && Objects.equals(this.startActivity(), other.startActivity()) && Objects.equals(this.startCondition(), other.startCondition()) && Objects.equals(this.stateAsString(), other.stateAsString()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags()) && Objects.equals(this.waitForQuietTime(), other.waitForQuietTime()) && Objects.equals(this.refreshOnSegmentUpdate(), other.refreshOnSegmentUpdate()) && Objects.equals(this.journeyChannelSettings(), other.journeyChannelSettings()) && Objects.equals(this.sendingSchedule(), other.sendingSchedule()) && Objects.equals(this.openHours(), other.openHours()) && Objects.equals(this.closedDays(), other.closedDays()) && this.hasTimezoneEstimationMethods() == other.hasTimezoneEstimationMethods() && Objects.equals(this.timezoneEstimationMethodsAsStrings(), other.timezoneEstimationMethodsAsStrings());
    }

    public final String toString() {
        return ToString.builder((String)"JourneyResponse").add("Activities", this.hasActivities() ? this.activities() : null).add("ApplicationId", (Object)this.applicationId()).add("CreationDate", (Object)this.creationDate()).add("Id", (Object)this.id()).add("LastModifiedDate", (Object)this.lastModifiedDate()).add("Limits", (Object)this.limits()).add("LocalTime", (Object)this.localTime()).add("Name", (Object)this.name()).add("QuietTime", (Object)this.quietTime()).add("RefreshFrequency", (Object)this.refreshFrequency()).add("Schedule", (Object)this.schedule()).add("StartActivity", (Object)this.startActivity()).add("StartCondition", (Object)this.startCondition()).add("State", (Object)this.stateAsString()).add("Tags", this.hasTags() ? this.tags() : null).add("WaitForQuietTime", (Object)this.waitForQuietTime()).add("RefreshOnSegmentUpdate", (Object)this.refreshOnSegmentUpdate()).add("JourneyChannelSettings", (Object)this.journeyChannelSettings()).add("SendingSchedule", (Object)this.sendingSchedule()).add("OpenHours", (Object)this.openHours()).add("ClosedDays", (Object)this.closedDays()).add("TimezoneEstimationMethods", this.hasTimezoneEstimationMethods() ? this.timezoneEstimationMethodsAsStrings() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Activities": {
                return Optional.ofNullable(clazz.cast(this.activities()));
            }
            case "ApplicationId": {
                return Optional.ofNullable(clazz.cast(this.applicationId()));
            }
            case "CreationDate": {
                return Optional.ofNullable(clazz.cast(this.creationDate()));
            }
            case "Id": {
                return Optional.ofNullable(clazz.cast(this.id()));
            }
            case "LastModifiedDate": {
                return Optional.ofNullable(clazz.cast(this.lastModifiedDate()));
            }
            case "Limits": {
                return Optional.ofNullable(clazz.cast(this.limits()));
            }
            case "LocalTime": {
                return Optional.ofNullable(clazz.cast(this.localTime()));
            }
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "QuietTime": {
                return Optional.ofNullable(clazz.cast(this.quietTime()));
            }
            case "RefreshFrequency": {
                return Optional.ofNullable(clazz.cast(this.refreshFrequency()));
            }
            case "Schedule": {
                return Optional.ofNullable(clazz.cast(this.schedule()));
            }
            case "StartActivity": {
                return Optional.ofNullable(clazz.cast(this.startActivity()));
            }
            case "StartCondition": {
                return Optional.ofNullable(clazz.cast(this.startCondition()));
            }
            case "State": {
                return Optional.ofNullable(clazz.cast(this.stateAsString()));
            }
            case "tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
            case "WaitForQuietTime": {
                return Optional.ofNullable(clazz.cast(this.waitForQuietTime()));
            }
            case "RefreshOnSegmentUpdate": {
                return Optional.ofNullable(clazz.cast(this.refreshOnSegmentUpdate()));
            }
            case "JourneyChannelSettings": {
                return Optional.ofNullable(clazz.cast(this.journeyChannelSettings()));
            }
            case "SendingSchedule": {
                return Optional.ofNullable(clazz.cast(this.sendingSchedule()));
            }
            case "OpenHours": {
                return Optional.ofNullable(clazz.cast(this.openHours()));
            }
            case "ClosedDays": {
                return Optional.ofNullable(clazz.cast(this.closedDays()));
            }
            case "TimezoneEstimationMethods": {
                return Optional.ofNullable(clazz.cast(this.timezoneEstimationMethodsAsStrings()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Activities", ACTIVITIES_FIELD);
        map.put("ApplicationId", APPLICATION_ID_FIELD);
        map.put("CreationDate", CREATION_DATE_FIELD);
        map.put("Id", ID_FIELD);
        map.put("LastModifiedDate", LAST_MODIFIED_DATE_FIELD);
        map.put("Limits", LIMITS_FIELD);
        map.put("LocalTime", LOCAL_TIME_FIELD);
        map.put("Name", NAME_FIELD);
        map.put("QuietTime", QUIET_TIME_FIELD);
        map.put("RefreshFrequency", REFRESH_FREQUENCY_FIELD);
        map.put("Schedule", SCHEDULE_FIELD);
        map.put("StartActivity", START_ACTIVITY_FIELD);
        map.put("StartCondition", START_CONDITION_FIELD);
        map.put("State", STATE_FIELD);
        map.put("tags", TAGS_FIELD);
        map.put("WaitForQuietTime", WAIT_FOR_QUIET_TIME_FIELD);
        map.put("RefreshOnSegmentUpdate", REFRESH_ON_SEGMENT_UPDATE_FIELD);
        map.put("JourneyChannelSettings", JOURNEY_CHANNEL_SETTINGS_FIELD);
        map.put("SendingSchedule", SENDING_SCHEDULE_FIELD);
        map.put("OpenHours", OPEN_HOURS_FIELD);
        map.put("ClosedDays", CLOSED_DAYS_FIELD);
        map.put("TimezoneEstimationMethods", TIMEZONE_ESTIMATION_METHODS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<JourneyResponse, T> g) {
        return obj -> g.apply((JourneyResponse)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Map<String, Activity> activities = DefaultSdkAutoConstructMap.getInstance();
        private String applicationId;
        private String creationDate;
        private String id;
        private String lastModifiedDate;
        private JourneyLimits limits;
        private Boolean localTime;
        private String name;
        private QuietTime quietTime;
        private String refreshFrequency;
        private JourneySchedule schedule;
        private String startActivity;
        private StartCondition startCondition;
        private String state;
        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();
        private Boolean waitForQuietTime;
        private Boolean refreshOnSegmentUpdate;
        private JourneyChannelSettings journeyChannelSettings;
        private Boolean sendingSchedule;
        private OpenHours openHours;
        private ClosedDays closedDays;
        private List<String> timezoneEstimationMethods = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(JourneyResponse model) {
            this.activities(model.activities);
            this.applicationId(model.applicationId);
            this.creationDate(model.creationDate);
            this.id(model.id);
            this.lastModifiedDate(model.lastModifiedDate);
            this.limits(model.limits);
            this.localTime(model.localTime);
            this.name(model.name);
            this.quietTime(model.quietTime);
            this.refreshFrequency(model.refreshFrequency);
            this.schedule(model.schedule);
            this.startActivity(model.startActivity);
            this.startCondition(model.startCondition);
            this.state(model.state);
            this.tags(model.tags);
            this.waitForQuietTime(model.waitForQuietTime);
            this.refreshOnSegmentUpdate(model.refreshOnSegmentUpdate);
            this.journeyChannelSettings(model.journeyChannelSettings);
            this.sendingSchedule(model.sendingSchedule);
            this.openHours(model.openHours);
            this.closedDays(model.closedDays);
            this.timezoneEstimationMethodsWithStrings(model.timezoneEstimationMethods);
        }

        public final Map<String, Activity.Builder> getActivities() {
            Map<String, Activity.Builder> result = MapOfActivityCopier.copyToBuilder(this.activities);
            if (result instanceof SdkAutoConstructMap) {
                return null;
            }
            return result;
        }

        public final void setActivities(Map<String, Activity.BuilderImpl> activities) {
            this.activities = MapOfActivityCopier.copyFromBuilder(activities);
        }

        @Override
        public final Builder activities(Map<String, Activity> activities) {
            this.activities = MapOfActivityCopier.copy(activities);
            return this;
        }

        public final String getApplicationId() {
            return this.applicationId;
        }

        public final void setApplicationId(String applicationId) {
            this.applicationId = applicationId;
        }

        @Override
        public final Builder applicationId(String applicationId) {
            this.applicationId = applicationId;
            return this;
        }

        public final String getCreationDate() {
            return this.creationDate;
        }

        public final void setCreationDate(String creationDate) {
            this.creationDate = creationDate;
        }

        @Override
        public final Builder creationDate(String creationDate) {
            this.creationDate = creationDate;
            return this;
        }

        public final String getId() {
            return this.id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getLastModifiedDate() {
            return this.lastModifiedDate;
        }

        public final void setLastModifiedDate(String lastModifiedDate) {
            this.lastModifiedDate = lastModifiedDate;
        }

        @Override
        public final Builder lastModifiedDate(String lastModifiedDate) {
            this.lastModifiedDate = lastModifiedDate;
            return this;
        }

        public final JourneyLimits.Builder getLimits() {
            return this.limits != null ? this.limits.toBuilder() : null;
        }

        public final void setLimits(JourneyLimits.BuilderImpl limits) {
            this.limits = limits != null ? limits.build() : null;
        }

        @Override
        public final Builder limits(JourneyLimits limits) {
            this.limits = limits;
            return this;
        }

        public final Boolean getLocalTime() {
            return this.localTime;
        }

        public final void setLocalTime(Boolean localTime) {
            this.localTime = localTime;
        }

        @Override
        public final Builder localTime(Boolean localTime) {
            this.localTime = localTime;
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final QuietTime.Builder getQuietTime() {
            return this.quietTime != null ? this.quietTime.toBuilder() : null;
        }

        public final void setQuietTime(QuietTime.BuilderImpl quietTime) {
            this.quietTime = quietTime != null ? quietTime.build() : null;
        }

        @Override
        public final Builder quietTime(QuietTime quietTime) {
            this.quietTime = quietTime;
            return this;
        }

        public final String getRefreshFrequency() {
            return this.refreshFrequency;
        }

        public final void setRefreshFrequency(String refreshFrequency) {
            this.refreshFrequency = refreshFrequency;
        }

        @Override
        public final Builder refreshFrequency(String refreshFrequency) {
            this.refreshFrequency = refreshFrequency;
            return this;
        }

        public final JourneySchedule.Builder getSchedule() {
            return this.schedule != null ? this.schedule.toBuilder() : null;
        }

        public final void setSchedule(JourneySchedule.BuilderImpl schedule) {
            this.schedule = schedule != null ? schedule.build() : null;
        }

        @Override
        public final Builder schedule(JourneySchedule schedule) {
            this.schedule = schedule;
            return this;
        }

        public final String getStartActivity() {
            return this.startActivity;
        }

        public final void setStartActivity(String startActivity) {
            this.startActivity = startActivity;
        }

        @Override
        public final Builder startActivity(String startActivity) {
            this.startActivity = startActivity;
            return this;
        }

        public final StartCondition.Builder getStartCondition() {
            return this.startCondition != null ? this.startCondition.toBuilder() : null;
        }

        public final void setStartCondition(StartCondition.BuilderImpl startCondition) {
            this.startCondition = startCondition != null ? startCondition.build() : null;
        }

        @Override
        public final Builder startCondition(StartCondition startCondition) {
            this.startCondition = startCondition;
            return this;
        }

        public final String getState() {
            return this.state;
        }

        public final void setState(String state) {
            this.state = state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        public final Builder state(State state) {
            this.state(state == null ? null : state.toString());
            return this;
        }

        public final Map<String, String> getTags() {
            if (this.tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = MapOf__stringCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = MapOf__stringCopier.copy(tags);
            return this;
        }

        public final Boolean getWaitForQuietTime() {
            return this.waitForQuietTime;
        }

        public final void setWaitForQuietTime(Boolean waitForQuietTime) {
            this.waitForQuietTime = waitForQuietTime;
        }

        @Override
        public final Builder waitForQuietTime(Boolean waitForQuietTime) {
            this.waitForQuietTime = waitForQuietTime;
            return this;
        }

        public final Boolean getRefreshOnSegmentUpdate() {
            return this.refreshOnSegmentUpdate;
        }

        public final void setRefreshOnSegmentUpdate(Boolean refreshOnSegmentUpdate) {
            this.refreshOnSegmentUpdate = refreshOnSegmentUpdate;
        }

        @Override
        public final Builder refreshOnSegmentUpdate(Boolean refreshOnSegmentUpdate) {
            this.refreshOnSegmentUpdate = refreshOnSegmentUpdate;
            return this;
        }

        public final JourneyChannelSettings.Builder getJourneyChannelSettings() {
            return this.journeyChannelSettings != null ? this.journeyChannelSettings.toBuilder() : null;
        }

        public final void setJourneyChannelSettings(JourneyChannelSettings.BuilderImpl journeyChannelSettings) {
            this.journeyChannelSettings = journeyChannelSettings != null ? journeyChannelSettings.build() : null;
        }

        @Override
        public final Builder journeyChannelSettings(JourneyChannelSettings journeyChannelSettings) {
            this.journeyChannelSettings = journeyChannelSettings;
            return this;
        }

        public final Boolean getSendingSchedule() {
            return this.sendingSchedule;
        }

        public final void setSendingSchedule(Boolean sendingSchedule) {
            this.sendingSchedule = sendingSchedule;
        }

        @Override
        public final Builder sendingSchedule(Boolean sendingSchedule) {
            this.sendingSchedule = sendingSchedule;
            return this;
        }

        public final OpenHours.Builder getOpenHours() {
            return this.openHours != null ? this.openHours.toBuilder() : null;
        }

        public final void setOpenHours(OpenHours.BuilderImpl openHours) {
            this.openHours = openHours != null ? openHours.build() : null;
        }

        @Override
        public final Builder openHours(OpenHours openHours) {
            this.openHours = openHours;
            return this;
        }

        public final ClosedDays.Builder getClosedDays() {
            return this.closedDays != null ? this.closedDays.toBuilder() : null;
        }

        public final void setClosedDays(ClosedDays.BuilderImpl closedDays) {
            this.closedDays = closedDays != null ? closedDays.build() : null;
        }

        @Override
        public final Builder closedDays(ClosedDays closedDays) {
            this.closedDays = closedDays;
            return this;
        }

        public final Collection<String> getTimezoneEstimationMethods() {
            if (this.timezoneEstimationMethods instanceof SdkAutoConstructList) {
                return null;
            }
            return this.timezoneEstimationMethods;
        }

        public final void setTimezoneEstimationMethods(Collection<String> timezoneEstimationMethods) {
            this.timezoneEstimationMethods = ListOf__TimezoneEstimationMethodsElementCopier.copy(timezoneEstimationMethods);
        }

        @Override
        public final Builder timezoneEstimationMethodsWithStrings(Collection<String> timezoneEstimationMethods) {
            this.timezoneEstimationMethods = ListOf__TimezoneEstimationMethodsElementCopier.copy(timezoneEstimationMethods);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder timezoneEstimationMethodsWithStrings(String ... timezoneEstimationMethods) {
            this.timezoneEstimationMethodsWithStrings(Arrays.asList(timezoneEstimationMethods));
            return this;
        }

        @Override
        public final Builder timezoneEstimationMethods(Collection<__TimezoneEstimationMethodsElement> timezoneEstimationMethods) {
            this.timezoneEstimationMethods = ListOf__TimezoneEstimationMethodsElementCopier.copyEnumToString(timezoneEstimationMethods);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder timezoneEstimationMethods(__TimezoneEstimationMethodsElement ... timezoneEstimationMethods) {
            this.timezoneEstimationMethods(Arrays.asList(timezoneEstimationMethods));
            return this;
        }

        public JourneyResponse build() {
            return new JourneyResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, JourneyResponse> {
        public Builder activities(Map<String, Activity> var1);

        public Builder applicationId(String var1);

        public Builder creationDate(String var1);

        public Builder id(String var1);

        public Builder lastModifiedDate(String var1);

        public Builder limits(JourneyLimits var1);

        default public Builder limits(Consumer<JourneyLimits.Builder> limits) {
            return this.limits((JourneyLimits)((JourneyLimits.Builder)JourneyLimits.builder().applyMutation(limits)).build());
        }

        public Builder localTime(Boolean var1);

        public Builder name(String var1);

        public Builder quietTime(QuietTime var1);

        default public Builder quietTime(Consumer<QuietTime.Builder> quietTime) {
            return this.quietTime((QuietTime)((QuietTime.Builder)QuietTime.builder().applyMutation(quietTime)).build());
        }

        public Builder refreshFrequency(String var1);

        public Builder schedule(JourneySchedule var1);

        default public Builder schedule(Consumer<JourneySchedule.Builder> schedule) {
            return this.schedule((JourneySchedule)((JourneySchedule.Builder)JourneySchedule.builder().applyMutation(schedule)).build());
        }

        public Builder startActivity(String var1);

        public Builder startCondition(StartCondition var1);

        default public Builder startCondition(Consumer<StartCondition.Builder> startCondition) {
            return this.startCondition((StartCondition)((StartCondition.Builder)StartCondition.builder().applyMutation(startCondition)).build());
        }

        public Builder state(String var1);

        public Builder state(State var1);

        public Builder tags(Map<String, String> var1);

        public Builder waitForQuietTime(Boolean var1);

        public Builder refreshOnSegmentUpdate(Boolean var1);

        public Builder journeyChannelSettings(JourneyChannelSettings var1);

        default public Builder journeyChannelSettings(Consumer<JourneyChannelSettings.Builder> journeyChannelSettings) {
            return this.journeyChannelSettings((JourneyChannelSettings)((JourneyChannelSettings.Builder)JourneyChannelSettings.builder().applyMutation(journeyChannelSettings)).build());
        }

        public Builder sendingSchedule(Boolean var1);

        public Builder openHours(OpenHours var1);

        default public Builder openHours(Consumer<OpenHours.Builder> openHours) {
            return this.openHours((OpenHours)((OpenHours.Builder)OpenHours.builder().applyMutation(openHours)).build());
        }

        public Builder closedDays(ClosedDays var1);

        default public Builder closedDays(Consumer<ClosedDays.Builder> closedDays) {
            return this.closedDays((ClosedDays)((ClosedDays.Builder)ClosedDays.builder().applyMutation(closedDays)).build());
        }

        public Builder timezoneEstimationMethodsWithStrings(Collection<String> var1);

        public Builder timezoneEstimationMethodsWithStrings(String ... var1);

        public Builder timezoneEstimationMethods(Collection<__TimezoneEstimationMethodsElement> var1);

        public Builder timezoneEstimationMethods(__TimezoneEstimationMethodsElement ... var1);
    }
}

