/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.pinpoint.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.pinpoint.model.BaseKpiResult;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CampaignDateRangeKpiResponse
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, CampaignDateRangeKpiResponse> {
    private static final SdkField<String> APPLICATION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ApplicationId").getter(CampaignDateRangeKpiResponse.getter(CampaignDateRangeKpiResponse::applicationId)).setter(CampaignDateRangeKpiResponse.setter(Builder::applicationId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ApplicationId").build()}).build();
    private static final SdkField<String> CAMPAIGN_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CampaignId").getter(CampaignDateRangeKpiResponse.getter(CampaignDateRangeKpiResponse::campaignId)).setter(CampaignDateRangeKpiResponse.setter(Builder::campaignId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CampaignId").build()}).build();
    private static final SdkField<Instant> END_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("EndTime").getter(CampaignDateRangeKpiResponse.getter(CampaignDateRangeKpiResponse::endTime)).setter(CampaignDateRangeKpiResponse.setter(Builder::endTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndTime").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<String> KPI_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("KpiName").getter(CampaignDateRangeKpiResponse.getter(CampaignDateRangeKpiResponse::kpiName)).setter(CampaignDateRangeKpiResponse.setter(Builder::kpiName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KpiName").build()}).build();
    private static final SdkField<BaseKpiResult> KPI_RESULT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("KpiResult").getter(CampaignDateRangeKpiResponse.getter(CampaignDateRangeKpiResponse::kpiResult)).setter(CampaignDateRangeKpiResponse.setter(Builder::kpiResult)).constructor(BaseKpiResult::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KpiResult").build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(CampaignDateRangeKpiResponse.getter(CampaignDateRangeKpiResponse::nextToken)).setter(CampaignDateRangeKpiResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final SdkField<Instant> START_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("StartTime").getter(CampaignDateRangeKpiResponse.getter(CampaignDateRangeKpiResponse::startTime)).setter(CampaignDateRangeKpiResponse.setter(Builder::startTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StartTime").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APPLICATION_ID_FIELD, CAMPAIGN_ID_FIELD, END_TIME_FIELD, KPI_NAME_FIELD, KPI_RESULT_FIELD, NEXT_TOKEN_FIELD, START_TIME_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CampaignDateRangeKpiResponse.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String applicationId;
    private final String campaignId;
    private final Instant endTime;
    private final String kpiName;
    private final BaseKpiResult kpiResult;
    private final String nextToken;
    private final Instant startTime;

    private CampaignDateRangeKpiResponse(BuilderImpl builder) {
        this.applicationId = builder.applicationId;
        this.campaignId = builder.campaignId;
        this.endTime = builder.endTime;
        this.kpiName = builder.kpiName;
        this.kpiResult = builder.kpiResult;
        this.nextToken = builder.nextToken;
        this.startTime = builder.startTime;
    }

    public final String applicationId() {
        return this.applicationId;
    }

    public final String campaignId() {
        return this.campaignId;
    }

    public final Instant endTime() {
        return this.endTime;
    }

    public final String kpiName() {
        return this.kpiName;
    }

    public final BaseKpiResult kpiResult() {
        return this.kpiResult;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final Instant startTime() {
        return this.startTime;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.applicationId());
        hashCode = 31 * hashCode + Objects.hashCode(this.campaignId());
        hashCode = 31 * hashCode + Objects.hashCode(this.endTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.kpiName());
        hashCode = 31 * hashCode + Objects.hashCode(this.kpiResult());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.startTime());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CampaignDateRangeKpiResponse)) {
            return false;
        }
        CampaignDateRangeKpiResponse other = (CampaignDateRangeKpiResponse)obj;
        return Objects.equals(this.applicationId(), other.applicationId()) && Objects.equals(this.campaignId(), other.campaignId()) && Objects.equals(this.endTime(), other.endTime()) && Objects.equals(this.kpiName(), other.kpiName()) && Objects.equals(this.kpiResult(), other.kpiResult()) && Objects.equals(this.nextToken(), other.nextToken()) && Objects.equals(this.startTime(), other.startTime());
    }

    public final String toString() {
        return ToString.builder((String)"CampaignDateRangeKpiResponse").add("ApplicationId", (Object)this.applicationId()).add("CampaignId", (Object)this.campaignId()).add("EndTime", (Object)this.endTime()).add("KpiName", (Object)this.kpiName()).add("KpiResult", (Object)this.kpiResult()).add("NextToken", (Object)this.nextToken()).add("StartTime", (Object)this.startTime()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ApplicationId": {
                return Optional.ofNullable(clazz.cast(this.applicationId()));
            }
            case "CampaignId": {
                return Optional.ofNullable(clazz.cast(this.campaignId()));
            }
            case "EndTime": {
                return Optional.ofNullable(clazz.cast(this.endTime()));
            }
            case "KpiName": {
                return Optional.ofNullable(clazz.cast(this.kpiName()));
            }
            case "KpiResult": {
                return Optional.ofNullable(clazz.cast(this.kpiResult()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "StartTime": {
                return Optional.ofNullable(clazz.cast(this.startTime()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("ApplicationId", APPLICATION_ID_FIELD);
        map.put("CampaignId", CAMPAIGN_ID_FIELD);
        map.put("EndTime", END_TIME_FIELD);
        map.put("KpiName", KPI_NAME_FIELD);
        map.put("KpiResult", KPI_RESULT_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        map.put("StartTime", START_TIME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CampaignDateRangeKpiResponse, T> g) {
        return obj -> g.apply((CampaignDateRangeKpiResponse)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String applicationId;
        private String campaignId;
        private Instant endTime;
        private String kpiName;
        private BaseKpiResult kpiResult;
        private String nextToken;
        private Instant startTime;

        private BuilderImpl() {
        }

        private BuilderImpl(CampaignDateRangeKpiResponse model) {
            this.applicationId(model.applicationId);
            this.campaignId(model.campaignId);
            this.endTime(model.endTime);
            this.kpiName(model.kpiName);
            this.kpiResult(model.kpiResult);
            this.nextToken(model.nextToken);
            this.startTime(model.startTime);
        }

        public final String getApplicationId() {
            return this.applicationId;
        }

        public final void setApplicationId(String applicationId) {
            this.applicationId = applicationId;
        }

        @Override
        public final Builder applicationId(String applicationId) {
            this.applicationId = applicationId;
            return this;
        }

        public final String getCampaignId() {
            return this.campaignId;
        }

        public final void setCampaignId(String campaignId) {
            this.campaignId = campaignId;
        }

        @Override
        public final Builder campaignId(String campaignId) {
            this.campaignId = campaignId;
            return this;
        }

        public final Instant getEndTime() {
            return this.endTime;
        }

        public final void setEndTime(Instant endTime) {
            this.endTime = endTime;
        }

        @Override
        public final Builder endTime(Instant endTime) {
            this.endTime = endTime;
            return this;
        }

        public final String getKpiName() {
            return this.kpiName;
        }

        public final void setKpiName(String kpiName) {
            this.kpiName = kpiName;
        }

        @Override
        public final Builder kpiName(String kpiName) {
            this.kpiName = kpiName;
            return this;
        }

        public final BaseKpiResult.Builder getKpiResult() {
            return this.kpiResult != null ? this.kpiResult.toBuilder() : null;
        }

        public final void setKpiResult(BaseKpiResult.BuilderImpl kpiResult) {
            this.kpiResult = kpiResult != null ? kpiResult.build() : null;
        }

        @Override
        public final Builder kpiResult(BaseKpiResult kpiResult) {
            this.kpiResult = kpiResult;
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final Instant getStartTime() {
            return this.startTime;
        }

        public final void setStartTime(Instant startTime) {
            this.startTime = startTime;
        }

        @Override
        public final Builder startTime(Instant startTime) {
            this.startTime = startTime;
            return this;
        }

        public CampaignDateRangeKpiResponse build() {
            return new CampaignDateRangeKpiResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, CampaignDateRangeKpiResponse> {
        public Builder applicationId(String var1);

        public Builder campaignId(String var1);

        public Builder endTime(Instant var1);

        public Builder kpiName(String var1);

        public Builder kpiResult(BaseKpiResult var1);

        default public Builder kpiResult(Consumer<BaseKpiResult.Builder> kpiResult) {
            return this.kpiResult((BaseKpiResult)((BaseKpiResult.Builder)BaseKpiResult.builder().applyMutation(kpiResult)).build());
        }

        public Builder nextToken(String var1);

        public Builder startTime(Instant var1);
    }
}

