/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.pinpoint.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.pinpoint.model.InAppMessageContent;
import software.amazon.awssdk.services.pinpoint.model.Layout;
import software.amazon.awssdk.services.pinpoint.model.ListOfInAppMessageContentCopier;
import software.amazon.awssdk.services.pinpoint.model.MapOf__stringCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class InAppMessage
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, InAppMessage> {
    private static final SdkField<List<InAppMessageContent>> CONTENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Content").getter(InAppMessage.getter(InAppMessage::content)).setter(InAppMessage.setter(Builder::content)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Content").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(InAppMessageContent::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Map<String, String>> CUSTOM_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("CustomConfig").getter(InAppMessage.getter(InAppMessage::customConfig)).setter(InAppMessage.setter(Builder::customConfig)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CustomConfig").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<String> LAYOUT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Layout").getter(InAppMessage.getter(InAppMessage::layoutAsString)).setter(InAppMessage.setter(Builder::layout)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Layout").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONTENT_FIELD, CUSTOM_CONFIG_FIELD, LAYOUT_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = InAppMessage.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final List<InAppMessageContent> content;
    private final Map<String, String> customConfig;
    private final String layout;

    private InAppMessage(BuilderImpl builder) {
        this.content = builder.content;
        this.customConfig = builder.customConfig;
        this.layout = builder.layout;
    }

    public final boolean hasContent() {
        return this.content != null && !(this.content instanceof SdkAutoConstructList);
    }

    public final List<InAppMessageContent> content() {
        return this.content;
    }

    public final boolean hasCustomConfig() {
        return this.customConfig != null && !(this.customConfig instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> customConfig() {
        return this.customConfig;
    }

    public final Layout layout() {
        return Layout.fromValue(this.layout);
    }

    public final String layoutAsString() {
        return this.layout;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasContent() ? this.content() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasCustomConfig() ? this.customConfig() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.layoutAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InAppMessage)) {
            return false;
        }
        InAppMessage other = (InAppMessage)obj;
        return this.hasContent() == other.hasContent() && Objects.equals(this.content(), other.content()) && this.hasCustomConfig() == other.hasCustomConfig() && Objects.equals(this.customConfig(), other.customConfig()) && Objects.equals(this.layoutAsString(), other.layoutAsString());
    }

    public final String toString() {
        return ToString.builder((String)"InAppMessage").add("Content", this.hasContent() ? this.content() : null).add("CustomConfig", this.hasCustomConfig() ? this.customConfig() : null).add("Layout", (Object)this.layoutAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Content": {
                return Optional.ofNullable(clazz.cast(this.content()));
            }
            case "CustomConfig": {
                return Optional.ofNullable(clazz.cast(this.customConfig()));
            }
            case "Layout": {
                return Optional.ofNullable(clazz.cast(this.layoutAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Content", CONTENT_FIELD);
        map.put("CustomConfig", CUSTOM_CONFIG_FIELD);
        map.put("Layout", LAYOUT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<InAppMessage, T> g) {
        return obj -> g.apply((InAppMessage)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<InAppMessageContent> content = DefaultSdkAutoConstructList.getInstance();
        private Map<String, String> customConfig = DefaultSdkAutoConstructMap.getInstance();
        private String layout;

        private BuilderImpl() {
        }

        private BuilderImpl(InAppMessage model) {
            this.content(model.content);
            this.customConfig(model.customConfig);
            this.layout(model.layout);
        }

        public final List<InAppMessageContent.Builder> getContent() {
            List<InAppMessageContent.Builder> result = ListOfInAppMessageContentCopier.copyToBuilder(this.content);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setContent(Collection<InAppMessageContent.BuilderImpl> content) {
            this.content = ListOfInAppMessageContentCopier.copyFromBuilder(content);
        }

        @Override
        public final Builder content(Collection<InAppMessageContent> content) {
            this.content = ListOfInAppMessageContentCopier.copy(content);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder content(InAppMessageContent ... content) {
            this.content(Arrays.asList(content));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder content(Consumer<InAppMessageContent.Builder> ... content) {
            this.content(Stream.of(content).map(c -> (InAppMessageContent)((InAppMessageContent.Builder)InAppMessageContent.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final Map<String, String> getCustomConfig() {
            if (this.customConfig instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.customConfig;
        }

        public final void setCustomConfig(Map<String, String> customConfig) {
            this.customConfig = MapOf__stringCopier.copy(customConfig);
        }

        @Override
        public final Builder customConfig(Map<String, String> customConfig) {
            this.customConfig = MapOf__stringCopier.copy(customConfig);
            return this;
        }

        public final String getLayout() {
            return this.layout;
        }

        public final void setLayout(String layout) {
            this.layout = layout;
        }

        @Override
        public final Builder layout(String layout) {
            this.layout = layout;
            return this;
        }

        @Override
        public final Builder layout(Layout layout) {
            this.layout(layout == null ? null : layout.toString());
            return this;
        }

        public InAppMessage build() {
            return new InAppMessage(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, InAppMessage> {
        public Builder content(Collection<InAppMessageContent> var1);

        public Builder content(InAppMessageContent ... var1);

        public Builder content(Consumer<InAppMessageContent.Builder> ... var1);

        public Builder customConfig(Map<String, String> var1);

        public Builder layout(String var1);

        public Builder layout(Layout var1);
    }
}

