/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.pinpoint.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.pinpoint.model.ItemResponse;
import software.amazon.awssdk.services.pinpoint.model.MapOfItemResponseCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class EventsResponse
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, EventsResponse> {
    private static final SdkField<Map<String, ItemResponse>> RESULTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("Results").getter(EventsResponse.getter(EventsResponse::results)).setter(EventsResponse.setter(Builder::results)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Results").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ItemResponse::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RESULTS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = EventsResponse.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final Map<String, ItemResponse> results;

    private EventsResponse(BuilderImpl builder) {
        this.results = builder.results;
    }

    public final boolean hasResults() {
        return this.results != null && !(this.results instanceof SdkAutoConstructMap);
    }

    public final Map<String, ItemResponse> results() {
        return this.results;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasResults() ? this.results() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EventsResponse)) {
            return false;
        }
        EventsResponse other = (EventsResponse)obj;
        return this.hasResults() == other.hasResults() && Objects.equals(this.results(), other.results());
    }

    public final String toString() {
        return ToString.builder((String)"EventsResponse").add("Results", this.hasResults() ? this.results() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Results": {
                return Optional.ofNullable(clazz.cast(this.results()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<Map<String, ItemResponse>>> map = new HashMap<String, SdkField<Map<String, ItemResponse>>>();
        map.put("Results", RESULTS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<EventsResponse, T> g) {
        return obj -> g.apply((EventsResponse)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Map<String, ItemResponse> results = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(EventsResponse model) {
            this.results(model.results);
        }

        public final Map<String, ItemResponse.Builder> getResults() {
            Map<String, ItemResponse.Builder> result = MapOfItemResponseCopier.copyToBuilder(this.results);
            if (result instanceof SdkAutoConstructMap) {
                return null;
            }
            return result;
        }

        public final void setResults(Map<String, ItemResponse.BuilderImpl> results) {
            this.results = MapOfItemResponseCopier.copyFromBuilder(results);
        }

        @Override
        public final Builder results(Map<String, ItemResponse> results) {
            this.results = MapOfItemResponseCopier.copy(results);
            return this;
        }

        public EventsResponse build() {
            return new EventsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, EventsResponse> {
        public Builder results(Map<String, ItemResponse> var1);
    }
}

