/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.pinpoint.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.pinpoint.model.Alignment;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class InAppMessageHeaderConfig
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, InAppMessageHeaderConfig> {
    private static final SdkField<String> ALIGNMENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Alignment").getter(InAppMessageHeaderConfig.getter(InAppMessageHeaderConfig::alignmentAsString)).setter(InAppMessageHeaderConfig.setter(Builder::alignment)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Alignment").build()}).build();
    private static final SdkField<String> HEADER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Header").getter(InAppMessageHeaderConfig.getter(InAppMessageHeaderConfig::header)).setter(InAppMessageHeaderConfig.setter(Builder::header)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Header").build()}).build();
    private static final SdkField<String> TEXT_COLOR_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TextColor").getter(InAppMessageHeaderConfig.getter(InAppMessageHeaderConfig::textColor)).setter(InAppMessageHeaderConfig.setter(Builder::textColor)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TextColor").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ALIGNMENT_FIELD, HEADER_FIELD, TEXT_COLOR_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = InAppMessageHeaderConfig.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String alignment;
    private final String header;
    private final String textColor;

    private InAppMessageHeaderConfig(BuilderImpl builder) {
        this.alignment = builder.alignment;
        this.header = builder.header;
        this.textColor = builder.textColor;
    }

    public final Alignment alignment() {
        return Alignment.fromValue(this.alignment);
    }

    public final String alignmentAsString() {
        return this.alignment;
    }

    public final String header() {
        return this.header;
    }

    public final String textColor() {
        return this.textColor;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.alignmentAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.header());
        hashCode = 31 * hashCode + Objects.hashCode(this.textColor());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InAppMessageHeaderConfig)) {
            return false;
        }
        InAppMessageHeaderConfig other = (InAppMessageHeaderConfig)obj;
        return Objects.equals(this.alignmentAsString(), other.alignmentAsString()) && Objects.equals(this.header(), other.header()) && Objects.equals(this.textColor(), other.textColor());
    }

    public final String toString() {
        return ToString.builder((String)"InAppMessageHeaderConfig").add("Alignment", (Object)this.alignmentAsString()).add("Header", (Object)this.header()).add("TextColor", (Object)this.textColor()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Alignment": {
                return Optional.ofNullable(clazz.cast(this.alignmentAsString()));
            }
            case "Header": {
                return Optional.ofNullable(clazz.cast(this.header()));
            }
            case "TextColor": {
                return Optional.ofNullable(clazz.cast(this.textColor()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("Alignment", ALIGNMENT_FIELD);
        map.put("Header", HEADER_FIELD);
        map.put("TextColor", TEXT_COLOR_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<InAppMessageHeaderConfig, T> g) {
        return obj -> g.apply((InAppMessageHeaderConfig)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String alignment;
        private String header;
        private String textColor;

        private BuilderImpl() {
        }

        private BuilderImpl(InAppMessageHeaderConfig model) {
            this.alignment(model.alignment);
            this.header(model.header);
            this.textColor(model.textColor);
        }

        public final String getAlignment() {
            return this.alignment;
        }

        public final void setAlignment(String alignment) {
            this.alignment = alignment;
        }

        @Override
        public final Builder alignment(String alignment) {
            this.alignment = alignment;
            return this;
        }

        @Override
        public final Builder alignment(Alignment alignment) {
            this.alignment(alignment == null ? null : alignment.toString());
            return this;
        }

        public final String getHeader() {
            return this.header;
        }

        public final void setHeader(String header) {
            this.header = header;
        }

        @Override
        public final Builder header(String header) {
            this.header = header;
            return this;
        }

        public final String getTextColor() {
            return this.textColor;
        }

        public final void setTextColor(String textColor) {
            this.textColor = textColor;
        }

        @Override
        public final Builder textColor(String textColor) {
            this.textColor = textColor;
            return this;
        }

        public InAppMessageHeaderConfig build() {
            return new InAppMessageHeaderConfig(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, InAppMessageHeaderConfig> {
        public Builder alignment(String var1);

        public Builder alignment(Alignment var1);

        public Builder header(String var1);

        public Builder textColor(String var1);
    }
}

