/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.pinpoint.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.services.pinpoint.model.ChannelType;
import software.amazon.awssdk.services.pinpoint.model.MapOfListOf__stringCopier;
import software.amazon.awssdk.services.pinpoint.model.MapOf__stringCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AddressConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AddressConfiguration> {
    private static final SdkField<String> BODY_OVERRIDE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(AddressConfiguration.getter(AddressConfiguration::bodyOverride)).setter(AddressConfiguration.setter(Builder::bodyOverride)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BodyOverride").build()}).build();
    private static final SdkField<String> CHANNEL_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(AddressConfiguration.getter(AddressConfiguration::channelTypeAsString)).setter(AddressConfiguration.setter(Builder::channelType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ChannelType").build()}).build();
    private static final SdkField<Map<String, String>> CONTEXT_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).getter(AddressConfiguration.getter(AddressConfiguration::context)).setter(AddressConfiguration.setter(Builder::context)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Context").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<String> RAW_CONTENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(AddressConfiguration.getter(AddressConfiguration::rawContent)).setter(AddressConfiguration.setter(Builder::rawContent)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RawContent").build()}).build();
    private static final SdkField<Map<String, List<String>>> SUBSTITUTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).getter(AddressConfiguration.getter(AddressConfiguration::substitutions)).setter(AddressConfiguration.setter(Builder::substitutions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Substitutions").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.LIST).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build()).build()}).build();
    private static final SdkField<String> TITLE_OVERRIDE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(AddressConfiguration.getter(AddressConfiguration::titleOverride)).setter(AddressConfiguration.setter(Builder::titleOverride)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TitleOverride").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BODY_OVERRIDE_FIELD, CHANNEL_TYPE_FIELD, CONTEXT_FIELD, RAW_CONTENT_FIELD, SUBSTITUTIONS_FIELD, TITLE_OVERRIDE_FIELD));
    private static final long serialVersionUID = 1L;
    private final String bodyOverride;
    private final String channelType;
    private final Map<String, String> context;
    private final String rawContent;
    private final Map<String, List<String>> substitutions;
    private final String titleOverride;

    private AddressConfiguration(BuilderImpl builder) {
        this.bodyOverride = builder.bodyOverride;
        this.channelType = builder.channelType;
        this.context = builder.context;
        this.rawContent = builder.rawContent;
        this.substitutions = builder.substitutions;
        this.titleOverride = builder.titleOverride;
    }

    public String bodyOverride() {
        return this.bodyOverride;
    }

    public ChannelType channelType() {
        return ChannelType.fromValue(this.channelType);
    }

    public String channelTypeAsString() {
        return this.channelType;
    }

    public Map<String, String> context() {
        return this.context;
    }

    public String rawContent() {
        return this.rawContent;
    }

    public Map<String, List<String>> substitutions() {
        return this.substitutions;
    }

    public String titleOverride() {
        return this.titleOverride;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.bodyOverride());
        hashCode = 31 * hashCode + Objects.hashCode(this.channelTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.context());
        hashCode = 31 * hashCode + Objects.hashCode(this.rawContent());
        hashCode = 31 * hashCode + Objects.hashCode(this.substitutions());
        hashCode = 31 * hashCode + Objects.hashCode(this.titleOverride());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AddressConfiguration)) {
            return false;
        }
        AddressConfiguration other = (AddressConfiguration)obj;
        return Objects.equals(this.bodyOverride(), other.bodyOverride()) && Objects.equals(this.channelTypeAsString(), other.channelTypeAsString()) && Objects.equals(this.context(), other.context()) && Objects.equals(this.rawContent(), other.rawContent()) && Objects.equals(this.substitutions(), other.substitutions()) && Objects.equals(this.titleOverride(), other.titleOverride());
    }

    public String toString() {
        return ToString.builder((String)"AddressConfiguration").add("BodyOverride", (Object)this.bodyOverride()).add("ChannelType", (Object)this.channelTypeAsString()).add("Context", this.context()).add("RawContent", (Object)this.rawContent()).add("Substitutions", this.substitutions()).add("TitleOverride", (Object)this.titleOverride()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "BodyOverride": {
                return Optional.ofNullable(clazz.cast(this.bodyOverride()));
            }
            case "ChannelType": {
                return Optional.ofNullable(clazz.cast(this.channelTypeAsString()));
            }
            case "Context": {
                return Optional.ofNullable(clazz.cast(this.context()));
            }
            case "RawContent": {
                return Optional.ofNullable(clazz.cast(this.rawContent()));
            }
            case "Substitutions": {
                return Optional.ofNullable(clazz.cast(this.substitutions()));
            }
            case "TitleOverride": {
                return Optional.ofNullable(clazz.cast(this.titleOverride()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AddressConfiguration, T> g) {
        return obj -> g.apply((AddressConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String bodyOverride;
        private String channelType;
        private Map<String, String> context = DefaultSdkAutoConstructMap.getInstance();
        private String rawContent;
        private Map<String, List<String>> substitutions = DefaultSdkAutoConstructMap.getInstance();
        private String titleOverride;

        private BuilderImpl() {
        }

        private BuilderImpl(AddressConfiguration model) {
            this.bodyOverride(model.bodyOverride);
            this.channelType(model.channelType);
            this.context(model.context);
            this.rawContent(model.rawContent);
            this.substitutions(model.substitutions);
            this.titleOverride(model.titleOverride);
        }

        public final String getBodyOverride() {
            return this.bodyOverride;
        }

        @Override
        public final Builder bodyOverride(String bodyOverride) {
            this.bodyOverride = bodyOverride;
            return this;
        }

        public final void setBodyOverride(String bodyOverride) {
            this.bodyOverride = bodyOverride;
        }

        public final String getChannelTypeAsString() {
            return this.channelType;
        }

        @Override
        public final Builder channelType(String channelType) {
            this.channelType = channelType;
            return this;
        }

        @Override
        public final Builder channelType(ChannelType channelType) {
            this.channelType(channelType.toString());
            return this;
        }

        public final void setChannelType(String channelType) {
            this.channelType = channelType;
        }

        public final Map<String, String> getContext() {
            return this.context;
        }

        @Override
        public final Builder context(Map<String, String> context) {
            this.context = MapOf__stringCopier.copy(context);
            return this;
        }

        public final void setContext(Map<String, String> context) {
            this.context = MapOf__stringCopier.copy(context);
        }

        public final String getRawContent() {
            return this.rawContent;
        }

        @Override
        public final Builder rawContent(String rawContent) {
            this.rawContent = rawContent;
            return this;
        }

        public final void setRawContent(String rawContent) {
            this.rawContent = rawContent;
        }

        public final Map<String, ? extends Collection<String>> getSubstitutions() {
            return this.substitutions;
        }

        @Override
        public final Builder substitutions(Map<String, ? extends Collection<String>> substitutions) {
            this.substitutions = MapOfListOf__stringCopier.copy(substitutions);
            return this;
        }

        public final void setSubstitutions(Map<String, ? extends Collection<String>> substitutions) {
            this.substitutions = MapOfListOf__stringCopier.copy(substitutions);
        }

        public final String getTitleOverride() {
            return this.titleOverride;
        }

        @Override
        public final Builder titleOverride(String titleOverride) {
            this.titleOverride = titleOverride;
            return this;
        }

        public final void setTitleOverride(String titleOverride) {
            this.titleOverride = titleOverride;
        }

        public AddressConfiguration build() {
            return new AddressConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AddressConfiguration> {
        public Builder bodyOverride(String var1);

        public Builder channelType(String var1);

        public Builder channelType(ChannelType var1);

        public Builder context(Map<String, String> var1);

        public Builder rawContent(String var1);

        public Builder substitutions(Map<String, ? extends Collection<String>> var1);

        public Builder titleOverride(String var1);
    }
}

