/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.pinpoint.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.pinpoint.model.ButtonAction;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DefaultButtonConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, DefaultButtonConfiguration> {
    private static final SdkField<String> BACKGROUND_COLOR_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("BackgroundColor").getter(DefaultButtonConfiguration.getter(DefaultButtonConfiguration::backgroundColor)).setter(DefaultButtonConfiguration.setter(Builder::backgroundColor)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BackgroundColor").build()}).build();
    private static final SdkField<Integer> BORDER_RADIUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("BorderRadius").getter(DefaultButtonConfiguration.getter(DefaultButtonConfiguration::borderRadius)).setter(DefaultButtonConfiguration.setter(Builder::borderRadius)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BorderRadius").build()}).build();
    private static final SdkField<String> BUTTON_ACTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ButtonAction").getter(DefaultButtonConfiguration.getter(DefaultButtonConfiguration::buttonActionAsString)).setter(DefaultButtonConfiguration.setter(Builder::buttonAction)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ButtonAction").build()}).build();
    private static final SdkField<String> LINK_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Link").getter(DefaultButtonConfiguration.getter(DefaultButtonConfiguration::link)).setter(DefaultButtonConfiguration.setter(Builder::link)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Link").build()}).build();
    private static final SdkField<String> TEXT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Text").getter(DefaultButtonConfiguration.getter(DefaultButtonConfiguration::text)).setter(DefaultButtonConfiguration.setter(Builder::text)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Text").build()}).build();
    private static final SdkField<String> TEXT_COLOR_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TextColor").getter(DefaultButtonConfiguration.getter(DefaultButtonConfiguration::textColor)).setter(DefaultButtonConfiguration.setter(Builder::textColor)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TextColor").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BACKGROUND_COLOR_FIELD, BORDER_RADIUS_FIELD, BUTTON_ACTION_FIELD, LINK_FIELD, TEXT_FIELD, TEXT_COLOR_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("BackgroundColor", BACKGROUND_COLOR_FIELD);
            this.put("BorderRadius", BORDER_RADIUS_FIELD);
            this.put("ButtonAction", BUTTON_ACTION_FIELD);
            this.put("Link", LINK_FIELD);
            this.put("Text", TEXT_FIELD);
            this.put("TextColor", TEXT_COLOR_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String backgroundColor;
    private final Integer borderRadius;
    private final String buttonAction;
    private final String link;
    private final String text;
    private final String textColor;

    private DefaultButtonConfiguration(BuilderImpl builder) {
        this.backgroundColor = builder.backgroundColor;
        this.borderRadius = builder.borderRadius;
        this.buttonAction = builder.buttonAction;
        this.link = builder.link;
        this.text = builder.text;
        this.textColor = builder.textColor;
    }

    public final String backgroundColor() {
        return this.backgroundColor;
    }

    public final Integer borderRadius() {
        return this.borderRadius;
    }

    public final ButtonAction buttonAction() {
        return ButtonAction.fromValue(this.buttonAction);
    }

    public final String buttonActionAsString() {
        return this.buttonAction;
    }

    public final String link() {
        return this.link;
    }

    public final String text() {
        return this.text;
    }

    public final String textColor() {
        return this.textColor;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.backgroundColor());
        hashCode = 31 * hashCode + Objects.hashCode(this.borderRadius());
        hashCode = 31 * hashCode + Objects.hashCode(this.buttonActionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.link());
        hashCode = 31 * hashCode + Objects.hashCode(this.text());
        hashCode = 31 * hashCode + Objects.hashCode(this.textColor());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DefaultButtonConfiguration)) {
            return false;
        }
        DefaultButtonConfiguration other = (DefaultButtonConfiguration)obj;
        return Objects.equals(this.backgroundColor(), other.backgroundColor()) && Objects.equals(this.borderRadius(), other.borderRadius()) && Objects.equals(this.buttonActionAsString(), other.buttonActionAsString()) && Objects.equals(this.link(), other.link()) && Objects.equals(this.text(), other.text()) && Objects.equals(this.textColor(), other.textColor());
    }

    public final String toString() {
        return ToString.builder((String)"DefaultButtonConfiguration").add("BackgroundColor", (Object)this.backgroundColor()).add("BorderRadius", (Object)this.borderRadius()).add("ButtonAction", (Object)this.buttonActionAsString()).add("Link", (Object)this.link()).add("Text", (Object)this.text()).add("TextColor", (Object)this.textColor()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "BackgroundColor": {
                return Optional.ofNullable(clazz.cast(this.backgroundColor()));
            }
            case "BorderRadius": {
                return Optional.ofNullable(clazz.cast(this.borderRadius()));
            }
            case "ButtonAction": {
                return Optional.ofNullable(clazz.cast(this.buttonActionAsString()));
            }
            case "Link": {
                return Optional.ofNullable(clazz.cast(this.link()));
            }
            case "Text": {
                return Optional.ofNullable(clazz.cast(this.text()));
            }
            case "TextColor": {
                return Optional.ofNullable(clazz.cast(this.textColor()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<DefaultButtonConfiguration, T> g) {
        return obj -> g.apply((DefaultButtonConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String backgroundColor;
        private Integer borderRadius;
        private String buttonAction;
        private String link;
        private String text;
        private String textColor;

        private BuilderImpl() {
        }

        private BuilderImpl(DefaultButtonConfiguration model) {
            this.backgroundColor(model.backgroundColor);
            this.borderRadius(model.borderRadius);
            this.buttonAction(model.buttonAction);
            this.link(model.link);
            this.text(model.text);
            this.textColor(model.textColor);
        }

        public final String getBackgroundColor() {
            return this.backgroundColor;
        }

        public final void setBackgroundColor(String backgroundColor) {
            this.backgroundColor = backgroundColor;
        }

        @Override
        public final Builder backgroundColor(String backgroundColor) {
            this.backgroundColor = backgroundColor;
            return this;
        }

        public final Integer getBorderRadius() {
            return this.borderRadius;
        }

        public final void setBorderRadius(Integer borderRadius) {
            this.borderRadius = borderRadius;
        }

        @Override
        public final Builder borderRadius(Integer borderRadius) {
            this.borderRadius = borderRadius;
            return this;
        }

        public final String getButtonAction() {
            return this.buttonAction;
        }

        public final void setButtonAction(String buttonAction) {
            this.buttonAction = buttonAction;
        }

        @Override
        public final Builder buttonAction(String buttonAction) {
            this.buttonAction = buttonAction;
            return this;
        }

        @Override
        public final Builder buttonAction(ButtonAction buttonAction) {
            this.buttonAction(buttonAction == null ? null : buttonAction.toString());
            return this;
        }

        public final String getLink() {
            return this.link;
        }

        public final void setLink(String link) {
            this.link = link;
        }

        @Override
        public final Builder link(String link) {
            this.link = link;
            return this;
        }

        public final String getText() {
            return this.text;
        }

        public final void setText(String text) {
            this.text = text;
        }

        @Override
        public final Builder text(String text) {
            this.text = text;
            return this;
        }

        public final String getTextColor() {
            return this.textColor;
        }

        public final void setTextColor(String textColor) {
            this.textColor = textColor;
        }

        @Override
        public final Builder textColor(String textColor) {
            this.textColor = textColor;
            return this;
        }

        public DefaultButtonConfiguration build() {
            return new DefaultButtonConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, DefaultButtonConfiguration> {
        public Builder backgroundColor(String var1);

        public Builder borderRadius(Integer var1);

        public Builder buttonAction(String var1);

        public Builder buttonAction(ButtonAction var1);

        public Builder link(String var1);

        public Builder text(String var1);

        public Builder textColor(String var1);
    }
}

