/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.pinpoint.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.pinpoint.model.MapOf__stringCopier;
import software.amazon.awssdk.services.pinpoint.model.SegmentDimensions;
import software.amazon.awssdk.services.pinpoint.model.SegmentGroupList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class WriteSegmentRequest
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, WriteSegmentRequest> {
    private static final SdkField<SegmentDimensions> DIMENSIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Dimensions").getter(WriteSegmentRequest.getter(WriteSegmentRequest::dimensions)).setter(WriteSegmentRequest.setter(Builder::dimensions)).constructor(SegmentDimensions::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Dimensions").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(WriteSegmentRequest.getter(WriteSegmentRequest::name)).setter(WriteSegmentRequest.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<SegmentGroupList> SEGMENT_GROUPS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("SegmentGroups").getter(WriteSegmentRequest.getter(WriteSegmentRequest::segmentGroups)).setter(WriteSegmentRequest.setter(Builder::segmentGroups)).constructor(SegmentGroupList::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SegmentGroups").build()}).build();
    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("tags").getter(WriteSegmentRequest.getter(WriteSegmentRequest::tags)).setter(WriteSegmentRequest.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DIMENSIONS_FIELD, NAME_FIELD, SEGMENT_GROUPS_FIELD, TAGS_FIELD));
    private static final long serialVersionUID = 1L;
    private final SegmentDimensions dimensions;
    private final String name;
    private final SegmentGroupList segmentGroups;
    private final Map<String, String> tags;

    private WriteSegmentRequest(BuilderImpl builder) {
        this.dimensions = builder.dimensions;
        this.name = builder.name;
        this.segmentGroups = builder.segmentGroups;
        this.tags = builder.tags;
    }

    public final SegmentDimensions dimensions() {
        return this.dimensions;
    }

    public final String name() {
        return this.name;
    }

    public final SegmentGroupList segmentGroups() {
        return this.segmentGroups;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> tags() {
        return this.tags;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.dimensions());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.segmentGroups());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof WriteSegmentRequest)) {
            return false;
        }
        WriteSegmentRequest other = (WriteSegmentRequest)obj;
        return Objects.equals(this.dimensions(), other.dimensions()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.segmentGroups(), other.segmentGroups()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags());
    }

    public final String toString() {
        return ToString.builder((String)"WriteSegmentRequest").add("Dimensions", (Object)this.dimensions()).add("Name", (Object)this.name()).add("SegmentGroups", (Object)this.segmentGroups()).add("Tags", this.hasTags() ? this.tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Dimensions": {
                return Optional.ofNullable(clazz.cast(this.dimensions()));
            }
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "SegmentGroups": {
                return Optional.ofNullable(clazz.cast(this.segmentGroups()));
            }
            case "tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<WriteSegmentRequest, T> g) {
        return obj -> g.apply((WriteSegmentRequest)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private SegmentDimensions dimensions;
        private String name;
        private SegmentGroupList segmentGroups;
        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(WriteSegmentRequest model) {
            this.dimensions(model.dimensions);
            this.name(model.name);
            this.segmentGroups(model.segmentGroups);
            this.tags(model.tags);
        }

        public final SegmentDimensions.Builder getDimensions() {
            return this.dimensions != null ? this.dimensions.toBuilder() : null;
        }

        public final void setDimensions(SegmentDimensions.BuilderImpl dimensions) {
            this.dimensions = dimensions != null ? dimensions.build() : null;
        }

        @Override
        public final Builder dimensions(SegmentDimensions dimensions) {
            this.dimensions = dimensions;
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final SegmentGroupList.Builder getSegmentGroups() {
            return this.segmentGroups != null ? this.segmentGroups.toBuilder() : null;
        }

        public final void setSegmentGroups(SegmentGroupList.BuilderImpl segmentGroups) {
            this.segmentGroups = segmentGroups != null ? segmentGroups.build() : null;
        }

        @Override
        public final Builder segmentGroups(SegmentGroupList segmentGroups) {
            this.segmentGroups = segmentGroups;
            return this;
        }

        public final Map<String, String> getTags() {
            if (this.tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = MapOf__stringCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = MapOf__stringCopier.copy(tags);
            return this;
        }

        public WriteSegmentRequest build() {
            return new WriteSegmentRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, WriteSegmentRequest> {
        public Builder dimensions(SegmentDimensions var1);

        default public Builder dimensions(Consumer<SegmentDimensions.Builder> dimensions) {
            return this.dimensions((SegmentDimensions)((SegmentDimensions.Builder)SegmentDimensions.builder().applyMutation(dimensions)).build());
        }

        public Builder name(String var1);

        public Builder segmentGroups(SegmentGroupList var1);

        default public Builder segmentGroups(Consumer<SegmentGroupList.Builder> segmentGroups) {
            return this.segmentGroups((SegmentGroupList)((SegmentGroupList.Builder)SegmentGroupList.builder().applyMutation(segmentGroups)).build());
        }

        public Builder tags(Map<String, String> var1);
    }
}

