/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.pinpoint.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.pinpoint.model.MapOf__stringCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class JourneyRunExecutionMetricsResponse
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, JourneyRunExecutionMetricsResponse> {
    private static final SdkField<String> APPLICATION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ApplicationId").getter(JourneyRunExecutionMetricsResponse.getter(JourneyRunExecutionMetricsResponse::applicationId)).setter(JourneyRunExecutionMetricsResponse.setter(Builder::applicationId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ApplicationId").build()}).build();
    private static final SdkField<String> JOURNEY_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("JourneyId").getter(JourneyRunExecutionMetricsResponse.getter(JourneyRunExecutionMetricsResponse::journeyId)).setter(JourneyRunExecutionMetricsResponse.setter(Builder::journeyId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("JourneyId").build()}).build();
    private static final SdkField<String> LAST_EVALUATED_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("LastEvaluatedTime").getter(JourneyRunExecutionMetricsResponse.getter(JourneyRunExecutionMetricsResponse::lastEvaluatedTime)).setter(JourneyRunExecutionMetricsResponse.setter(Builder::lastEvaluatedTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastEvaluatedTime").build()}).build();
    private static final SdkField<Map<String, String>> METRICS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("Metrics").getter(JourneyRunExecutionMetricsResponse.getter(JourneyRunExecutionMetricsResponse::metrics)).setter(JourneyRunExecutionMetricsResponse.setter(Builder::metrics)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Metrics").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<String> RUN_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RunId").getter(JourneyRunExecutionMetricsResponse.getter(JourneyRunExecutionMetricsResponse::runId)).setter(JourneyRunExecutionMetricsResponse.setter(Builder::runId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RunId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APPLICATION_ID_FIELD, JOURNEY_ID_FIELD, LAST_EVALUATED_TIME_FIELD, METRICS_FIELD, RUN_ID_FIELD));
    private static final long serialVersionUID = 1L;
    private final String applicationId;
    private final String journeyId;
    private final String lastEvaluatedTime;
    private final Map<String, String> metrics;
    private final String runId;

    private JourneyRunExecutionMetricsResponse(BuilderImpl builder) {
        this.applicationId = builder.applicationId;
        this.journeyId = builder.journeyId;
        this.lastEvaluatedTime = builder.lastEvaluatedTime;
        this.metrics = builder.metrics;
        this.runId = builder.runId;
    }

    public final String applicationId() {
        return this.applicationId;
    }

    public final String journeyId() {
        return this.journeyId;
    }

    public final String lastEvaluatedTime() {
        return this.lastEvaluatedTime;
    }

    public final boolean hasMetrics() {
        return this.metrics != null && !(this.metrics instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> metrics() {
        return this.metrics;
    }

    public final String runId() {
        return this.runId;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.applicationId());
        hashCode = 31 * hashCode + Objects.hashCode(this.journeyId());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastEvaluatedTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasMetrics() ? this.metrics() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.runId());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof JourneyRunExecutionMetricsResponse)) {
            return false;
        }
        JourneyRunExecutionMetricsResponse other = (JourneyRunExecutionMetricsResponse)obj;
        return Objects.equals(this.applicationId(), other.applicationId()) && Objects.equals(this.journeyId(), other.journeyId()) && Objects.equals(this.lastEvaluatedTime(), other.lastEvaluatedTime()) && this.hasMetrics() == other.hasMetrics() && Objects.equals(this.metrics(), other.metrics()) && Objects.equals(this.runId(), other.runId());
    }

    public final String toString() {
        return ToString.builder((String)"JourneyRunExecutionMetricsResponse").add("ApplicationId", (Object)this.applicationId()).add("JourneyId", (Object)this.journeyId()).add("LastEvaluatedTime", (Object)this.lastEvaluatedTime()).add("Metrics", this.hasMetrics() ? this.metrics() : null).add("RunId", (Object)this.runId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ApplicationId": {
                return Optional.ofNullable(clazz.cast(this.applicationId()));
            }
            case "JourneyId": {
                return Optional.ofNullable(clazz.cast(this.journeyId()));
            }
            case "LastEvaluatedTime": {
                return Optional.ofNullable(clazz.cast(this.lastEvaluatedTime()));
            }
            case "Metrics": {
                return Optional.ofNullable(clazz.cast(this.metrics()));
            }
            case "RunId": {
                return Optional.ofNullable(clazz.cast(this.runId()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<JourneyRunExecutionMetricsResponse, T> g) {
        return obj -> g.apply((JourneyRunExecutionMetricsResponse)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String applicationId;
        private String journeyId;
        private String lastEvaluatedTime;
        private Map<String, String> metrics = DefaultSdkAutoConstructMap.getInstance();
        private String runId;

        private BuilderImpl() {
        }

        private BuilderImpl(JourneyRunExecutionMetricsResponse model) {
            this.applicationId(model.applicationId);
            this.journeyId(model.journeyId);
            this.lastEvaluatedTime(model.lastEvaluatedTime);
            this.metrics(model.metrics);
            this.runId(model.runId);
        }

        public final String getApplicationId() {
            return this.applicationId;
        }

        public final void setApplicationId(String applicationId) {
            this.applicationId = applicationId;
        }

        @Override
        public final Builder applicationId(String applicationId) {
            this.applicationId = applicationId;
            return this;
        }

        public final String getJourneyId() {
            return this.journeyId;
        }

        public final void setJourneyId(String journeyId) {
            this.journeyId = journeyId;
        }

        @Override
        public final Builder journeyId(String journeyId) {
            this.journeyId = journeyId;
            return this;
        }

        public final String getLastEvaluatedTime() {
            return this.lastEvaluatedTime;
        }

        public final void setLastEvaluatedTime(String lastEvaluatedTime) {
            this.lastEvaluatedTime = lastEvaluatedTime;
        }

        @Override
        public final Builder lastEvaluatedTime(String lastEvaluatedTime) {
            this.lastEvaluatedTime = lastEvaluatedTime;
            return this;
        }

        public final Map<String, String> getMetrics() {
            if (this.metrics instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.metrics;
        }

        public final void setMetrics(Map<String, String> metrics) {
            this.metrics = MapOf__stringCopier.copy(metrics);
        }

        @Override
        public final Builder metrics(Map<String, String> metrics) {
            this.metrics = MapOf__stringCopier.copy(metrics);
            return this;
        }

        public final String getRunId() {
            return this.runId;
        }

        public final void setRunId(String runId) {
            this.runId = runId;
        }

        @Override
        public final Builder runId(String runId) {
            this.runId = runId;
            return this;
        }

        public JourneyRunExecutionMetricsResponse build() {
            return new JourneyRunExecutionMetricsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, JourneyRunExecutionMetricsResponse> {
        public Builder applicationId(String var1);

        public Builder journeyId(String var1);

        public Builder lastEvaluatedTime(String var1);

        public Builder metrics(Map<String, String> var1);

        public Builder runId(String var1);
    }
}

