/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.pinpoint.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.pinpoint.model.Action;
import software.amazon.awssdk.services.pinpoint.model.MapOfListOf__stringCopier;
import software.amazon.awssdk.services.pinpoint.model.MapOf__stringCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ADMMessage
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ADMMessage> {
    private static final SdkField<String> ACTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Action").getter(ADMMessage.getter(ADMMessage::actionAsString)).setter(ADMMessage.setter(Builder::action)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Action").build()}).build();
    private static final SdkField<String> BODY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Body").getter(ADMMessage.getter(ADMMessage::body)).setter(ADMMessage.setter(Builder::body)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Body").build()}).build();
    private static final SdkField<String> CONSOLIDATION_KEY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ConsolidationKey").getter(ADMMessage.getter(ADMMessage::consolidationKey)).setter(ADMMessage.setter(Builder::consolidationKey)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConsolidationKey").build()}).build();
    private static final SdkField<Map<String, String>> DATA_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("Data").getter(ADMMessage.getter(ADMMessage::data)).setter(ADMMessage.setter(Builder::data)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Data").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<String> EXPIRES_AFTER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ExpiresAfter").getter(ADMMessage.getter(ADMMessage::expiresAfter)).setter(ADMMessage.setter(Builder::expiresAfter)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExpiresAfter").build()}).build();
    private static final SdkField<String> ICON_REFERENCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("IconReference").getter(ADMMessage.getter(ADMMessage::iconReference)).setter(ADMMessage.setter(Builder::iconReference)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IconReference").build()}).build();
    private static final SdkField<String> IMAGE_ICON_URL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ImageIconUrl").getter(ADMMessage.getter(ADMMessage::imageIconUrl)).setter(ADMMessage.setter(Builder::imageIconUrl)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ImageIconUrl").build()}).build();
    private static final SdkField<String> IMAGE_URL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ImageUrl").getter(ADMMessage.getter(ADMMessage::imageUrl)).setter(ADMMessage.setter(Builder::imageUrl)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ImageUrl").build()}).build();
    private static final SdkField<String> MD5_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("MD5").getter(ADMMessage.getter(ADMMessage::md5)).setter(ADMMessage.setter(Builder::md5)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MD5").build()}).build();
    private static final SdkField<String> RAW_CONTENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RawContent").getter(ADMMessage.getter(ADMMessage::rawContent)).setter(ADMMessage.setter(Builder::rawContent)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RawContent").build()}).build();
    private static final SdkField<Boolean> SILENT_PUSH_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("SilentPush").getter(ADMMessage.getter(ADMMessage::silentPush)).setter(ADMMessage.setter(Builder::silentPush)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SilentPush").build()}).build();
    private static final SdkField<String> SMALL_IMAGE_ICON_URL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SmallImageIconUrl").getter(ADMMessage.getter(ADMMessage::smallImageIconUrl)).setter(ADMMessage.setter(Builder::smallImageIconUrl)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SmallImageIconUrl").build()}).build();
    private static final SdkField<String> SOUND_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Sound").getter(ADMMessage.getter(ADMMessage::sound)).setter(ADMMessage.setter(Builder::sound)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Sound").build()}).build();
    private static final SdkField<Map<String, List<String>>> SUBSTITUTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("Substitutions").getter(ADMMessage.getter(ADMMessage::substitutions)).setter(ADMMessage.setter(Builder::substitutions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Substitutions").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.LIST).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build()).build()}).build();
    private static final SdkField<String> TITLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Title").getter(ADMMessage.getter(ADMMessage::title)).setter(ADMMessage.setter(Builder::title)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Title").build()}).build();
    private static final SdkField<String> URL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Url").getter(ADMMessage.getter(ADMMessage::url)).setter(ADMMessage.setter(Builder::url)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Url").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACTION_FIELD, BODY_FIELD, CONSOLIDATION_KEY_FIELD, DATA_FIELD, EXPIRES_AFTER_FIELD, ICON_REFERENCE_FIELD, IMAGE_ICON_URL_FIELD, IMAGE_URL_FIELD, MD5_FIELD, RAW_CONTENT_FIELD, SILENT_PUSH_FIELD, SMALL_IMAGE_ICON_URL_FIELD, SOUND_FIELD, SUBSTITUTIONS_FIELD, TITLE_FIELD, URL_FIELD));
    private static final long serialVersionUID = 1L;
    private final String action;
    private final String body;
    private final String consolidationKey;
    private final Map<String, String> data;
    private final String expiresAfter;
    private final String iconReference;
    private final String imageIconUrl;
    private final String imageUrl;
    private final String md5;
    private final String rawContent;
    private final Boolean silentPush;
    private final String smallImageIconUrl;
    private final String sound;
    private final Map<String, List<String>> substitutions;
    private final String title;
    private final String url;

    private ADMMessage(BuilderImpl builder) {
        this.action = builder.action;
        this.body = builder.body;
        this.consolidationKey = builder.consolidationKey;
        this.data = builder.data;
        this.expiresAfter = builder.expiresAfter;
        this.iconReference = builder.iconReference;
        this.imageIconUrl = builder.imageIconUrl;
        this.imageUrl = builder.imageUrl;
        this.md5 = builder.md5;
        this.rawContent = builder.rawContent;
        this.silentPush = builder.silentPush;
        this.smallImageIconUrl = builder.smallImageIconUrl;
        this.sound = builder.sound;
        this.substitutions = builder.substitutions;
        this.title = builder.title;
        this.url = builder.url;
    }

    public final Action action() {
        return Action.fromValue(this.action);
    }

    public final String actionAsString() {
        return this.action;
    }

    public final String body() {
        return this.body;
    }

    public final String consolidationKey() {
        return this.consolidationKey;
    }

    public final boolean hasData() {
        return this.data != null && !(this.data instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> data() {
        return this.data;
    }

    public final String expiresAfter() {
        return this.expiresAfter;
    }

    public final String iconReference() {
        return this.iconReference;
    }

    public final String imageIconUrl() {
        return this.imageIconUrl;
    }

    public final String imageUrl() {
        return this.imageUrl;
    }

    public final String md5() {
        return this.md5;
    }

    public final String rawContent() {
        return this.rawContent;
    }

    public final Boolean silentPush() {
        return this.silentPush;
    }

    public final String smallImageIconUrl() {
        return this.smallImageIconUrl;
    }

    public final String sound() {
        return this.sound;
    }

    public final boolean hasSubstitutions() {
        return this.substitutions != null && !(this.substitutions instanceof SdkAutoConstructMap);
    }

    public final Map<String, List<String>> substitutions() {
        return this.substitutions;
    }

    public final String title() {
        return this.title;
    }

    public final String url() {
        return this.url;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.actionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.body());
        hashCode = 31 * hashCode + Objects.hashCode(this.consolidationKey());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasData() ? this.data() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.expiresAfter());
        hashCode = 31 * hashCode + Objects.hashCode(this.iconReference());
        hashCode = 31 * hashCode + Objects.hashCode(this.imageIconUrl());
        hashCode = 31 * hashCode + Objects.hashCode(this.imageUrl());
        hashCode = 31 * hashCode + Objects.hashCode(this.md5());
        hashCode = 31 * hashCode + Objects.hashCode(this.rawContent());
        hashCode = 31 * hashCode + Objects.hashCode(this.silentPush());
        hashCode = 31 * hashCode + Objects.hashCode(this.smallImageIconUrl());
        hashCode = 31 * hashCode + Objects.hashCode(this.sound());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSubstitutions() ? this.substitutions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.title());
        hashCode = 31 * hashCode + Objects.hashCode(this.url());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ADMMessage)) {
            return false;
        }
        ADMMessage other = (ADMMessage)obj;
        return Objects.equals(this.actionAsString(), other.actionAsString()) && Objects.equals(this.body(), other.body()) && Objects.equals(this.consolidationKey(), other.consolidationKey()) && this.hasData() == other.hasData() && Objects.equals(this.data(), other.data()) && Objects.equals(this.expiresAfter(), other.expiresAfter()) && Objects.equals(this.iconReference(), other.iconReference()) && Objects.equals(this.imageIconUrl(), other.imageIconUrl()) && Objects.equals(this.imageUrl(), other.imageUrl()) && Objects.equals(this.md5(), other.md5()) && Objects.equals(this.rawContent(), other.rawContent()) && Objects.equals(this.silentPush(), other.silentPush()) && Objects.equals(this.smallImageIconUrl(), other.smallImageIconUrl()) && Objects.equals(this.sound(), other.sound()) && this.hasSubstitutions() == other.hasSubstitutions() && Objects.equals(this.substitutions(), other.substitutions()) && Objects.equals(this.title(), other.title()) && Objects.equals(this.url(), other.url());
    }

    public final String toString() {
        return ToString.builder((String)"ADMMessage").add("Action", (Object)this.actionAsString()).add("Body", (Object)this.body()).add("ConsolidationKey", (Object)this.consolidationKey()).add("Data", this.hasData() ? this.data() : null).add("ExpiresAfter", (Object)this.expiresAfter()).add("IconReference", (Object)this.iconReference()).add("ImageIconUrl", (Object)this.imageIconUrl()).add("ImageUrl", (Object)this.imageUrl()).add("MD5", (Object)this.md5()).add("RawContent", (Object)this.rawContent()).add("SilentPush", (Object)this.silentPush()).add("SmallImageIconUrl", (Object)this.smallImageIconUrl()).add("Sound", (Object)this.sound()).add("Substitutions", this.hasSubstitutions() ? this.substitutions() : null).add("Title", (Object)this.title()).add("Url", (Object)this.url()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Action": {
                return Optional.ofNullable(clazz.cast(this.actionAsString()));
            }
            case "Body": {
                return Optional.ofNullable(clazz.cast(this.body()));
            }
            case "ConsolidationKey": {
                return Optional.ofNullable(clazz.cast(this.consolidationKey()));
            }
            case "Data": {
                return Optional.ofNullable(clazz.cast(this.data()));
            }
            case "ExpiresAfter": {
                return Optional.ofNullable(clazz.cast(this.expiresAfter()));
            }
            case "IconReference": {
                return Optional.ofNullable(clazz.cast(this.iconReference()));
            }
            case "ImageIconUrl": {
                return Optional.ofNullable(clazz.cast(this.imageIconUrl()));
            }
            case "ImageUrl": {
                return Optional.ofNullable(clazz.cast(this.imageUrl()));
            }
            case "MD5": {
                return Optional.ofNullable(clazz.cast(this.md5()));
            }
            case "RawContent": {
                return Optional.ofNullable(clazz.cast(this.rawContent()));
            }
            case "SilentPush": {
                return Optional.ofNullable(clazz.cast(this.silentPush()));
            }
            case "SmallImageIconUrl": {
                return Optional.ofNullable(clazz.cast(this.smallImageIconUrl()));
            }
            case "Sound": {
                return Optional.ofNullable(clazz.cast(this.sound()));
            }
            case "Substitutions": {
                return Optional.ofNullable(clazz.cast(this.substitutions()));
            }
            case "Title": {
                return Optional.ofNullable(clazz.cast(this.title()));
            }
            case "Url": {
                return Optional.ofNullable(clazz.cast(this.url()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ADMMessage, T> g) {
        return obj -> g.apply((ADMMessage)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String action;
        private String body;
        private String consolidationKey;
        private Map<String, String> data = DefaultSdkAutoConstructMap.getInstance();
        private String expiresAfter;
        private String iconReference;
        private String imageIconUrl;
        private String imageUrl;
        private String md5;
        private String rawContent;
        private Boolean silentPush;
        private String smallImageIconUrl;
        private String sound;
        private Map<String, List<String>> substitutions = DefaultSdkAutoConstructMap.getInstance();
        private String title;
        private String url;

        private BuilderImpl() {
        }

        private BuilderImpl(ADMMessage model) {
            this.action(model.action);
            this.body(model.body);
            this.consolidationKey(model.consolidationKey);
            this.data(model.data);
            this.expiresAfter(model.expiresAfter);
            this.iconReference(model.iconReference);
            this.imageIconUrl(model.imageIconUrl);
            this.imageUrl(model.imageUrl);
            this.md5(model.md5);
            this.rawContent(model.rawContent);
            this.silentPush(model.silentPush);
            this.smallImageIconUrl(model.smallImageIconUrl);
            this.sound(model.sound);
            this.substitutions(model.substitutions);
            this.title(model.title);
            this.url(model.url);
        }

        public final String getAction() {
            return this.action;
        }

        public final void setAction(String action) {
            this.action = action;
        }

        @Override
        public final Builder action(String action) {
            this.action = action;
            return this;
        }

        @Override
        public final Builder action(Action action) {
            this.action(action == null ? null : action.toString());
            return this;
        }

        public final String getBody() {
            return this.body;
        }

        public final void setBody(String body) {
            this.body = body;
        }

        @Override
        public final Builder body(String body) {
            this.body = body;
            return this;
        }

        public final String getConsolidationKey() {
            return this.consolidationKey;
        }

        public final void setConsolidationKey(String consolidationKey) {
            this.consolidationKey = consolidationKey;
        }

        @Override
        public final Builder consolidationKey(String consolidationKey) {
            this.consolidationKey = consolidationKey;
            return this;
        }

        public final Map<String, String> getData() {
            if (this.data instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.data;
        }

        public final void setData(Map<String, String> data) {
            this.data = MapOf__stringCopier.copy(data);
        }

        @Override
        public final Builder data(Map<String, String> data) {
            this.data = MapOf__stringCopier.copy(data);
            return this;
        }

        public final String getExpiresAfter() {
            return this.expiresAfter;
        }

        public final void setExpiresAfter(String expiresAfter) {
            this.expiresAfter = expiresAfter;
        }

        @Override
        public final Builder expiresAfter(String expiresAfter) {
            this.expiresAfter = expiresAfter;
            return this;
        }

        public final String getIconReference() {
            return this.iconReference;
        }

        public final void setIconReference(String iconReference) {
            this.iconReference = iconReference;
        }

        @Override
        public final Builder iconReference(String iconReference) {
            this.iconReference = iconReference;
            return this;
        }

        public final String getImageIconUrl() {
            return this.imageIconUrl;
        }

        public final void setImageIconUrl(String imageIconUrl) {
            this.imageIconUrl = imageIconUrl;
        }

        @Override
        public final Builder imageIconUrl(String imageIconUrl) {
            this.imageIconUrl = imageIconUrl;
            return this;
        }

        public final String getImageUrl() {
            return this.imageUrl;
        }

        public final void setImageUrl(String imageUrl) {
            this.imageUrl = imageUrl;
        }

        @Override
        public final Builder imageUrl(String imageUrl) {
            this.imageUrl = imageUrl;
            return this;
        }

        public final String getMd5() {
            return this.md5;
        }

        public final void setMd5(String md5) {
            this.md5 = md5;
        }

        @Override
        public final Builder md5(String md5) {
            this.md5 = md5;
            return this;
        }

        public final String getRawContent() {
            return this.rawContent;
        }

        public final void setRawContent(String rawContent) {
            this.rawContent = rawContent;
        }

        @Override
        public final Builder rawContent(String rawContent) {
            this.rawContent = rawContent;
            return this;
        }

        public final Boolean getSilentPush() {
            return this.silentPush;
        }

        public final void setSilentPush(Boolean silentPush) {
            this.silentPush = silentPush;
        }

        @Override
        public final Builder silentPush(Boolean silentPush) {
            this.silentPush = silentPush;
            return this;
        }

        public final String getSmallImageIconUrl() {
            return this.smallImageIconUrl;
        }

        public final void setSmallImageIconUrl(String smallImageIconUrl) {
            this.smallImageIconUrl = smallImageIconUrl;
        }

        @Override
        public final Builder smallImageIconUrl(String smallImageIconUrl) {
            this.smallImageIconUrl = smallImageIconUrl;
            return this;
        }

        public final String getSound() {
            return this.sound;
        }

        public final void setSound(String sound) {
            this.sound = sound;
        }

        @Override
        public final Builder sound(String sound) {
            this.sound = sound;
            return this;
        }

        public final Map<String, ? extends Collection<String>> getSubstitutions() {
            if (this.substitutions instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.substitutions;
        }

        public final void setSubstitutions(Map<String, ? extends Collection<String>> substitutions) {
            this.substitutions = MapOfListOf__stringCopier.copy(substitutions);
        }

        @Override
        public final Builder substitutions(Map<String, ? extends Collection<String>> substitutions) {
            this.substitutions = MapOfListOf__stringCopier.copy(substitutions);
            return this;
        }

        public final String getTitle() {
            return this.title;
        }

        public final void setTitle(String title) {
            this.title = title;
        }

        @Override
        public final Builder title(String title) {
            this.title = title;
            return this;
        }

        public final String getUrl() {
            return this.url;
        }

        public final void setUrl(String url) {
            this.url = url;
        }

        @Override
        public final Builder url(String url) {
            this.url = url;
            return this;
        }

        public ADMMessage build() {
            return new ADMMessage(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ADMMessage> {
        public Builder action(String var1);

        public Builder action(Action var1);

        public Builder body(String var1);

        public Builder consolidationKey(String var1);

        public Builder data(Map<String, String> var1);

        public Builder expiresAfter(String var1);

        public Builder iconReference(String var1);

        public Builder imageIconUrl(String var1);

        public Builder imageUrl(String var1);

        public Builder md5(String var1);

        public Builder rawContent(String var1);

        public Builder silentPush(Boolean var1);

        public Builder smallImageIconUrl(String var1);

        public Builder sound(String var1);

        public Builder substitutions(Map<String, ? extends Collection<String>> var1);

        public Builder title(String var1);

        public Builder url(String var1);
    }
}

