/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.pinpoint.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ExportJobResource
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ExportJobResource> {
    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RoleArn").getter(ExportJobResource.getter(ExportJobResource::roleArn)).setter(ExportJobResource.setter(Builder::roleArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RoleArn").build()}).build();
    private static final SdkField<String> S3_URL_PREFIX_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("S3UrlPrefix").getter(ExportJobResource.getter(ExportJobResource::s3UrlPrefix)).setter(ExportJobResource.setter(Builder::s3UrlPrefix)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("S3UrlPrefix").build()}).build();
    private static final SdkField<String> SEGMENT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SegmentId").getter(ExportJobResource.getter(ExportJobResource::segmentId)).setter(ExportJobResource.setter(Builder::segmentId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SegmentId").build()}).build();
    private static final SdkField<Integer> SEGMENT_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("SegmentVersion").getter(ExportJobResource.getter(ExportJobResource::segmentVersion)).setter(ExportJobResource.setter(Builder::segmentVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SegmentVersion").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ROLE_ARN_FIELD, S3_URL_PREFIX_FIELD, SEGMENT_ID_FIELD, SEGMENT_VERSION_FIELD));
    private static final long serialVersionUID = 1L;
    private final String roleArn;
    private final String s3UrlPrefix;
    private final String segmentId;
    private final Integer segmentVersion;

    private ExportJobResource(BuilderImpl builder) {
        this.roleArn = builder.roleArn;
        this.s3UrlPrefix = builder.s3UrlPrefix;
        this.segmentId = builder.segmentId;
        this.segmentVersion = builder.segmentVersion;
    }

    public final String roleArn() {
        return this.roleArn;
    }

    public final String s3UrlPrefix() {
        return this.s3UrlPrefix;
    }

    public final String segmentId() {
        return this.segmentId;
    }

    public final Integer segmentVersion() {
        return this.segmentVersion;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.roleArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.s3UrlPrefix());
        hashCode = 31 * hashCode + Objects.hashCode(this.segmentId());
        hashCode = 31 * hashCode + Objects.hashCode(this.segmentVersion());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ExportJobResource)) {
            return false;
        }
        ExportJobResource other = (ExportJobResource)obj;
        return Objects.equals(this.roleArn(), other.roleArn()) && Objects.equals(this.s3UrlPrefix(), other.s3UrlPrefix()) && Objects.equals(this.segmentId(), other.segmentId()) && Objects.equals(this.segmentVersion(), other.segmentVersion());
    }

    public final String toString() {
        return ToString.builder((String)"ExportJobResource").add("RoleArn", (Object)this.roleArn()).add("S3UrlPrefix", (Object)this.s3UrlPrefix()).add("SegmentId", (Object)this.segmentId()).add("SegmentVersion", (Object)this.segmentVersion()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "RoleArn": {
                return Optional.ofNullable(clazz.cast(this.roleArn()));
            }
            case "S3UrlPrefix": {
                return Optional.ofNullable(clazz.cast(this.s3UrlPrefix()));
            }
            case "SegmentId": {
                return Optional.ofNullable(clazz.cast(this.segmentId()));
            }
            case "SegmentVersion": {
                return Optional.ofNullable(clazz.cast(this.segmentVersion()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ExportJobResource, T> g) {
        return obj -> g.apply((ExportJobResource)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String roleArn;
        private String s3UrlPrefix;
        private String segmentId;
        private Integer segmentVersion;

        private BuilderImpl() {
        }

        private BuilderImpl(ExportJobResource model) {
            this.roleArn(model.roleArn);
            this.s3UrlPrefix(model.s3UrlPrefix);
            this.segmentId(model.segmentId);
            this.segmentVersion(model.segmentVersion);
        }

        public final String getRoleArn() {
            return this.roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        public final String getS3UrlPrefix() {
            return this.s3UrlPrefix;
        }

        @Override
        public final Builder s3UrlPrefix(String s3UrlPrefix) {
            this.s3UrlPrefix = s3UrlPrefix;
            return this;
        }

        public final void setS3UrlPrefix(String s3UrlPrefix) {
            this.s3UrlPrefix = s3UrlPrefix;
        }

        public final String getSegmentId() {
            return this.segmentId;
        }

        @Override
        public final Builder segmentId(String segmentId) {
            this.segmentId = segmentId;
            return this;
        }

        public final void setSegmentId(String segmentId) {
            this.segmentId = segmentId;
        }

        public final Integer getSegmentVersion() {
            return this.segmentVersion;
        }

        @Override
        public final Builder segmentVersion(Integer segmentVersion) {
            this.segmentVersion = segmentVersion;
            return this;
        }

        public final void setSegmentVersion(Integer segmentVersion) {
            this.segmentVersion = segmentVersion;
        }

        public ExportJobResource build() {
            return new ExportJobResource(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ExportJobResource> {
        public Builder roleArn(String var1);

        public Builder s3UrlPrefix(String var1);

        public Builder segmentId(String var1);

        public Builder segmentVersion(Integer var1);
    }
}

