/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.pinpoint.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.PayloadTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.pinpoint.model.PinpointRequest;
import software.amazon.awssdk.services.pinpoint.model.PushNotificationTemplateRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdatePushTemplateRequest
extends PinpointRequest
implements ToCopyableBuilder<Builder, UpdatePushTemplateRequest> {
    private static final SdkField<Boolean> CREATE_NEW_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).getter(UpdatePushTemplateRequest.getter(UpdatePushTemplateRequest::createNewVersion)).setter(UpdatePushTemplateRequest.setter(Builder::createNewVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("create-new-version").build()}).build();
    private static final SdkField<PushNotificationTemplateRequest> PUSH_NOTIFICATION_TEMPLATE_REQUEST_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(UpdatePushTemplateRequest.getter(UpdatePushTemplateRequest::pushNotificationTemplateRequest)).setter(UpdatePushTemplateRequest.setter(Builder::pushNotificationTemplateRequest)).constructor(PushNotificationTemplateRequest::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PushNotificationTemplateRequest").build(), PayloadTrait.create()}).build();
    private static final SdkField<String> TEMPLATE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(UpdatePushTemplateRequest.getter(UpdatePushTemplateRequest::templateName)).setter(UpdatePushTemplateRequest.setter(Builder::templateName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("template-name").build()}).build();
    private static final SdkField<String> VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(UpdatePushTemplateRequest.getter(UpdatePushTemplateRequest::version)).setter(UpdatePushTemplateRequest.setter(Builder::version)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("version").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CREATE_NEW_VERSION_FIELD, PUSH_NOTIFICATION_TEMPLATE_REQUEST_FIELD, TEMPLATE_NAME_FIELD, VERSION_FIELD));
    private final Boolean createNewVersion;
    private final PushNotificationTemplateRequest pushNotificationTemplateRequest;
    private final String templateName;
    private final String version;

    private UpdatePushTemplateRequest(BuilderImpl builder) {
        super(builder);
        this.createNewVersion = builder.createNewVersion;
        this.pushNotificationTemplateRequest = builder.pushNotificationTemplateRequest;
        this.templateName = builder.templateName;
        this.version = builder.version;
    }

    public Boolean createNewVersion() {
        return this.createNewVersion;
    }

    public PushNotificationTemplateRequest pushNotificationTemplateRequest() {
        return this.pushNotificationTemplateRequest;
    }

    public String templateName() {
        return this.templateName;
    }

    public String version() {
        return this.version;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.createNewVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.pushNotificationTemplateRequest());
        hashCode = 31 * hashCode + Objects.hashCode(this.templateName());
        hashCode = 31 * hashCode + Objects.hashCode(this.version());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdatePushTemplateRequest)) {
            return false;
        }
        UpdatePushTemplateRequest other = (UpdatePushTemplateRequest)((Object)obj);
        return Objects.equals(this.createNewVersion(), other.createNewVersion()) && Objects.equals(this.pushNotificationTemplateRequest(), other.pushNotificationTemplateRequest()) && Objects.equals(this.templateName(), other.templateName()) && Objects.equals(this.version(), other.version());
    }

    public String toString() {
        return ToString.builder((String)"UpdatePushTemplateRequest").add("CreateNewVersion", (Object)this.createNewVersion()).add("PushNotificationTemplateRequest", (Object)this.pushNotificationTemplateRequest()).add("TemplateName", (Object)this.templateName()).add("Version", (Object)this.version()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "CreateNewVersion": {
                return Optional.ofNullable(clazz.cast(this.createNewVersion()));
            }
            case "PushNotificationTemplateRequest": {
                return Optional.ofNullable(clazz.cast(this.pushNotificationTemplateRequest()));
            }
            case "TemplateName": {
                return Optional.ofNullable(clazz.cast(this.templateName()));
            }
            case "Version": {
                return Optional.ofNullable(clazz.cast(this.version()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdatePushTemplateRequest, T> g) {
        return obj -> g.apply((UpdatePushTemplateRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends PinpointRequest.BuilderImpl
    implements Builder {
        private Boolean createNewVersion;
        private PushNotificationTemplateRequest pushNotificationTemplateRequest;
        private String templateName;
        private String version;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdatePushTemplateRequest model) {
            super(model);
            this.createNewVersion(model.createNewVersion);
            this.pushNotificationTemplateRequest(model.pushNotificationTemplateRequest);
            this.templateName(model.templateName);
            this.version(model.version);
        }

        public final Boolean getCreateNewVersion() {
            return this.createNewVersion;
        }

        @Override
        public final Builder createNewVersion(Boolean createNewVersion) {
            this.createNewVersion = createNewVersion;
            return this;
        }

        public final void setCreateNewVersion(Boolean createNewVersion) {
            this.createNewVersion = createNewVersion;
        }

        public final PushNotificationTemplateRequest.Builder getPushNotificationTemplateRequest() {
            return this.pushNotificationTemplateRequest != null ? this.pushNotificationTemplateRequest.toBuilder() : null;
        }

        @Override
        public final Builder pushNotificationTemplateRequest(PushNotificationTemplateRequest pushNotificationTemplateRequest) {
            this.pushNotificationTemplateRequest = pushNotificationTemplateRequest;
            return this;
        }

        public final void setPushNotificationTemplateRequest(PushNotificationTemplateRequest.BuilderImpl pushNotificationTemplateRequest) {
            this.pushNotificationTemplateRequest = pushNotificationTemplateRequest != null ? pushNotificationTemplateRequest.build() : null;
        }

        public final String getTemplateName() {
            return this.templateName;
        }

        @Override
        public final Builder templateName(String templateName) {
            this.templateName = templateName;
            return this;
        }

        public final void setTemplateName(String templateName) {
            this.templateName = templateName;
        }

        public final String getVersion() {
            return this.version;
        }

        @Override
        public final Builder version(String version) {
            this.version = version;
            return this;
        }

        public final void setVersion(String version) {
            this.version = version;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdatePushTemplateRequest build() {
            return new UpdatePushTemplateRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends PinpointRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdatePushTemplateRequest> {
        public Builder createNewVersion(Boolean var1);

        public Builder pushNotificationTemplateRequest(PushNotificationTemplateRequest var1);

        default public Builder pushNotificationTemplateRequest(Consumer<PushNotificationTemplateRequest.Builder> pushNotificationTemplateRequest) {
            return this.pushNotificationTemplateRequest((PushNotificationTemplateRequest)((PushNotificationTemplateRequest.Builder)PushNotificationTemplateRequest.builder().applyMutation(pushNotificationTemplateRequest)).build());
        }

        public Builder templateName(String var1);

        public Builder version(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

