/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.pinpoint.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.pinpoint.model.EventsBatch;
import software.amazon.awssdk.services.pinpoint.model.MapOfEventsBatchCopier;
import software.amazon.awssdk.utils.CollectionUtils;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class EventsRequest
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, EventsRequest> {
    private static final SdkField<Map<String, EventsBatch>> BATCH_ITEM_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).getter(EventsRequest.getter(EventsRequest::batchItem)).setter(EventsRequest.setter(Builder::batchItem)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BatchItem").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(EventsBatch::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BATCH_ITEM_FIELD));
    private static final long serialVersionUID = 1L;
    private final Map<String, EventsBatch> batchItem;

    private EventsRequest(BuilderImpl builder) {
        this.batchItem = builder.batchItem;
    }

    public boolean hasBatchItem() {
        return this.batchItem != null && !(this.batchItem instanceof SdkAutoConstructMap);
    }

    public Map<String, EventsBatch> batchItem() {
        return this.batchItem;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.batchItem());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EventsRequest)) {
            return false;
        }
        EventsRequest other = (EventsRequest)obj;
        return Objects.equals(this.batchItem(), other.batchItem());
    }

    public String toString() {
        return ToString.builder((String)"EventsRequest").add("BatchItem", this.batchItem()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "BatchItem": {
                return Optional.ofNullable(clazz.cast(this.batchItem()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<EventsRequest, T> g) {
        return obj -> g.apply((EventsRequest)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Map<String, EventsBatch> batchItem = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(EventsRequest model) {
            this.batchItem(model.batchItem);
        }

        public final Map<String, EventsBatch.Builder> getBatchItem() {
            return this.batchItem != null ? CollectionUtils.mapValues(this.batchItem, EventsBatch::toBuilder) : null;
        }

        @Override
        public final Builder batchItem(Map<String, EventsBatch> batchItem) {
            this.batchItem = MapOfEventsBatchCopier.copy(batchItem);
            return this;
        }

        public final void setBatchItem(Map<String, EventsBatch.BuilderImpl> batchItem) {
            this.batchItem = MapOfEventsBatchCopier.copyFromBuilder(batchItem);
        }

        public EventsRequest build() {
            return new EventsRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, EventsRequest> {
        public Builder batchItem(Map<String, EventsBatch> var1);
    }
}

