/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.pinpoint.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.pinpoint.model.EndpointTypesElement;
import software.amazon.awssdk.services.pinpoint.model.ListOf__EndpointTypesElementCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CustomDeliveryConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, CustomDeliveryConfiguration> {
    private static final SdkField<String> DELIVERY_URI_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CustomDeliveryConfiguration.getter(CustomDeliveryConfiguration::deliveryUri)).setter(CustomDeliveryConfiguration.setter(Builder::deliveryUri)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeliveryUri").build()}).build();
    private static final SdkField<List<String>> ENDPOINT_TYPES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(CustomDeliveryConfiguration.getter(CustomDeliveryConfiguration::endpointTypesAsStrings)).setter(CustomDeliveryConfiguration.setter(Builder::endpointTypesWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndpointTypes").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DELIVERY_URI_FIELD, ENDPOINT_TYPES_FIELD));
    private static final long serialVersionUID = 1L;
    private final String deliveryUri;
    private final List<String> endpointTypes;

    private CustomDeliveryConfiguration(BuilderImpl builder) {
        this.deliveryUri = builder.deliveryUri;
        this.endpointTypes = builder.endpointTypes;
    }

    public String deliveryUri() {
        return this.deliveryUri;
    }

    public List<EndpointTypesElement> endpointTypes() {
        return ListOf__EndpointTypesElementCopier.copyStringToEnum(this.endpointTypes);
    }

    public boolean hasEndpointTypes() {
        return this.endpointTypes != null && !(this.endpointTypes instanceof SdkAutoConstructList);
    }

    public List<String> endpointTypesAsStrings() {
        return this.endpointTypes;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.deliveryUri());
        hashCode = 31 * hashCode + Objects.hashCode(this.endpointTypesAsStrings());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CustomDeliveryConfiguration)) {
            return false;
        }
        CustomDeliveryConfiguration other = (CustomDeliveryConfiguration)obj;
        return Objects.equals(this.deliveryUri(), other.deliveryUri()) && Objects.equals(this.endpointTypesAsStrings(), other.endpointTypesAsStrings());
    }

    public String toString() {
        return ToString.builder((String)"CustomDeliveryConfiguration").add("DeliveryUri", (Object)this.deliveryUri()).add("EndpointTypes", this.endpointTypesAsStrings()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DeliveryUri": {
                return Optional.ofNullable(clazz.cast(this.deliveryUri()));
            }
            case "EndpointTypes": {
                return Optional.ofNullable(clazz.cast(this.endpointTypesAsStrings()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CustomDeliveryConfiguration, T> g) {
        return obj -> g.apply((CustomDeliveryConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String deliveryUri;
        private List<String> endpointTypes = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CustomDeliveryConfiguration model) {
            this.deliveryUri(model.deliveryUri);
            this.endpointTypesWithStrings(model.endpointTypes);
        }

        public final String getDeliveryUri() {
            return this.deliveryUri;
        }

        @Override
        public final Builder deliveryUri(String deliveryUri) {
            this.deliveryUri = deliveryUri;
            return this;
        }

        public final void setDeliveryUri(String deliveryUri) {
            this.deliveryUri = deliveryUri;
        }

        public final Collection<String> getEndpointTypesAsStrings() {
            return this.endpointTypes;
        }

        @Override
        public final Builder endpointTypesWithStrings(Collection<String> endpointTypes) {
            this.endpointTypes = ListOf__EndpointTypesElementCopier.copy(endpointTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder endpointTypesWithStrings(String ... endpointTypes) {
            this.endpointTypesWithStrings(Arrays.asList(endpointTypes));
            return this;
        }

        @Override
        public final Builder endpointTypes(Collection<EndpointTypesElement> endpointTypes) {
            this.endpointTypes = ListOf__EndpointTypesElementCopier.copyEnumToString(endpointTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder endpointTypes(EndpointTypesElement ... endpointTypes) {
            this.endpointTypes(Arrays.asList(endpointTypes));
            return this;
        }

        public final void setEndpointTypesWithStrings(Collection<String> endpointTypes) {
            this.endpointTypes = ListOf__EndpointTypesElementCopier.copy(endpointTypes);
        }

        public CustomDeliveryConfiguration build() {
            return new CustomDeliveryConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, CustomDeliveryConfiguration> {
        public Builder deliveryUri(String var1);

        public Builder endpointTypesWithStrings(Collection<String> var1);

        public Builder endpointTypesWithStrings(String ... var1);

        public Builder endpointTypes(Collection<EndpointTypesElement> var1);

        public Builder endpointTypes(EndpointTypesElement ... var1);
    }
}

