/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.pi.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.pi.model.FeatureMetadata;
import software.amazon.awssdk.services.pi.model.FeatureMetadataMapCopier;
import software.amazon.awssdk.services.pi.model.PiResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetResourceMetadataResponse
extends PiResponse
implements ToCopyableBuilder<Builder, GetResourceMetadataResponse> {
    private static final SdkField<String> IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Identifier").getter(GetResourceMetadataResponse.getter(GetResourceMetadataResponse::identifier)).setter(GetResourceMetadataResponse.setter(Builder::identifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Identifier").build()}).build();
    private static final SdkField<Map<String, FeatureMetadata>> FEATURES_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("Features").getter(GetResourceMetadataResponse.getter(GetResourceMetadataResponse::features)).setter(GetResourceMetadataResponse.setter(Builder::features)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Features").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(FeatureMetadata::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(IDENTIFIER_FIELD, FEATURES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("Identifier", IDENTIFIER_FIELD);
            this.put("Features", FEATURES_FIELD);
        }
    });
    private final String identifier;
    private final Map<String, FeatureMetadata> features;

    private GetResourceMetadataResponse(BuilderImpl builder) {
        super(builder);
        this.identifier = builder.identifier;
        this.features = builder.features;
    }

    public final String identifier() {
        return this.identifier;
    }

    public final boolean hasFeatures() {
        return this.features != null && !(this.features instanceof SdkAutoConstructMap);
    }

    public final Map<String, FeatureMetadata> features() {
        return this.features;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.identifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasFeatures() ? this.features() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetResourceMetadataResponse)) {
            return false;
        }
        GetResourceMetadataResponse other = (GetResourceMetadataResponse)((Object)obj);
        return Objects.equals(this.identifier(), other.identifier()) && this.hasFeatures() == other.hasFeatures() && Objects.equals(this.features(), other.features());
    }

    public final String toString() {
        return ToString.builder((String)"GetResourceMetadataResponse").add("Identifier", (Object)this.identifier()).add("Features", this.hasFeatures() ? this.features() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Identifier": {
                return Optional.ofNullable(clazz.cast(this.identifier()));
            }
            case "Features": {
                return Optional.ofNullable(clazz.cast(this.features()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<GetResourceMetadataResponse, T> g) {
        return obj -> g.apply((GetResourceMetadataResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends PiResponse.BuilderImpl
    implements Builder {
        private String identifier;
        private Map<String, FeatureMetadata> features = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GetResourceMetadataResponse model) {
            super(model);
            this.identifier(model.identifier);
            this.features(model.features);
        }

        public final String getIdentifier() {
            return this.identifier;
        }

        public final void setIdentifier(String identifier) {
            this.identifier = identifier;
        }

        @Override
        public final Builder identifier(String identifier) {
            this.identifier = identifier;
            return this;
        }

        public final Map<String, FeatureMetadata.Builder> getFeatures() {
            Map<String, FeatureMetadata.Builder> result = FeatureMetadataMapCopier.copyToBuilder(this.features);
            if (result instanceof SdkAutoConstructMap) {
                return null;
            }
            return result;
        }

        public final void setFeatures(Map<String, FeatureMetadata.BuilderImpl> features) {
            this.features = FeatureMetadataMapCopier.copyFromBuilder(features);
        }

        @Override
        public final Builder features(Map<String, FeatureMetadata> features) {
            this.features = FeatureMetadataMapCopier.copy(features);
            return this;
        }

        @Override
        public GetResourceMetadataResponse build() {
            return new GetResourceMetadataResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends PiResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetResourceMetadataResponse> {
        public Builder identifier(String var1);

        public Builder features(Map<String, FeatureMetadata> var1);
    }
}

