/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.pi.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.pi.PiAsyncClient;
import software.amazon.awssdk.services.pi.model.ListAvailableResourceDimensionsRequest;
import software.amazon.awssdk.services.pi.model.ListAvailableResourceDimensionsResponse;

public class ListAvailableResourceDimensionsPublisher
implements SdkPublisher<ListAvailableResourceDimensionsResponse> {
    private final PiAsyncClient client;
    private final ListAvailableResourceDimensionsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListAvailableResourceDimensionsPublisher(PiAsyncClient client, ListAvailableResourceDimensionsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListAvailableResourceDimensionsPublisher(PiAsyncClient client, ListAvailableResourceDimensionsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListAvailableResourceDimensionsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListAvailableResourceDimensionsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    private class ListAvailableResourceDimensionsResponseFetcher
    implements AsyncPageFetcher<ListAvailableResourceDimensionsResponse> {
        private ListAvailableResourceDimensionsResponseFetcher() {
        }

        public boolean hasNextPage(ListAvailableResourceDimensionsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListAvailableResourceDimensionsResponse> nextPage(ListAvailableResourceDimensionsResponse previousPage) {
            if (previousPage == null) {
                return ListAvailableResourceDimensionsPublisher.this.client.listAvailableResourceDimensions(ListAvailableResourceDimensionsPublisher.this.firstRequest);
            }
            return ListAvailableResourceDimensionsPublisher.this.client.listAvailableResourceDimensions((ListAvailableResourceDimensionsRequest)((Object)ListAvailableResourceDimensionsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

