/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.pi.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.pi.model.PiResponse;
import software.amazon.awssdk.services.pi.model.ResponseResourceMetric;
import software.amazon.awssdk.services.pi.model.ResponseResourceMetricListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListAvailableResourceMetricsResponse
extends PiResponse
implements ToCopyableBuilder<Builder, ListAvailableResourceMetricsResponse> {
    private static final SdkField<List<ResponseResourceMetric>> METRICS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Metrics").getter(ListAvailableResourceMetricsResponse.getter(ListAvailableResourceMetricsResponse::metrics)).setter(ListAvailableResourceMetricsResponse.setter(Builder::metrics)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Metrics").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ResponseResourceMetric::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListAvailableResourceMetricsResponse.getter(ListAvailableResourceMetricsResponse::nextToken)).setter(ListAvailableResourceMetricsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(METRICS_FIELD, NEXT_TOKEN_FIELD));
    private final List<ResponseResourceMetric> metrics;
    private final String nextToken;

    private ListAvailableResourceMetricsResponse(BuilderImpl builder) {
        super(builder);
        this.metrics = builder.metrics;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasMetrics() {
        return this.metrics != null && !(this.metrics instanceof SdkAutoConstructList);
    }

    public final List<ResponseResourceMetric> metrics() {
        return this.metrics;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasMetrics() ? this.metrics() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListAvailableResourceMetricsResponse)) {
            return false;
        }
        ListAvailableResourceMetricsResponse other = (ListAvailableResourceMetricsResponse)((Object)obj);
        return this.hasMetrics() == other.hasMetrics() && Objects.equals(this.metrics(), other.metrics()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListAvailableResourceMetricsResponse").add("Metrics", this.hasMetrics() ? this.metrics() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Metrics": {
                return Optional.ofNullable(clazz.cast(this.metrics()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListAvailableResourceMetricsResponse, T> g) {
        return obj -> g.apply((ListAvailableResourceMetricsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends PiResponse.BuilderImpl
    implements Builder {
        private List<ResponseResourceMetric> metrics = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListAvailableResourceMetricsResponse model) {
            super(model);
            this.metrics(model.metrics);
            this.nextToken(model.nextToken);
        }

        public final List<ResponseResourceMetric.Builder> getMetrics() {
            List<ResponseResourceMetric.Builder> result = ResponseResourceMetricListCopier.copyToBuilder(this.metrics);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setMetrics(Collection<ResponseResourceMetric.BuilderImpl> metrics) {
            this.metrics = ResponseResourceMetricListCopier.copyFromBuilder(metrics);
        }

        @Override
        public final Builder metrics(Collection<ResponseResourceMetric> metrics) {
            this.metrics = ResponseResourceMetricListCopier.copy(metrics);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder metrics(ResponseResourceMetric ... metrics) {
            this.metrics(Arrays.asList(metrics));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder metrics(Consumer<ResponseResourceMetric.Builder> ... metrics) {
            this.metrics(Stream.of(metrics).map(c -> (ResponseResourceMetric)((ResponseResourceMetric.Builder)ResponseResourceMetric.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListAvailableResourceMetricsResponse build() {
            return new ListAvailableResourceMetricsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends PiResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListAvailableResourceMetricsResponse> {
        public Builder metrics(Collection<ResponseResourceMetric> var1);

        public Builder metrics(ResponseResourceMetric ... var1);

        public Builder metrics(Consumer<ResponseResourceMetric.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

