/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.personalizeruntime.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.personalizeruntime.model.ItemListCopier;
import software.amazon.awssdk.services.personalizeruntime.model.PersonalizeRuntimeResponse;
import software.amazon.awssdk.services.personalizeruntime.model.PredictedItem;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetPersonalizedRankingResponse
extends PersonalizeRuntimeResponse
implements ToCopyableBuilder<Builder, GetPersonalizedRankingResponse> {
    private static final SdkField<List<PredictedItem>> PERSONALIZED_RANKING_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(GetPersonalizedRankingResponse.getter(GetPersonalizedRankingResponse::personalizedRanking)).setter(GetPersonalizedRankingResponse.setter(Builder::personalizedRanking)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("personalizedRanking").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(PredictedItem::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PERSONALIZED_RANKING_FIELD));
    private final List<PredictedItem> personalizedRanking;

    private GetPersonalizedRankingResponse(BuilderImpl builder) {
        super(builder);
        this.personalizedRanking = builder.personalizedRanking;
    }

    public List<PredictedItem> personalizedRanking() {
        return this.personalizedRanking;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.personalizedRanking());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetPersonalizedRankingResponse)) {
            return false;
        }
        GetPersonalizedRankingResponse other = (GetPersonalizedRankingResponse)((Object)obj);
        return Objects.equals(this.personalizedRanking(), other.personalizedRanking());
    }

    public String toString() {
        return ToString.builder((String)"GetPersonalizedRankingResponse").add("PersonalizedRanking", this.personalizedRanking()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "personalizedRanking": {
                return Optional.ofNullable(clazz.cast(this.personalizedRanking()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetPersonalizedRankingResponse, T> g) {
        return obj -> g.apply((GetPersonalizedRankingResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends PersonalizeRuntimeResponse.BuilderImpl
    implements Builder {
        private List<PredictedItem> personalizedRanking = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GetPersonalizedRankingResponse model) {
            super(model);
            this.personalizedRanking(model.personalizedRanking);
        }

        public final Collection<PredictedItem.Builder> getPersonalizedRanking() {
            return this.personalizedRanking != null ? (Collection)this.personalizedRanking.stream().map(PredictedItem::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder personalizedRanking(Collection<PredictedItem> personalizedRanking) {
            this.personalizedRanking = ItemListCopier.copy(personalizedRanking);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder personalizedRanking(PredictedItem ... personalizedRanking) {
            this.personalizedRanking(Arrays.asList(personalizedRanking));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder personalizedRanking(Consumer<PredictedItem.Builder> ... personalizedRanking) {
            this.personalizedRanking(Stream.of(personalizedRanking).map(c -> (PredictedItem)((PredictedItem.Builder)PredictedItem.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setPersonalizedRanking(Collection<PredictedItem.BuilderImpl> personalizedRanking) {
            this.personalizedRanking = ItemListCopier.copyFromBuilder(personalizedRanking);
        }

        @Override
        public GetPersonalizedRankingResponse build() {
            return new GetPersonalizedRankingResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends PersonalizeRuntimeResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetPersonalizedRankingResponse> {
        public Builder personalizedRanking(Collection<PredictedItem> var1);

        public Builder personalizedRanking(PredictedItem ... var1);

        public Builder personalizedRanking(Consumer<PredictedItem.Builder> ... var1);
    }
}

