/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.personalizeruntime.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.personalizeruntime.model.MetadataCopier;
import software.amazon.awssdk.services.personalizeruntime.model.ReasonListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class PredictedItem
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, PredictedItem> {
    private static final SdkField<String> ITEM_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("itemId").getter(PredictedItem.getter(PredictedItem::itemId)).setter(PredictedItem.setter(Builder::itemId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("itemId").build()}).build();
    private static final SdkField<Double> SCORE_FIELD = SdkField.builder((MarshallingType)MarshallingType.DOUBLE).memberName("score").getter(PredictedItem.getter(PredictedItem::score)).setter(PredictedItem.setter(Builder::score)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("score").build()}).build();
    private static final SdkField<String> PROMOTION_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("promotionName").getter(PredictedItem.getter(PredictedItem::promotionName)).setter(PredictedItem.setter(Builder::promotionName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("promotionName").build()}).build();
    private static final SdkField<Map<String, String>> METADATA_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("metadata").getter(PredictedItem.getter(PredictedItem::metadata)).setter(PredictedItem.setter(Builder::metadata)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("metadata").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<List<String>> REASON_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("reason").getter(PredictedItem.getter(PredictedItem::reason)).setter(PredictedItem.setter(Builder::reason)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("reason").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ITEM_ID_FIELD, SCORE_FIELD, PROMOTION_NAME_FIELD, METADATA_FIELD, REASON_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = PredictedItem.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String itemId;
    private final Double score;
    private final String promotionName;
    private final Map<String, String> metadata;
    private final List<String> reason;

    private PredictedItem(BuilderImpl builder) {
        this.itemId = builder.itemId;
        this.score = builder.score;
        this.promotionName = builder.promotionName;
        this.metadata = builder.metadata;
        this.reason = builder.reason;
    }

    public final String itemId() {
        return this.itemId;
    }

    public final Double score() {
        return this.score;
    }

    public final String promotionName() {
        return this.promotionName;
    }

    public final boolean hasMetadata() {
        return this.metadata != null && !(this.metadata instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> metadata() {
        return this.metadata;
    }

    public final boolean hasReason() {
        return this.reason != null && !(this.reason instanceof SdkAutoConstructList);
    }

    public final List<String> reason() {
        return this.reason;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.itemId());
        hashCode = 31 * hashCode + Objects.hashCode(this.score());
        hashCode = 31 * hashCode + Objects.hashCode(this.promotionName());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasMetadata() ? this.metadata() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasReason() ? this.reason() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PredictedItem)) {
            return false;
        }
        PredictedItem other = (PredictedItem)obj;
        return Objects.equals(this.itemId(), other.itemId()) && Objects.equals(this.score(), other.score()) && Objects.equals(this.promotionName(), other.promotionName()) && this.hasMetadata() == other.hasMetadata() && Objects.equals(this.metadata(), other.metadata()) && this.hasReason() == other.hasReason() && Objects.equals(this.reason(), other.reason());
    }

    public final String toString() {
        return ToString.builder((String)"PredictedItem").add("ItemId", (Object)this.itemId()).add("Score", (Object)this.score()).add("PromotionName", (Object)this.promotionName()).add("Metadata", (Object)(this.metadata() == null ? null : "*** Sensitive Data Redacted ***")).add("Reason", this.hasReason() ? this.reason() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "itemId": {
                return Optional.ofNullable(clazz.cast(this.itemId()));
            }
            case "score": {
                return Optional.ofNullable(clazz.cast(this.score()));
            }
            case "promotionName": {
                return Optional.ofNullable(clazz.cast(this.promotionName()));
            }
            case "metadata": {
                return Optional.ofNullable(clazz.cast(this.metadata()));
            }
            case "reason": {
                return Optional.ofNullable(clazz.cast(this.reason()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("itemId", ITEM_ID_FIELD);
        map.put("score", SCORE_FIELD);
        map.put("promotionName", PROMOTION_NAME_FIELD);
        map.put("metadata", METADATA_FIELD);
        map.put("reason", REASON_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<PredictedItem, T> g) {
        return obj -> g.apply((PredictedItem)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String itemId;
        private Double score;
        private String promotionName;
        private Map<String, String> metadata = DefaultSdkAutoConstructMap.getInstance();
        private List<String> reason = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(PredictedItem model) {
            this.itemId(model.itemId);
            this.score(model.score);
            this.promotionName(model.promotionName);
            this.metadata(model.metadata);
            this.reason(model.reason);
        }

        public final String getItemId() {
            return this.itemId;
        }

        public final void setItemId(String itemId) {
            this.itemId = itemId;
        }

        @Override
        public final Builder itemId(String itemId) {
            this.itemId = itemId;
            return this;
        }

        public final Double getScore() {
            return this.score;
        }

        public final void setScore(Double score) {
            this.score = score;
        }

        @Override
        public final Builder score(Double score) {
            this.score = score;
            return this;
        }

        public final String getPromotionName() {
            return this.promotionName;
        }

        public final void setPromotionName(String promotionName) {
            this.promotionName = promotionName;
        }

        @Override
        public final Builder promotionName(String promotionName) {
            this.promotionName = promotionName;
            return this;
        }

        public final Map<String, String> getMetadata() {
            if (this.metadata instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.metadata;
        }

        public final void setMetadata(Map<String, String> metadata) {
            this.metadata = MetadataCopier.copy(metadata);
        }

        @Override
        public final Builder metadata(Map<String, String> metadata) {
            this.metadata = MetadataCopier.copy(metadata);
            return this;
        }

        public final Collection<String> getReason() {
            if (this.reason instanceof SdkAutoConstructList) {
                return null;
            }
            return this.reason;
        }

        public final void setReason(Collection<String> reason) {
            this.reason = ReasonListCopier.copy(reason);
        }

        @Override
        public final Builder reason(Collection<String> reason) {
            this.reason = ReasonListCopier.copy(reason);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder reason(String ... reason) {
            this.reason(Arrays.asList(reason));
            return this;
        }

        public PredictedItem build() {
            return new PredictedItem(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, PredictedItem> {
        public Builder itemId(String var1);

        public Builder score(Double var1);

        public Builder promotionName(String var1);

        public Builder metadata(Map<String, String> var1);

        public Builder reason(Collection<String> var1);

        public Builder reason(String ... var1);
    }
}

