/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.personalizeruntime.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.personalizeruntime.model.FilterValuesCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Promotion
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Promotion> {
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("name").getter(Promotion.getter(Promotion::name)).setter(Promotion.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<Integer> PERCENT_PROMOTED_ITEMS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("percentPromotedItems").getter(Promotion.getter(Promotion::percentPromotedItems)).setter(Promotion.setter(Builder::percentPromotedItems)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("percentPromotedItems").build()}).build();
    private static final SdkField<String> FILTER_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("filterArn").getter(Promotion.getter(Promotion::filterArn)).setter(Promotion.setter(Builder::filterArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("filterArn").build()}).build();
    private static final SdkField<Map<String, String>> FILTER_VALUES_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("filterValues").getter(Promotion.getter(Promotion::filterValues)).setter(Promotion.setter(Builder::filterValues)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("filterValues").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, PERCENT_PROMOTED_ITEMS_FIELD, FILTER_ARN_FIELD, FILTER_VALUES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("name", NAME_FIELD);
            this.put("percentPromotedItems", PERCENT_PROMOTED_ITEMS_FIELD);
            this.put("filterArn", FILTER_ARN_FIELD);
            this.put("filterValues", FILTER_VALUES_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String name;
    private final Integer percentPromotedItems;
    private final String filterArn;
    private final Map<String, String> filterValues;

    private Promotion(BuilderImpl builder) {
        this.name = builder.name;
        this.percentPromotedItems = builder.percentPromotedItems;
        this.filterArn = builder.filterArn;
        this.filterValues = builder.filterValues;
    }

    public final String name() {
        return this.name;
    }

    public final Integer percentPromotedItems() {
        return this.percentPromotedItems;
    }

    public final String filterArn() {
        return this.filterArn;
    }

    public final boolean hasFilterValues() {
        return this.filterValues != null && !(this.filterValues instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> filterValues() {
        return this.filterValues;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.percentPromotedItems());
        hashCode = 31 * hashCode + Objects.hashCode(this.filterArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasFilterValues() ? this.filterValues() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Promotion)) {
            return false;
        }
        Promotion other = (Promotion)obj;
        return Objects.equals(this.name(), other.name()) && Objects.equals(this.percentPromotedItems(), other.percentPromotedItems()) && Objects.equals(this.filterArn(), other.filterArn()) && this.hasFilterValues() == other.hasFilterValues() && Objects.equals(this.filterValues(), other.filterValues());
    }

    public final String toString() {
        return ToString.builder((String)"Promotion").add("Name", (Object)this.name()).add("PercentPromotedItems", (Object)this.percentPromotedItems()).add("FilterArn", (Object)this.filterArn()).add("FilterValues", (Object)(this.filterValues() == null ? null : "*** Sensitive Data Redacted ***")).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "percentPromotedItems": {
                return Optional.ofNullable(clazz.cast(this.percentPromotedItems()));
            }
            case "filterArn": {
                return Optional.ofNullable(clazz.cast(this.filterArn()));
            }
            case "filterValues": {
                return Optional.ofNullable(clazz.cast(this.filterValues()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<Promotion, T> g) {
        return obj -> g.apply((Promotion)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String name;
        private Integer percentPromotedItems;
        private String filterArn;
        private Map<String, String> filterValues = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(Promotion model) {
            this.name(model.name);
            this.percentPromotedItems(model.percentPromotedItems);
            this.filterArn(model.filterArn);
            this.filterValues(model.filterValues);
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final Integer getPercentPromotedItems() {
            return this.percentPromotedItems;
        }

        public final void setPercentPromotedItems(Integer percentPromotedItems) {
            this.percentPromotedItems = percentPromotedItems;
        }

        @Override
        public final Builder percentPromotedItems(Integer percentPromotedItems) {
            this.percentPromotedItems = percentPromotedItems;
            return this;
        }

        public final String getFilterArn() {
            return this.filterArn;
        }

        public final void setFilterArn(String filterArn) {
            this.filterArn = filterArn;
        }

        @Override
        public final Builder filterArn(String filterArn) {
            this.filterArn = filterArn;
            return this;
        }

        public final Map<String, String> getFilterValues() {
            if (this.filterValues instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.filterValues;
        }

        public final void setFilterValues(Map<String, String> filterValues) {
            this.filterValues = FilterValuesCopier.copy(filterValues);
        }

        @Override
        public final Builder filterValues(Map<String, String> filterValues) {
            this.filterValues = FilterValuesCopier.copy(filterValues);
            return this;
        }

        public Promotion build() {
            return new Promotion(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Promotion> {
        public Builder name(String var1);

        public Builder percentPromotedItems(Integer var1);

        public Builder filterArn(String var1);

        public Builder filterValues(Map<String, String> var1);
    }
}

