/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.personalizeruntime.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.personalizeruntime.model.ItemListCopier;
import software.amazon.awssdk.services.personalizeruntime.model.PersonalizeRuntimeResponse;
import software.amazon.awssdk.services.personalizeruntime.model.PredictedItem;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetRecommendationsResponse
extends PersonalizeRuntimeResponse
implements ToCopyableBuilder<Builder, GetRecommendationsResponse> {
    private static final SdkField<List<PredictedItem>> ITEM_LIST_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("itemList").getter(GetRecommendationsResponse.getter(GetRecommendationsResponse::itemList)).setter(GetRecommendationsResponse.setter(Builder::itemList)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("itemList").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(PredictedItem::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> RECOMMENDATION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("recommendationId").getter(GetRecommendationsResponse.getter(GetRecommendationsResponse::recommendationId)).setter(GetRecommendationsResponse.setter(Builder::recommendationId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("recommendationId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ITEM_LIST_FIELD, RECOMMENDATION_ID_FIELD));
    private final List<PredictedItem> itemList;
    private final String recommendationId;

    private GetRecommendationsResponse(BuilderImpl builder) {
        super(builder);
        this.itemList = builder.itemList;
        this.recommendationId = builder.recommendationId;
    }

    public final boolean hasItemList() {
        return this.itemList != null && !(this.itemList instanceof SdkAutoConstructList);
    }

    public final List<PredictedItem> itemList() {
        return this.itemList;
    }

    public final String recommendationId() {
        return this.recommendationId;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasItemList() ? this.itemList() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.recommendationId());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetRecommendationsResponse)) {
            return false;
        }
        GetRecommendationsResponse other = (GetRecommendationsResponse)((Object)obj);
        return this.hasItemList() == other.hasItemList() && Objects.equals(this.itemList(), other.itemList()) && Objects.equals(this.recommendationId(), other.recommendationId());
    }

    public final String toString() {
        return ToString.builder((String)"GetRecommendationsResponse").add("ItemList", this.hasItemList() ? this.itemList() : null).add("RecommendationId", (Object)this.recommendationId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "itemList": {
                return Optional.ofNullable(clazz.cast(this.itemList()));
            }
            case "recommendationId": {
                return Optional.ofNullable(clazz.cast(this.recommendationId()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetRecommendationsResponse, T> g) {
        return obj -> g.apply((GetRecommendationsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends PersonalizeRuntimeResponse.BuilderImpl
    implements Builder {
        private List<PredictedItem> itemList = DefaultSdkAutoConstructList.getInstance();
        private String recommendationId;

        private BuilderImpl() {
        }

        private BuilderImpl(GetRecommendationsResponse model) {
            super(model);
            this.itemList(model.itemList);
            this.recommendationId(model.recommendationId);
        }

        public final List<PredictedItem.Builder> getItemList() {
            List<PredictedItem.Builder> result = ItemListCopier.copyToBuilder(this.itemList);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setItemList(Collection<PredictedItem.BuilderImpl> itemList) {
            this.itemList = ItemListCopier.copyFromBuilder(itemList);
        }

        @Override
        public final Builder itemList(Collection<PredictedItem> itemList) {
            this.itemList = ItemListCopier.copy(itemList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder itemList(PredictedItem ... itemList) {
            this.itemList(Arrays.asList(itemList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder itemList(Consumer<PredictedItem.Builder> ... itemList) {
            this.itemList(Stream.of(itemList).map(c -> (PredictedItem)((PredictedItem.Builder)PredictedItem.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getRecommendationId() {
            return this.recommendationId;
        }

        public final void setRecommendationId(String recommendationId) {
            this.recommendationId = recommendationId;
        }

        @Override
        public final Builder recommendationId(String recommendationId) {
            this.recommendationId = recommendationId;
            return this;
        }

        @Override
        public GetRecommendationsResponse build() {
            return new GetRecommendationsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends PersonalizeRuntimeResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetRecommendationsResponse> {
        public Builder itemList(Collection<PredictedItem> var1);

        public Builder itemList(PredictedItem ... var1);

        public Builder itemList(Consumer<PredictedItem.Builder> ... var1);

        public Builder recommendationId(String var1);
    }
}

