/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.personalize.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.services.personalize.model.AutoMLConfig;
import software.amazon.awssdk.services.personalize.model.FeatureTransformationParametersCopier;
import software.amazon.awssdk.services.personalize.model.HPOConfig;
import software.amazon.awssdk.services.personalize.model.HyperParametersCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SolutionConfig
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, SolutionConfig> {
    private static final SdkField<String> EVENT_VALUE_THRESHOLD_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(SolutionConfig.getter(SolutionConfig::eventValueThreshold)).setter(SolutionConfig.setter(Builder::eventValueThreshold)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("eventValueThreshold").build()}).build();
    private static final SdkField<HPOConfig> HPO_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(SolutionConfig.getter(SolutionConfig::hpoConfig)).setter(SolutionConfig.setter(Builder::hpoConfig)).constructor(HPOConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("hpoConfig").build()}).build();
    private static final SdkField<Map<String, String>> ALGORITHM_HYPER_PARAMETERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).getter(SolutionConfig.getter(SolutionConfig::algorithmHyperParameters)).setter(SolutionConfig.setter(Builder::algorithmHyperParameters)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("algorithmHyperParameters").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<Map<String, String>> FEATURE_TRANSFORMATION_PARAMETERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).getter(SolutionConfig.getter(SolutionConfig::featureTransformationParameters)).setter(SolutionConfig.setter(Builder::featureTransformationParameters)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("featureTransformationParameters").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<AutoMLConfig> AUTO_ML_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(SolutionConfig.getter(SolutionConfig::autoMLConfig)).setter(SolutionConfig.setter(Builder::autoMLConfig)).constructor(AutoMLConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("autoMLConfig").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EVENT_VALUE_THRESHOLD_FIELD, HPO_CONFIG_FIELD, ALGORITHM_HYPER_PARAMETERS_FIELD, FEATURE_TRANSFORMATION_PARAMETERS_FIELD, AUTO_ML_CONFIG_FIELD));
    private static final long serialVersionUID = 1L;
    private final String eventValueThreshold;
    private final HPOConfig hpoConfig;
    private final Map<String, String> algorithmHyperParameters;
    private final Map<String, String> featureTransformationParameters;
    private final AutoMLConfig autoMLConfig;

    private SolutionConfig(BuilderImpl builder) {
        this.eventValueThreshold = builder.eventValueThreshold;
        this.hpoConfig = builder.hpoConfig;
        this.algorithmHyperParameters = builder.algorithmHyperParameters;
        this.featureTransformationParameters = builder.featureTransformationParameters;
        this.autoMLConfig = builder.autoMLConfig;
    }

    public String eventValueThreshold() {
        return this.eventValueThreshold;
    }

    public HPOConfig hpoConfig() {
        return this.hpoConfig;
    }

    public Map<String, String> algorithmHyperParameters() {
        return this.algorithmHyperParameters;
    }

    public Map<String, String> featureTransformationParameters() {
        return this.featureTransformationParameters;
    }

    public AutoMLConfig autoMLConfig() {
        return this.autoMLConfig;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.eventValueThreshold());
        hashCode = 31 * hashCode + Objects.hashCode(this.hpoConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.algorithmHyperParameters());
        hashCode = 31 * hashCode + Objects.hashCode(this.featureTransformationParameters());
        hashCode = 31 * hashCode + Objects.hashCode(this.autoMLConfig());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SolutionConfig)) {
            return false;
        }
        SolutionConfig other = (SolutionConfig)obj;
        return Objects.equals(this.eventValueThreshold(), other.eventValueThreshold()) && Objects.equals(this.hpoConfig(), other.hpoConfig()) && Objects.equals(this.algorithmHyperParameters(), other.algorithmHyperParameters()) && Objects.equals(this.featureTransformationParameters(), other.featureTransformationParameters()) && Objects.equals(this.autoMLConfig(), other.autoMLConfig());
    }

    public String toString() {
        return ToString.builder((String)"SolutionConfig").add("EventValueThreshold", (Object)this.eventValueThreshold()).add("HpoConfig", (Object)this.hpoConfig()).add("AlgorithmHyperParameters", this.algorithmHyperParameters()).add("FeatureTransformationParameters", this.featureTransformationParameters()).add("AutoMLConfig", (Object)this.autoMLConfig()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "eventValueThreshold": {
                return Optional.ofNullable(clazz.cast(this.eventValueThreshold()));
            }
            case "hpoConfig": {
                return Optional.ofNullable(clazz.cast(this.hpoConfig()));
            }
            case "algorithmHyperParameters": {
                return Optional.ofNullable(clazz.cast(this.algorithmHyperParameters()));
            }
            case "featureTransformationParameters": {
                return Optional.ofNullable(clazz.cast(this.featureTransformationParameters()));
            }
            case "autoMLConfig": {
                return Optional.ofNullable(clazz.cast(this.autoMLConfig()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SolutionConfig, T> g) {
        return obj -> g.apply((SolutionConfig)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String eventValueThreshold;
        private HPOConfig hpoConfig;
        private Map<String, String> algorithmHyperParameters = DefaultSdkAutoConstructMap.getInstance();
        private Map<String, String> featureTransformationParameters = DefaultSdkAutoConstructMap.getInstance();
        private AutoMLConfig autoMLConfig;

        private BuilderImpl() {
        }

        private BuilderImpl(SolutionConfig model) {
            this.eventValueThreshold(model.eventValueThreshold);
            this.hpoConfig(model.hpoConfig);
            this.algorithmHyperParameters(model.algorithmHyperParameters);
            this.featureTransformationParameters(model.featureTransformationParameters);
            this.autoMLConfig(model.autoMLConfig);
        }

        public final String getEventValueThreshold() {
            return this.eventValueThreshold;
        }

        @Override
        public final Builder eventValueThreshold(String eventValueThreshold) {
            this.eventValueThreshold = eventValueThreshold;
            return this;
        }

        public final void setEventValueThreshold(String eventValueThreshold) {
            this.eventValueThreshold = eventValueThreshold;
        }

        public final HPOConfig.Builder getHpoConfig() {
            return this.hpoConfig != null ? this.hpoConfig.toBuilder() : null;
        }

        @Override
        public final Builder hpoConfig(HPOConfig hpoConfig) {
            this.hpoConfig = hpoConfig;
            return this;
        }

        public final void setHpoConfig(HPOConfig.BuilderImpl hpoConfig) {
            this.hpoConfig = hpoConfig != null ? hpoConfig.build() : null;
        }

        public final Map<String, String> getAlgorithmHyperParameters() {
            return this.algorithmHyperParameters;
        }

        @Override
        public final Builder algorithmHyperParameters(Map<String, String> algorithmHyperParameters) {
            this.algorithmHyperParameters = HyperParametersCopier.copy(algorithmHyperParameters);
            return this;
        }

        public final void setAlgorithmHyperParameters(Map<String, String> algorithmHyperParameters) {
            this.algorithmHyperParameters = HyperParametersCopier.copy(algorithmHyperParameters);
        }

        public final Map<String, String> getFeatureTransformationParameters() {
            return this.featureTransformationParameters;
        }

        @Override
        public final Builder featureTransformationParameters(Map<String, String> featureTransformationParameters) {
            this.featureTransformationParameters = FeatureTransformationParametersCopier.copy(featureTransformationParameters);
            return this;
        }

        public final void setFeatureTransformationParameters(Map<String, String> featureTransformationParameters) {
            this.featureTransformationParameters = FeatureTransformationParametersCopier.copy(featureTransformationParameters);
        }

        public final AutoMLConfig.Builder getAutoMLConfig() {
            return this.autoMLConfig != null ? this.autoMLConfig.toBuilder() : null;
        }

        @Override
        public final Builder autoMLConfig(AutoMLConfig autoMLConfig) {
            this.autoMLConfig = autoMLConfig;
            return this;
        }

        public final void setAutoMLConfig(AutoMLConfig.BuilderImpl autoMLConfig) {
            this.autoMLConfig = autoMLConfig != null ? autoMLConfig.build() : null;
        }

        public SolutionConfig build() {
            return new SolutionConfig(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, SolutionConfig> {
        public Builder eventValueThreshold(String var1);

        public Builder hpoConfig(HPOConfig var1);

        default public Builder hpoConfig(Consumer<HPOConfig.Builder> hpoConfig) {
            return this.hpoConfig((HPOConfig)((HPOConfig.Builder)HPOConfig.builder().applyMutation(hpoConfig)).build());
        }

        public Builder algorithmHyperParameters(Map<String, String> var1);

        public Builder featureTransformationParameters(Map<String, String> var1);

        public Builder autoMLConfig(AutoMLConfig var1);

        default public Builder autoMLConfig(Consumer<AutoMLConfig.Builder> autoMLConfig) {
            return this.autoMLConfig((AutoMLConfig)((AutoMLConfig.Builder)AutoMLConfig.builder().applyMutation(autoMLConfig)).build());
        }
    }
}

