/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.personalize.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.personalize.model.PersonalizeResponse;
import software.amazon.awssdk.services.personalize.model.Recipe;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeRecipeResponse
extends PersonalizeResponse
implements ToCopyableBuilder<Builder, DescribeRecipeResponse> {
    private static final SdkField<Recipe> RECIPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(DescribeRecipeResponse.getter(DescribeRecipeResponse::recipe)).setter(DescribeRecipeResponse.setter(Builder::recipe)).constructor(Recipe::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("recipe").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RECIPE_FIELD));
    private final Recipe recipe;

    private DescribeRecipeResponse(BuilderImpl builder) {
        super(builder);
        this.recipe = builder.recipe;
    }

    public Recipe recipe() {
        return this.recipe;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.recipe());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeRecipeResponse)) {
            return false;
        }
        DescribeRecipeResponse other = (DescribeRecipeResponse)((Object)obj);
        return Objects.equals(this.recipe(), other.recipe());
    }

    public String toString() {
        return ToString.builder((String)"DescribeRecipeResponse").add("Recipe", (Object)this.recipe()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "recipe": {
                return Optional.ofNullable(clazz.cast(this.recipe()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeRecipeResponse, T> g) {
        return obj -> g.apply((DescribeRecipeResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends PersonalizeResponse.BuilderImpl
    implements Builder {
        private Recipe recipe;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeRecipeResponse model) {
            super(model);
            this.recipe(model.recipe);
        }

        public final Recipe.Builder getRecipe() {
            return this.recipe != null ? this.recipe.toBuilder() : null;
        }

        @Override
        public final Builder recipe(Recipe recipe) {
            this.recipe = recipe;
            return this;
        }

        public final void setRecipe(Recipe.BuilderImpl recipe) {
            this.recipe = recipe != null ? recipe.build() : null;
        }

        @Override
        public DescribeRecipeResponse build() {
            return new DescribeRecipeResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends PersonalizeResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeRecipeResponse> {
        public Builder recipe(Recipe var1);

        default public Builder recipe(Consumer<Recipe.Builder> recipe) {
            return this.recipe((Recipe)((Recipe.Builder)Recipe.builder().applyMutation(recipe)).build());
        }
    }
}

