/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.personalize.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The metric to optimize during hyperparameter optimization (HPO).
 * </p>
 * <note>
 * <p>
 * Amazon Personalize doesn't support configuring the <code>hpoObjective</code> at this time.
 * </p>
 * </note>
 */
@Generated("software.amazon.awssdk:codegen")
public final class HPOObjective implements SdkPojo, Serializable, ToCopyableBuilder<HPOObjective.Builder, HPOObjective> {
    private static final SdkField<String> TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("type")
            .getter(getter(HPOObjective::type)).setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("type").build()).build();

    private static final SdkField<String> METRIC_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("metricName").getter(getter(HPOObjective::metricName)).setter(setter(Builder::metricName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("metricName").build()).build();

    private static final SdkField<String> METRIC_REGEX_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("metricRegex").getter(getter(HPOObjective::metricRegex)).setter(setter(Builder::metricRegex))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("metricRegex").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TYPE_FIELD, METRIC_NAME_FIELD,
            METRIC_REGEX_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String type;

    private final String metricName;

    private final String metricRegex;

    private HPOObjective(BuilderImpl builder) {
        this.type = builder.type;
        this.metricName = builder.metricName;
        this.metricRegex = builder.metricRegex;
    }

    /**
     * <p>
     * The type of the metric. Valid values are <code>Maximize</code> and <code>Minimize</code>.
     * </p>
     * 
     * @return The type of the metric. Valid values are <code>Maximize</code> and <code>Minimize</code>.
     */
    public final String type() {
        return type;
    }

    /**
     * <p>
     * The name of the metric.
     * </p>
     * 
     * @return The name of the metric.
     */
    public final String metricName() {
        return metricName;
    }

    /**
     * <p>
     * A regular expression for finding the metric in the training job logs.
     * </p>
     * 
     * @return A regular expression for finding the metric in the training job logs.
     */
    public final String metricRegex() {
        return metricRegex;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(type());
        hashCode = 31 * hashCode + Objects.hashCode(metricName());
        hashCode = 31 * hashCode + Objects.hashCode(metricRegex());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof HPOObjective)) {
            return false;
        }
        HPOObjective other = (HPOObjective) obj;
        return Objects.equals(type(), other.type()) && Objects.equals(metricName(), other.metricName())
                && Objects.equals(metricRegex(), other.metricRegex());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("HPOObjective").add("Type", type()).add("MetricName", metricName())
                .add("MetricRegex", metricRegex()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "type":
            return Optional.ofNullable(clazz.cast(type()));
        case "metricName":
            return Optional.ofNullable(clazz.cast(metricName()));
        case "metricRegex":
            return Optional.ofNullable(clazz.cast(metricRegex()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("type", TYPE_FIELD);
        map.put("metricName", METRIC_NAME_FIELD);
        map.put("metricRegex", METRIC_REGEX_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<HPOObjective, T> g) {
        return obj -> g.apply((HPOObjective) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, HPOObjective> {
        /**
         * <p>
         * The type of the metric. Valid values are <code>Maximize</code> and <code>Minimize</code>.
         * </p>
         * 
         * @param type
         *        The type of the metric. Valid values are <code>Maximize</code> and <code>Minimize</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder type(String type);

        /**
         * <p>
         * The name of the metric.
         * </p>
         * 
         * @param metricName
         *        The name of the metric.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder metricName(String metricName);

        /**
         * <p>
         * A regular expression for finding the metric in the training job logs.
         * </p>
         * 
         * @param metricRegex
         *        A regular expression for finding the metric in the training job logs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder metricRegex(String metricRegex);
    }

    static final class BuilderImpl implements Builder {
        private String type;

        private String metricName;

        private String metricRegex;

        private BuilderImpl() {
        }

        private BuilderImpl(HPOObjective model) {
            type(model.type);
            metricName(model.metricName);
            metricRegex(model.metricRegex);
        }

        public final String getType() {
            return type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        public final String getMetricName() {
            return metricName;
        }

        public final void setMetricName(String metricName) {
            this.metricName = metricName;
        }

        @Override
        public final Builder metricName(String metricName) {
            this.metricName = metricName;
            return this;
        }

        public final String getMetricRegex() {
            return metricRegex;
        }

        public final void setMetricRegex(String metricRegex) {
            this.metricRegex = metricRegex;
        }

        @Override
        public final Builder metricRegex(String metricRegex) {
            this.metricRegex = metricRegex;
            return this;
        }

        @Override
        public HPOObjective build() {
            return new HPOObjective(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
