/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.personalize.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes the parameters of events, which are used in solution creation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class EventParameters implements SdkPojo, Serializable, ToCopyableBuilder<EventParameters.Builder, EventParameters> {
    private static final SdkField<String> EVENT_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("eventType").getter(getter(EventParameters::eventType)).setter(setter(Builder::eventType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("eventType").build()).build();

    private static final SdkField<Double> EVENT_VALUE_THRESHOLD_FIELD = SdkField.<Double> builder(MarshallingType.DOUBLE)
            .memberName("eventValueThreshold").getter(getter(EventParameters::eventValueThreshold))
            .setter(setter(Builder::eventValueThreshold))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("eventValueThreshold").build())
            .build();

    private static final SdkField<Double> WEIGHT_FIELD = SdkField.<Double> builder(MarshallingType.DOUBLE).memberName("weight")
            .getter(getter(EventParameters::weight)).setter(setter(Builder::weight))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("weight").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EVENT_TYPE_FIELD,
            EVENT_VALUE_THRESHOLD_FIELD, WEIGHT_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String eventType;

    private final Double eventValueThreshold;

    private final Double weight;

    private EventParameters(BuilderImpl builder) {
        this.eventType = builder.eventType;
        this.eventValueThreshold = builder.eventValueThreshold;
        this.weight = builder.weight;
    }

    /**
     * <p>
     * The name of the event type to be considered for solution creation.
     * </p>
     * 
     * @return The name of the event type to be considered for solution creation.
     */
    public final String eventType() {
        return eventType;
    }

    /**
     * <p>
     * The threshold of the event type. Only events with a value greater or equal to this threshold will be considered
     * for solution creation.
     * </p>
     * 
     * @return The threshold of the event type. Only events with a value greater or equal to this threshold will be
     *         considered for solution creation.
     */
    public final Double eventValueThreshold() {
        return eventValueThreshold;
    }

    /**
     * <p>
     * The weight of the event type. A higher weight means higher importance of the event type for the created solution.
     * </p>
     * 
     * @return The weight of the event type. A higher weight means higher importance of the event type for the created
     *         solution.
     */
    public final Double weight() {
        return weight;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(eventType());
        hashCode = 31 * hashCode + Objects.hashCode(eventValueThreshold());
        hashCode = 31 * hashCode + Objects.hashCode(weight());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EventParameters)) {
            return false;
        }
        EventParameters other = (EventParameters) obj;
        return Objects.equals(eventType(), other.eventType())
                && Objects.equals(eventValueThreshold(), other.eventValueThreshold()) && Objects.equals(weight(), other.weight());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("EventParameters").add("EventType", eventType())
                .add("EventValueThreshold", eventValueThreshold()).add("Weight", weight()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "eventType":
            return Optional.ofNullable(clazz.cast(eventType()));
        case "eventValueThreshold":
            return Optional.ofNullable(clazz.cast(eventValueThreshold()));
        case "weight":
            return Optional.ofNullable(clazz.cast(weight()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("eventType", EVENT_TYPE_FIELD);
        map.put("eventValueThreshold", EVENT_VALUE_THRESHOLD_FIELD);
        map.put("weight", WEIGHT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<EventParameters, T> g) {
        return obj -> g.apply((EventParameters) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, EventParameters> {
        /**
         * <p>
         * The name of the event type to be considered for solution creation.
         * </p>
         * 
         * @param eventType
         *        The name of the event type to be considered for solution creation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder eventType(String eventType);

        /**
         * <p>
         * The threshold of the event type. Only events with a value greater or equal to this threshold will be
         * considered for solution creation.
         * </p>
         * 
         * @param eventValueThreshold
         *        The threshold of the event type. Only events with a value greater or equal to this threshold will be
         *        considered for solution creation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder eventValueThreshold(Double eventValueThreshold);

        /**
         * <p>
         * The weight of the event type. A higher weight means higher importance of the event type for the created
         * solution.
         * </p>
         * 
         * @param weight
         *        The weight of the event type. A higher weight means higher importance of the event type for the
         *        created solution.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder weight(Double weight);
    }

    static final class BuilderImpl implements Builder {
        private String eventType;

        private Double eventValueThreshold;

        private Double weight;

        private BuilderImpl() {
        }

        private BuilderImpl(EventParameters model) {
            eventType(model.eventType);
            eventValueThreshold(model.eventValueThreshold);
            weight(model.weight);
        }

        public final String getEventType() {
            return eventType;
        }

        public final void setEventType(String eventType) {
            this.eventType = eventType;
        }

        @Override
        public final Builder eventType(String eventType) {
            this.eventType = eventType;
            return this;
        }

        public final Double getEventValueThreshold() {
            return eventValueThreshold;
        }

        public final void setEventValueThreshold(Double eventValueThreshold) {
            this.eventValueThreshold = eventValueThreshold;
        }

        @Override
        public final Builder eventValueThreshold(Double eventValueThreshold) {
            this.eventValueThreshold = eventValueThreshold;
            return this;
        }

        public final Double getWeight() {
            return weight;
        }

        public final void setWeight(Double weight) {
            this.weight = weight;
        }

        @Override
        public final Builder weight(Double weight) {
            this.weight = weight;
            return this;
        }

        @Override
        public EventParameters build() {
            return new EventParameters(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
