/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.personalize.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeCampaignResponse extends PersonalizeResponse implements
        ToCopyableBuilder<DescribeCampaignResponse.Builder, DescribeCampaignResponse> {
    private static final SdkField<Campaign> CAMPAIGN_FIELD = SdkField.<Campaign> builder(MarshallingType.SDK_POJO)
            .memberName("campaign").getter(getter(DescribeCampaignResponse::campaign)).setter(setter(Builder::campaign))
            .constructor(Campaign::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("campaign").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CAMPAIGN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final Campaign campaign;

    private DescribeCampaignResponse(BuilderImpl builder) {
        super(builder);
        this.campaign = builder.campaign;
    }

    /**
     * <note>
     * <p>
     * The <code>latestCampaignUpdate</code> field is only returned when the campaign has had at least one
     * <code>UpdateCampaign</code> call.
     * </p>
     * </note>
     * <p>
     * The properties of the campaign.
     * </p>
     * <note>
     * <p>
     * The <code>latestCampaignUpdate</code> field is only returned when the campaign has had at least one
     * <code>UpdateCampaign</code> call.
     * </p>
     * </note>
     * 
     * @return <p>
     *         The <code>latestCampaignUpdate</code> field is only returned when the campaign has had at least one
     *         <code>UpdateCampaign</code> call.
     *         </p>
     *         </note>
     *         <p>
     *         The properties of the campaign.
     *         </p>
     *         <note>
     *         <p>
     *         The <code>latestCampaignUpdate</code> field is only returned when the campaign has had at least one
     *         <code>UpdateCampaign</code> call.
     *         </p>
     */
    public final Campaign campaign() {
        return campaign;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(campaign());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeCampaignResponse)) {
            return false;
        }
        DescribeCampaignResponse other = (DescribeCampaignResponse) obj;
        return Objects.equals(campaign(), other.campaign());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeCampaignResponse").add("Campaign", campaign()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "campaign":
            return Optional.ofNullable(clazz.cast(campaign()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("campaign", CAMPAIGN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeCampaignResponse, T> g) {
        return obj -> g.apply((DescribeCampaignResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends PersonalizeResponse.Builder, SdkPojo, CopyableBuilder<Builder, DescribeCampaignResponse> {
        /**
         * <note>
         * <p>
         * The <code>latestCampaignUpdate</code> field is only returned when the campaign has had at least one
         * <code>UpdateCampaign</code> call.
         * </p>
         * </note>
         * <p>
         * The properties of the campaign.
         * </p>
         * <note>
         * <p>
         * The <code>latestCampaignUpdate</code> field is only returned when the campaign has had at least one
         * <code>UpdateCampaign</code> call.
         * </p>
         * </note>
         * 
         * @param campaign
         *        <p>
         *        The <code>latestCampaignUpdate</code> field is only returned when the campaign has had at least one
         *        <code>UpdateCampaign</code> call.
         *        </p>
         *        </note>
         *        <p>
         *        The properties of the campaign.
         *        </p>
         *        <note>
         *        <p>
         *        The <code>latestCampaignUpdate</code> field is only returned when the campaign has had at least one
         *        <code>UpdateCampaign</code> call.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder campaign(Campaign campaign);

        /**
         * <note>
         * <p>
         * The <code>latestCampaignUpdate</code> field is only returned when the campaign has had at least one
         * <code>UpdateCampaign</code> call.
         * </p>
         * </note>
         * <p>
         * The properties of the campaign.
         * </p>
         * <note>
         * <p>
         * The <code>latestCampaignUpdate</code> field is only returned when the campaign has had at least one
         * <code>UpdateCampaign</code> call.
         * </p>
         * </note> This is a convenience method that creates an instance of the {@link Campaign.Builder} avoiding the
         * need to create one manually via {@link Campaign#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link Campaign.Builder#build()} is called immediately and its result is
         * passed to {@link #campaign(Campaign)}.
         * 
         * @param campaign
         *        a consumer that will call methods on {@link Campaign.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #campaign(Campaign)
         */
        default Builder campaign(Consumer<Campaign.Builder> campaign) {
            return campaign(Campaign.builder().applyMutation(campaign).build());
        }
    }

    static final class BuilderImpl extends PersonalizeResponse.BuilderImpl implements Builder {
        private Campaign campaign;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeCampaignResponse model) {
            super(model);
            campaign(model.campaign);
        }

        public final Campaign.Builder getCampaign() {
            return campaign != null ? campaign.toBuilder() : null;
        }

        public final void setCampaign(Campaign.BuilderImpl campaign) {
            this.campaign = campaign != null ? campaign.build() : null;
        }

        @Override
        public final Builder campaign(Campaign campaign) {
            this.campaign = campaign;
            return this;
        }

        @Override
        public DescribeCampaignResponse build() {
            return new DescribeCampaignResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
