/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.personalize.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains information on a batch inference job.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class BatchInferenceJob implements SdkPojo, Serializable,
        ToCopyableBuilder<BatchInferenceJob.Builder, BatchInferenceJob> {
    private static final SdkField<String> JOB_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("jobName").getter(getter(BatchInferenceJob::jobName)).setter(setter(Builder::jobName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("jobName").build()).build();

    private static final SdkField<String> BATCH_INFERENCE_JOB_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("batchInferenceJobArn").getter(getter(BatchInferenceJob::batchInferenceJobArn))
            .setter(setter(Builder::batchInferenceJobArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("batchInferenceJobArn").build())
            .build();

    private static final SdkField<String> FILTER_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("filterArn").getter(getter(BatchInferenceJob::filterArn)).setter(setter(Builder::filterArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("filterArn").build()).build();

    private static final SdkField<String> FAILURE_REASON_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("failureReason").getter(getter(BatchInferenceJob::failureReason)).setter(setter(Builder::failureReason))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("failureReason").build()).build();

    private static final SdkField<String> SOLUTION_VERSION_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("solutionVersionArn").getter(getter(BatchInferenceJob::solutionVersionArn))
            .setter(setter(Builder::solutionVersionArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("solutionVersionArn").build())
            .build();

    private static final SdkField<Integer> NUM_RESULTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("numResults").getter(getter(BatchInferenceJob::numResults)).setter(setter(Builder::numResults))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("numResults").build()).build();

    private static final SdkField<BatchInferenceJobInput> JOB_INPUT_FIELD = SdkField
            .<BatchInferenceJobInput> builder(MarshallingType.SDK_POJO).memberName("jobInput")
            .getter(getter(BatchInferenceJob::jobInput)).setter(setter(Builder::jobInput))
            .constructor(BatchInferenceJobInput::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("jobInput").build()).build();

    private static final SdkField<BatchInferenceJobOutput> JOB_OUTPUT_FIELD = SdkField
            .<BatchInferenceJobOutput> builder(MarshallingType.SDK_POJO).memberName("jobOutput")
            .getter(getter(BatchInferenceJob::jobOutput)).setter(setter(Builder::jobOutput))
            .constructor(BatchInferenceJobOutput::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("jobOutput").build()).build();

    private static final SdkField<BatchInferenceJobConfig> BATCH_INFERENCE_JOB_CONFIG_FIELD = SdkField
            .<BatchInferenceJobConfig> builder(MarshallingType.SDK_POJO).memberName("batchInferenceJobConfig")
            .getter(getter(BatchInferenceJob::batchInferenceJobConfig)).setter(setter(Builder::batchInferenceJobConfig))
            .constructor(BatchInferenceJobConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("batchInferenceJobConfig").build())
            .build();

    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("roleArn").getter(getter(BatchInferenceJob::roleArn)).setter(setter(Builder::roleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("roleArn").build()).build();

    private static final SdkField<String> BATCH_INFERENCE_JOB_MODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("batchInferenceJobMode").getter(getter(BatchInferenceJob::batchInferenceJobModeAsString))
            .setter(setter(Builder::batchInferenceJobMode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("batchInferenceJobMode").build())
            .build();

    private static final SdkField<ThemeGenerationConfig> THEME_GENERATION_CONFIG_FIELD = SdkField
            .<ThemeGenerationConfig> builder(MarshallingType.SDK_POJO).memberName("themeGenerationConfig")
            .getter(getter(BatchInferenceJob::themeGenerationConfig)).setter(setter(Builder::themeGenerationConfig))
            .constructor(ThemeGenerationConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("themeGenerationConfig").build())
            .build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("status")
            .getter(getter(BatchInferenceJob::status)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()).build();

    private static final SdkField<Instant> CREATION_DATE_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("creationDateTime").getter(getter(BatchInferenceJob::creationDateTime))
            .setter(setter(Builder::creationDateTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("creationDateTime").build()).build();

    private static final SdkField<Instant> LAST_UPDATED_DATE_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("lastUpdatedDateTime").getter(getter(BatchInferenceJob::lastUpdatedDateTime))
            .setter(setter(Builder::lastUpdatedDateTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastUpdatedDateTime").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(JOB_NAME_FIELD,
            BATCH_INFERENCE_JOB_ARN_FIELD, FILTER_ARN_FIELD, FAILURE_REASON_FIELD, SOLUTION_VERSION_ARN_FIELD, NUM_RESULTS_FIELD,
            JOB_INPUT_FIELD, JOB_OUTPUT_FIELD, BATCH_INFERENCE_JOB_CONFIG_FIELD, ROLE_ARN_FIELD, BATCH_INFERENCE_JOB_MODE_FIELD,
            THEME_GENERATION_CONFIG_FIELD, STATUS_FIELD, CREATION_DATE_TIME_FIELD, LAST_UPDATED_DATE_TIME_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String jobName;

    private final String batchInferenceJobArn;

    private final String filterArn;

    private final String failureReason;

    private final String solutionVersionArn;

    private final Integer numResults;

    private final BatchInferenceJobInput jobInput;

    private final BatchInferenceJobOutput jobOutput;

    private final BatchInferenceJobConfig batchInferenceJobConfig;

    private final String roleArn;

    private final String batchInferenceJobMode;

    private final ThemeGenerationConfig themeGenerationConfig;

    private final String status;

    private final Instant creationDateTime;

    private final Instant lastUpdatedDateTime;

    private BatchInferenceJob(BuilderImpl builder) {
        this.jobName = builder.jobName;
        this.batchInferenceJobArn = builder.batchInferenceJobArn;
        this.filterArn = builder.filterArn;
        this.failureReason = builder.failureReason;
        this.solutionVersionArn = builder.solutionVersionArn;
        this.numResults = builder.numResults;
        this.jobInput = builder.jobInput;
        this.jobOutput = builder.jobOutput;
        this.batchInferenceJobConfig = builder.batchInferenceJobConfig;
        this.roleArn = builder.roleArn;
        this.batchInferenceJobMode = builder.batchInferenceJobMode;
        this.themeGenerationConfig = builder.themeGenerationConfig;
        this.status = builder.status;
        this.creationDateTime = builder.creationDateTime;
        this.lastUpdatedDateTime = builder.lastUpdatedDateTime;
    }

    /**
     * <p>
     * The name of the batch inference job.
     * </p>
     * 
     * @return The name of the batch inference job.
     */
    public final String jobName() {
        return jobName;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the batch inference job.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the batch inference job.
     */
    public final String batchInferenceJobArn() {
        return batchInferenceJobArn;
    }

    /**
     * <p>
     * The ARN of the filter used on the batch inference job.
     * </p>
     * 
     * @return The ARN of the filter used on the batch inference job.
     */
    public final String filterArn() {
        return filterArn;
    }

    /**
     * <p>
     * If the batch inference job failed, the reason for the failure.
     * </p>
     * 
     * @return If the batch inference job failed, the reason for the failure.
     */
    public final String failureReason() {
        return failureReason;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the solution version from which the batch inference job was created.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the solution version from which the batch inference job was created.
     */
    public final String solutionVersionArn() {
        return solutionVersionArn;
    }

    /**
     * <p>
     * The number of recommendations generated by the batch inference job. This number includes the error messages
     * generated for failed input records.
     * </p>
     * 
     * @return The number of recommendations generated by the batch inference job. This number includes the error
     *         messages generated for failed input records.
     */
    public final Integer numResults() {
        return numResults;
    }

    /**
     * <p>
     * The Amazon S3 path that leads to the input data used to generate the batch inference job.
     * </p>
     * 
     * @return The Amazon S3 path that leads to the input data used to generate the batch inference job.
     */
    public final BatchInferenceJobInput jobInput() {
        return jobInput;
    }

    /**
     * <p>
     * The Amazon S3 bucket that contains the output data generated by the batch inference job.
     * </p>
     * 
     * @return The Amazon S3 bucket that contains the output data generated by the batch inference job.
     */
    public final BatchInferenceJobOutput jobOutput() {
        return jobOutput;
    }

    /**
     * <p>
     * A string to string map of the configuration details of a batch inference job.
     * </p>
     * 
     * @return A string to string map of the configuration details of a batch inference job.
     */
    public final BatchInferenceJobConfig batchInferenceJobConfig() {
        return batchInferenceJobConfig;
    }

    /**
     * <p>
     * The ARN of the Amazon Identity and Access Management (IAM) role that requested the batch inference job.
     * </p>
     * 
     * @return The ARN of the Amazon Identity and Access Management (IAM) role that requested the batch inference job.
     */
    public final String roleArn() {
        return roleArn;
    }

    /**
     * <p>
     * The job's mode.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #batchInferenceJobMode} will return {@link BatchInferenceJobMode#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #batchInferenceJobModeAsString}.
     * </p>
     * 
     * @return The job's mode.
     * @see BatchInferenceJobMode
     */
    public final BatchInferenceJobMode batchInferenceJobMode() {
        return BatchInferenceJobMode.fromValue(batchInferenceJobMode);
    }

    /**
     * <p>
     * The job's mode.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #batchInferenceJobMode} will return {@link BatchInferenceJobMode#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #batchInferenceJobModeAsString}.
     * </p>
     * 
     * @return The job's mode.
     * @see BatchInferenceJobMode
     */
    public final String batchInferenceJobModeAsString() {
        return batchInferenceJobMode;
    }

    /**
     * <p>
     * The job's theme generation settings.
     * </p>
     * 
     * @return The job's theme generation settings.
     */
    public final ThemeGenerationConfig themeGenerationConfig() {
        return themeGenerationConfig;
    }

    /**
     * <p>
     * The status of the batch inference job. The status is one of the following values:
     * </p>
     * <ul>
     * <li>
     * <p>
     * PENDING
     * </p>
     * </li>
     * <li>
     * <p>
     * IN PROGRESS
     * </p>
     * </li>
     * <li>
     * <p>
     * ACTIVE
     * </p>
     * </li>
     * <li>
     * <p>
     * CREATE FAILED
     * </p>
     * </li>
     * </ul>
     * 
     * @return The status of the batch inference job. The status is one of the following values:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         PENDING
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         IN PROGRESS
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         ACTIVE
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         CREATE FAILED
     *         </p>
     *         </li>
     */
    public final String status() {
        return status;
    }

    /**
     * <p>
     * The time at which the batch inference job was created.
     * </p>
     * 
     * @return The time at which the batch inference job was created.
     */
    public final Instant creationDateTime() {
        return creationDateTime;
    }

    /**
     * <p>
     * The time at which the batch inference job was last updated.
     * </p>
     * 
     * @return The time at which the batch inference job was last updated.
     */
    public final Instant lastUpdatedDateTime() {
        return lastUpdatedDateTime;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(jobName());
        hashCode = 31 * hashCode + Objects.hashCode(batchInferenceJobArn());
        hashCode = 31 * hashCode + Objects.hashCode(filterArn());
        hashCode = 31 * hashCode + Objects.hashCode(failureReason());
        hashCode = 31 * hashCode + Objects.hashCode(solutionVersionArn());
        hashCode = 31 * hashCode + Objects.hashCode(numResults());
        hashCode = 31 * hashCode + Objects.hashCode(jobInput());
        hashCode = 31 * hashCode + Objects.hashCode(jobOutput());
        hashCode = 31 * hashCode + Objects.hashCode(batchInferenceJobConfig());
        hashCode = 31 * hashCode + Objects.hashCode(roleArn());
        hashCode = 31 * hashCode + Objects.hashCode(batchInferenceJobModeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(themeGenerationConfig());
        hashCode = 31 * hashCode + Objects.hashCode(status());
        hashCode = 31 * hashCode + Objects.hashCode(creationDateTime());
        hashCode = 31 * hashCode + Objects.hashCode(lastUpdatedDateTime());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchInferenceJob)) {
            return false;
        }
        BatchInferenceJob other = (BatchInferenceJob) obj;
        return Objects.equals(jobName(), other.jobName()) && Objects.equals(batchInferenceJobArn(), other.batchInferenceJobArn())
                && Objects.equals(filterArn(), other.filterArn()) && Objects.equals(failureReason(), other.failureReason())
                && Objects.equals(solutionVersionArn(), other.solutionVersionArn())
                && Objects.equals(numResults(), other.numResults()) && Objects.equals(jobInput(), other.jobInput())
                && Objects.equals(jobOutput(), other.jobOutput())
                && Objects.equals(batchInferenceJobConfig(), other.batchInferenceJobConfig())
                && Objects.equals(roleArn(), other.roleArn())
                && Objects.equals(batchInferenceJobModeAsString(), other.batchInferenceJobModeAsString())
                && Objects.equals(themeGenerationConfig(), other.themeGenerationConfig())
                && Objects.equals(status(), other.status()) && Objects.equals(creationDateTime(), other.creationDateTime())
                && Objects.equals(lastUpdatedDateTime(), other.lastUpdatedDateTime());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("BatchInferenceJob").add("JobName", jobName())
                .add("BatchInferenceJobArn", batchInferenceJobArn()).add("FilterArn", filterArn())
                .add("FailureReason", failureReason()).add("SolutionVersionArn", solutionVersionArn())
                .add("NumResults", numResults()).add("JobInput", jobInput()).add("JobOutput", jobOutput())
                .add("BatchInferenceJobConfig", batchInferenceJobConfig()).add("RoleArn", roleArn())
                .add("BatchInferenceJobMode", batchInferenceJobModeAsString())
                .add("ThemeGenerationConfig", themeGenerationConfig()).add("Status", status())
                .add("CreationDateTime", creationDateTime()).add("LastUpdatedDateTime", lastUpdatedDateTime()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "jobName":
            return Optional.ofNullable(clazz.cast(jobName()));
        case "batchInferenceJobArn":
            return Optional.ofNullable(clazz.cast(batchInferenceJobArn()));
        case "filterArn":
            return Optional.ofNullable(clazz.cast(filterArn()));
        case "failureReason":
            return Optional.ofNullable(clazz.cast(failureReason()));
        case "solutionVersionArn":
            return Optional.ofNullable(clazz.cast(solutionVersionArn()));
        case "numResults":
            return Optional.ofNullable(clazz.cast(numResults()));
        case "jobInput":
            return Optional.ofNullable(clazz.cast(jobInput()));
        case "jobOutput":
            return Optional.ofNullable(clazz.cast(jobOutput()));
        case "batchInferenceJobConfig":
            return Optional.ofNullable(clazz.cast(batchInferenceJobConfig()));
        case "roleArn":
            return Optional.ofNullable(clazz.cast(roleArn()));
        case "batchInferenceJobMode":
            return Optional.ofNullable(clazz.cast(batchInferenceJobModeAsString()));
        case "themeGenerationConfig":
            return Optional.ofNullable(clazz.cast(themeGenerationConfig()));
        case "status":
            return Optional.ofNullable(clazz.cast(status()));
        case "creationDateTime":
            return Optional.ofNullable(clazz.cast(creationDateTime()));
        case "lastUpdatedDateTime":
            return Optional.ofNullable(clazz.cast(lastUpdatedDateTime()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("jobName", JOB_NAME_FIELD);
        map.put("batchInferenceJobArn", BATCH_INFERENCE_JOB_ARN_FIELD);
        map.put("filterArn", FILTER_ARN_FIELD);
        map.put("failureReason", FAILURE_REASON_FIELD);
        map.put("solutionVersionArn", SOLUTION_VERSION_ARN_FIELD);
        map.put("numResults", NUM_RESULTS_FIELD);
        map.put("jobInput", JOB_INPUT_FIELD);
        map.put("jobOutput", JOB_OUTPUT_FIELD);
        map.put("batchInferenceJobConfig", BATCH_INFERENCE_JOB_CONFIG_FIELD);
        map.put("roleArn", ROLE_ARN_FIELD);
        map.put("batchInferenceJobMode", BATCH_INFERENCE_JOB_MODE_FIELD);
        map.put("themeGenerationConfig", THEME_GENERATION_CONFIG_FIELD);
        map.put("status", STATUS_FIELD);
        map.put("creationDateTime", CREATION_DATE_TIME_FIELD);
        map.put("lastUpdatedDateTime", LAST_UPDATED_DATE_TIME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<BatchInferenceJob, T> g) {
        return obj -> g.apply((BatchInferenceJob) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, BatchInferenceJob> {
        /**
         * <p>
         * The name of the batch inference job.
         * </p>
         * 
         * @param jobName
         *        The name of the batch inference job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder jobName(String jobName);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the batch inference job.
         * </p>
         * 
         * @param batchInferenceJobArn
         *        The Amazon Resource Name (ARN) of the batch inference job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder batchInferenceJobArn(String batchInferenceJobArn);

        /**
         * <p>
         * The ARN of the filter used on the batch inference job.
         * </p>
         * 
         * @param filterArn
         *        The ARN of the filter used on the batch inference job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filterArn(String filterArn);

        /**
         * <p>
         * If the batch inference job failed, the reason for the failure.
         * </p>
         * 
         * @param failureReason
         *        If the batch inference job failed, the reason for the failure.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder failureReason(String failureReason);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the solution version from which the batch inference job was created.
         * </p>
         * 
         * @param solutionVersionArn
         *        The Amazon Resource Name (ARN) of the solution version from which the batch inference job was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder solutionVersionArn(String solutionVersionArn);

        /**
         * <p>
         * The number of recommendations generated by the batch inference job. This number includes the error messages
         * generated for failed input records.
         * </p>
         * 
         * @param numResults
         *        The number of recommendations generated by the batch inference job. This number includes the error
         *        messages generated for failed input records.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder numResults(Integer numResults);

        /**
         * <p>
         * The Amazon S3 path that leads to the input data used to generate the batch inference job.
         * </p>
         * 
         * @param jobInput
         *        The Amazon S3 path that leads to the input data used to generate the batch inference job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder jobInput(BatchInferenceJobInput jobInput);

        /**
         * <p>
         * The Amazon S3 path that leads to the input data used to generate the batch inference job.
         * </p>
         * This is a convenience method that creates an instance of the {@link BatchInferenceJobInput.Builder} avoiding
         * the need to create one manually via {@link BatchInferenceJobInput#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link BatchInferenceJobInput.Builder#build()} is called immediately and
         * its result is passed to {@link #jobInput(BatchInferenceJobInput)}.
         * 
         * @param jobInput
         *        a consumer that will call methods on {@link BatchInferenceJobInput.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #jobInput(BatchInferenceJobInput)
         */
        default Builder jobInput(Consumer<BatchInferenceJobInput.Builder> jobInput) {
            return jobInput(BatchInferenceJobInput.builder().applyMutation(jobInput).build());
        }

        /**
         * <p>
         * The Amazon S3 bucket that contains the output data generated by the batch inference job.
         * </p>
         * 
         * @param jobOutput
         *        The Amazon S3 bucket that contains the output data generated by the batch inference job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder jobOutput(BatchInferenceJobOutput jobOutput);

        /**
         * <p>
         * The Amazon S3 bucket that contains the output data generated by the batch inference job.
         * </p>
         * This is a convenience method that creates an instance of the {@link BatchInferenceJobOutput.Builder} avoiding
         * the need to create one manually via {@link BatchInferenceJobOutput#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link BatchInferenceJobOutput.Builder#build()} is called immediately
         * and its result is passed to {@link #jobOutput(BatchInferenceJobOutput)}.
         * 
         * @param jobOutput
         *        a consumer that will call methods on {@link BatchInferenceJobOutput.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #jobOutput(BatchInferenceJobOutput)
         */
        default Builder jobOutput(Consumer<BatchInferenceJobOutput.Builder> jobOutput) {
            return jobOutput(BatchInferenceJobOutput.builder().applyMutation(jobOutput).build());
        }

        /**
         * <p>
         * A string to string map of the configuration details of a batch inference job.
         * </p>
         * 
         * @param batchInferenceJobConfig
         *        A string to string map of the configuration details of a batch inference job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder batchInferenceJobConfig(BatchInferenceJobConfig batchInferenceJobConfig);

        /**
         * <p>
         * A string to string map of the configuration details of a batch inference job.
         * </p>
         * This is a convenience method that creates an instance of the {@link BatchInferenceJobConfig.Builder} avoiding
         * the need to create one manually via {@link BatchInferenceJobConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link BatchInferenceJobConfig.Builder#build()} is called immediately
         * and its result is passed to {@link #batchInferenceJobConfig(BatchInferenceJobConfig)}.
         * 
         * @param batchInferenceJobConfig
         *        a consumer that will call methods on {@link BatchInferenceJobConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #batchInferenceJobConfig(BatchInferenceJobConfig)
         */
        default Builder batchInferenceJobConfig(Consumer<BatchInferenceJobConfig.Builder> batchInferenceJobConfig) {
            return batchInferenceJobConfig(BatchInferenceJobConfig.builder().applyMutation(batchInferenceJobConfig).build());
        }

        /**
         * <p>
         * The ARN of the Amazon Identity and Access Management (IAM) role that requested the batch inference job.
         * </p>
         * 
         * @param roleArn
         *        The ARN of the Amazon Identity and Access Management (IAM) role that requested the batch inference
         *        job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder roleArn(String roleArn);

        /**
         * <p>
         * The job's mode.
         * </p>
         * 
         * @param batchInferenceJobMode
         *        The job's mode.
         * @see BatchInferenceJobMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see BatchInferenceJobMode
         */
        Builder batchInferenceJobMode(String batchInferenceJobMode);

        /**
         * <p>
         * The job's mode.
         * </p>
         * 
         * @param batchInferenceJobMode
         *        The job's mode.
         * @see BatchInferenceJobMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see BatchInferenceJobMode
         */
        Builder batchInferenceJobMode(BatchInferenceJobMode batchInferenceJobMode);

        /**
         * <p>
         * The job's theme generation settings.
         * </p>
         * 
         * @param themeGenerationConfig
         *        The job's theme generation settings.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder themeGenerationConfig(ThemeGenerationConfig themeGenerationConfig);

        /**
         * <p>
         * The job's theme generation settings.
         * </p>
         * This is a convenience method that creates an instance of the {@link ThemeGenerationConfig.Builder} avoiding
         * the need to create one manually via {@link ThemeGenerationConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ThemeGenerationConfig.Builder#build()} is called immediately and
         * its result is passed to {@link #themeGenerationConfig(ThemeGenerationConfig)}.
         * 
         * @param themeGenerationConfig
         *        a consumer that will call methods on {@link ThemeGenerationConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #themeGenerationConfig(ThemeGenerationConfig)
         */
        default Builder themeGenerationConfig(Consumer<ThemeGenerationConfig.Builder> themeGenerationConfig) {
            return themeGenerationConfig(ThemeGenerationConfig.builder().applyMutation(themeGenerationConfig).build());
        }

        /**
         * <p>
         * The status of the batch inference job. The status is one of the following values:
         * </p>
         * <ul>
         * <li>
         * <p>
         * PENDING
         * </p>
         * </li>
         * <li>
         * <p>
         * IN PROGRESS
         * </p>
         * </li>
         * <li>
         * <p>
         * ACTIVE
         * </p>
         * </li>
         * <li>
         * <p>
         * CREATE FAILED
         * </p>
         * </li>
         * </ul>
         * 
         * @param status
         *        The status of the batch inference job. The status is one of the following values:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        PENDING
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        IN PROGRESS
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        ACTIVE
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        CREATE FAILED
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder status(String status);

        /**
         * <p>
         * The time at which the batch inference job was created.
         * </p>
         * 
         * @param creationDateTime
         *        The time at which the batch inference job was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationDateTime(Instant creationDateTime);

        /**
         * <p>
         * The time at which the batch inference job was last updated.
         * </p>
         * 
         * @param lastUpdatedDateTime
         *        The time at which the batch inference job was last updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastUpdatedDateTime(Instant lastUpdatedDateTime);
    }

    static final class BuilderImpl implements Builder {
        private String jobName;

        private String batchInferenceJobArn;

        private String filterArn;

        private String failureReason;

        private String solutionVersionArn;

        private Integer numResults;

        private BatchInferenceJobInput jobInput;

        private BatchInferenceJobOutput jobOutput;

        private BatchInferenceJobConfig batchInferenceJobConfig;

        private String roleArn;

        private String batchInferenceJobMode;

        private ThemeGenerationConfig themeGenerationConfig;

        private String status;

        private Instant creationDateTime;

        private Instant lastUpdatedDateTime;

        private BuilderImpl() {
        }

        private BuilderImpl(BatchInferenceJob model) {
            jobName(model.jobName);
            batchInferenceJobArn(model.batchInferenceJobArn);
            filterArn(model.filterArn);
            failureReason(model.failureReason);
            solutionVersionArn(model.solutionVersionArn);
            numResults(model.numResults);
            jobInput(model.jobInput);
            jobOutput(model.jobOutput);
            batchInferenceJobConfig(model.batchInferenceJobConfig);
            roleArn(model.roleArn);
            batchInferenceJobMode(model.batchInferenceJobMode);
            themeGenerationConfig(model.themeGenerationConfig);
            status(model.status);
            creationDateTime(model.creationDateTime);
            lastUpdatedDateTime(model.lastUpdatedDateTime);
        }

        public final String getJobName() {
            return jobName;
        }

        public final void setJobName(String jobName) {
            this.jobName = jobName;
        }

        @Override
        public final Builder jobName(String jobName) {
            this.jobName = jobName;
            return this;
        }

        public final String getBatchInferenceJobArn() {
            return batchInferenceJobArn;
        }

        public final void setBatchInferenceJobArn(String batchInferenceJobArn) {
            this.batchInferenceJobArn = batchInferenceJobArn;
        }

        @Override
        public final Builder batchInferenceJobArn(String batchInferenceJobArn) {
            this.batchInferenceJobArn = batchInferenceJobArn;
            return this;
        }

        public final String getFilterArn() {
            return filterArn;
        }

        public final void setFilterArn(String filterArn) {
            this.filterArn = filterArn;
        }

        @Override
        public final Builder filterArn(String filterArn) {
            this.filterArn = filterArn;
            return this;
        }

        public final String getFailureReason() {
            return failureReason;
        }

        public final void setFailureReason(String failureReason) {
            this.failureReason = failureReason;
        }

        @Override
        public final Builder failureReason(String failureReason) {
            this.failureReason = failureReason;
            return this;
        }

        public final String getSolutionVersionArn() {
            return solutionVersionArn;
        }

        public final void setSolutionVersionArn(String solutionVersionArn) {
            this.solutionVersionArn = solutionVersionArn;
        }

        @Override
        public final Builder solutionVersionArn(String solutionVersionArn) {
            this.solutionVersionArn = solutionVersionArn;
            return this;
        }

        public final Integer getNumResults() {
            return numResults;
        }

        public final void setNumResults(Integer numResults) {
            this.numResults = numResults;
        }

        @Override
        public final Builder numResults(Integer numResults) {
            this.numResults = numResults;
            return this;
        }

        public final BatchInferenceJobInput.Builder getJobInput() {
            return jobInput != null ? jobInput.toBuilder() : null;
        }

        public final void setJobInput(BatchInferenceJobInput.BuilderImpl jobInput) {
            this.jobInput = jobInput != null ? jobInput.build() : null;
        }

        @Override
        public final Builder jobInput(BatchInferenceJobInput jobInput) {
            this.jobInput = jobInput;
            return this;
        }

        public final BatchInferenceJobOutput.Builder getJobOutput() {
            return jobOutput != null ? jobOutput.toBuilder() : null;
        }

        public final void setJobOutput(BatchInferenceJobOutput.BuilderImpl jobOutput) {
            this.jobOutput = jobOutput != null ? jobOutput.build() : null;
        }

        @Override
        public final Builder jobOutput(BatchInferenceJobOutput jobOutput) {
            this.jobOutput = jobOutput;
            return this;
        }

        public final BatchInferenceJobConfig.Builder getBatchInferenceJobConfig() {
            return batchInferenceJobConfig != null ? batchInferenceJobConfig.toBuilder() : null;
        }

        public final void setBatchInferenceJobConfig(BatchInferenceJobConfig.BuilderImpl batchInferenceJobConfig) {
            this.batchInferenceJobConfig = batchInferenceJobConfig != null ? batchInferenceJobConfig.build() : null;
        }

        @Override
        public final Builder batchInferenceJobConfig(BatchInferenceJobConfig batchInferenceJobConfig) {
            this.batchInferenceJobConfig = batchInferenceJobConfig;
            return this;
        }

        public final String getRoleArn() {
            return roleArn;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public final String getBatchInferenceJobMode() {
            return batchInferenceJobMode;
        }

        public final void setBatchInferenceJobMode(String batchInferenceJobMode) {
            this.batchInferenceJobMode = batchInferenceJobMode;
        }

        @Override
        public final Builder batchInferenceJobMode(String batchInferenceJobMode) {
            this.batchInferenceJobMode = batchInferenceJobMode;
            return this;
        }

        @Override
        public final Builder batchInferenceJobMode(BatchInferenceJobMode batchInferenceJobMode) {
            this.batchInferenceJobMode(batchInferenceJobMode == null ? null : batchInferenceJobMode.toString());
            return this;
        }

        public final ThemeGenerationConfig.Builder getThemeGenerationConfig() {
            return themeGenerationConfig != null ? themeGenerationConfig.toBuilder() : null;
        }

        public final void setThemeGenerationConfig(ThemeGenerationConfig.BuilderImpl themeGenerationConfig) {
            this.themeGenerationConfig = themeGenerationConfig != null ? themeGenerationConfig.build() : null;
        }

        @Override
        public final Builder themeGenerationConfig(ThemeGenerationConfig themeGenerationConfig) {
            this.themeGenerationConfig = themeGenerationConfig;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        public final Instant getCreationDateTime() {
            return creationDateTime;
        }

        public final void setCreationDateTime(Instant creationDateTime) {
            this.creationDateTime = creationDateTime;
        }

        @Override
        public final Builder creationDateTime(Instant creationDateTime) {
            this.creationDateTime = creationDateTime;
            return this;
        }

        public final Instant getLastUpdatedDateTime() {
            return lastUpdatedDateTime;
        }

        public final void setLastUpdatedDateTime(Instant lastUpdatedDateTime) {
            this.lastUpdatedDateTime = lastUpdatedDateTime;
        }

        @Override
        public final Builder lastUpdatedDateTime(Instant lastUpdatedDateTime) {
            this.lastUpdatedDateTime = lastUpdatedDateTime;
            return this;
        }

        @Override
        public BatchInferenceJob build() {
            return new BatchInferenceJob(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
