/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.personalize.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.personalize.model.AlgorithmImage;
import software.amazon.awssdk.services.personalize.model.DefaultHyperParameterRanges;
import software.amazon.awssdk.services.personalize.model.HyperParametersCopier;
import software.amazon.awssdk.services.personalize.model.ResourceConfigCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Algorithm
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Algorithm> {
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("name").getter(Algorithm.getter(Algorithm::name)).setter(Algorithm.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<String> ALGORITHM_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("algorithmArn").getter(Algorithm.getter(Algorithm::algorithmArn)).setter(Algorithm.setter(Builder::algorithmArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("algorithmArn").build()}).build();
    private static final SdkField<AlgorithmImage> ALGORITHM_IMAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("algorithmImage").getter(Algorithm.getter(Algorithm::algorithmImage)).setter(Algorithm.setter(Builder::algorithmImage)).constructor(AlgorithmImage::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("algorithmImage").build()}).build();
    private static final SdkField<Map<String, String>> DEFAULT_HYPER_PARAMETERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("defaultHyperParameters").getter(Algorithm.getter(Algorithm::defaultHyperParameters)).setter(Algorithm.setter(Builder::defaultHyperParameters)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("defaultHyperParameters").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<DefaultHyperParameterRanges> DEFAULT_HYPER_PARAMETER_RANGES_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("defaultHyperParameterRanges").getter(Algorithm.getter(Algorithm::defaultHyperParameterRanges)).setter(Algorithm.setter(Builder::defaultHyperParameterRanges)).constructor(DefaultHyperParameterRanges::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("defaultHyperParameterRanges").build()}).build();
    private static final SdkField<Map<String, String>> DEFAULT_RESOURCE_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("defaultResourceConfig").getter(Algorithm.getter(Algorithm::defaultResourceConfig)).setter(Algorithm.setter(Builder::defaultResourceConfig)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("defaultResourceConfig").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<String> TRAINING_INPUT_MODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("trainingInputMode").getter(Algorithm.getter(Algorithm::trainingInputMode)).setter(Algorithm.setter(Builder::trainingInputMode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("trainingInputMode").build()}).build();
    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("roleArn").getter(Algorithm.getter(Algorithm::roleArn)).setter(Algorithm.setter(Builder::roleArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("roleArn").build()}).build();
    private static final SdkField<Instant> CREATION_DATE_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("creationDateTime").getter(Algorithm.getter(Algorithm::creationDateTime)).setter(Algorithm.setter(Builder::creationDateTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("creationDateTime").build()}).build();
    private static final SdkField<Instant> LAST_UPDATED_DATE_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("lastUpdatedDateTime").getter(Algorithm.getter(Algorithm::lastUpdatedDateTime)).setter(Algorithm.setter(Builder::lastUpdatedDateTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastUpdatedDateTime").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, ALGORITHM_ARN_FIELD, ALGORITHM_IMAGE_FIELD, DEFAULT_HYPER_PARAMETERS_FIELD, DEFAULT_HYPER_PARAMETER_RANGES_FIELD, DEFAULT_RESOURCE_CONFIG_FIELD, TRAINING_INPUT_MODE_FIELD, ROLE_ARN_FIELD, CREATION_DATE_TIME_FIELD, LAST_UPDATED_DATE_TIME_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Algorithm.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String name;
    private final String algorithmArn;
    private final AlgorithmImage algorithmImage;
    private final Map<String, String> defaultHyperParameters;
    private final DefaultHyperParameterRanges defaultHyperParameterRanges;
    private final Map<String, String> defaultResourceConfig;
    private final String trainingInputMode;
    private final String roleArn;
    private final Instant creationDateTime;
    private final Instant lastUpdatedDateTime;

    private Algorithm(BuilderImpl builder) {
        this.name = builder.name;
        this.algorithmArn = builder.algorithmArn;
        this.algorithmImage = builder.algorithmImage;
        this.defaultHyperParameters = builder.defaultHyperParameters;
        this.defaultHyperParameterRanges = builder.defaultHyperParameterRanges;
        this.defaultResourceConfig = builder.defaultResourceConfig;
        this.trainingInputMode = builder.trainingInputMode;
        this.roleArn = builder.roleArn;
        this.creationDateTime = builder.creationDateTime;
        this.lastUpdatedDateTime = builder.lastUpdatedDateTime;
    }

    public final String name() {
        return this.name;
    }

    public final String algorithmArn() {
        return this.algorithmArn;
    }

    public final AlgorithmImage algorithmImage() {
        return this.algorithmImage;
    }

    public final boolean hasDefaultHyperParameters() {
        return this.defaultHyperParameters != null && !(this.defaultHyperParameters instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> defaultHyperParameters() {
        return this.defaultHyperParameters;
    }

    public final DefaultHyperParameterRanges defaultHyperParameterRanges() {
        return this.defaultHyperParameterRanges;
    }

    public final boolean hasDefaultResourceConfig() {
        return this.defaultResourceConfig != null && !(this.defaultResourceConfig instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> defaultResourceConfig() {
        return this.defaultResourceConfig;
    }

    public final String trainingInputMode() {
        return this.trainingInputMode;
    }

    public final String roleArn() {
        return this.roleArn;
    }

    public final Instant creationDateTime() {
        return this.creationDateTime;
    }

    public final Instant lastUpdatedDateTime() {
        return this.lastUpdatedDateTime;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.algorithmArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.algorithmImage());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasDefaultHyperParameters() ? this.defaultHyperParameters() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.defaultHyperParameterRanges());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasDefaultResourceConfig() ? this.defaultResourceConfig() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.trainingInputMode());
        hashCode = 31 * hashCode + Objects.hashCode(this.roleArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.creationDateTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastUpdatedDateTime());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Algorithm)) {
            return false;
        }
        Algorithm other = (Algorithm)obj;
        return Objects.equals(this.name(), other.name()) && Objects.equals(this.algorithmArn(), other.algorithmArn()) && Objects.equals(this.algorithmImage(), other.algorithmImage()) && this.hasDefaultHyperParameters() == other.hasDefaultHyperParameters() && Objects.equals(this.defaultHyperParameters(), other.defaultHyperParameters()) && Objects.equals(this.defaultHyperParameterRanges(), other.defaultHyperParameterRanges()) && this.hasDefaultResourceConfig() == other.hasDefaultResourceConfig() && Objects.equals(this.defaultResourceConfig(), other.defaultResourceConfig()) && Objects.equals(this.trainingInputMode(), other.trainingInputMode()) && Objects.equals(this.roleArn(), other.roleArn()) && Objects.equals(this.creationDateTime(), other.creationDateTime()) && Objects.equals(this.lastUpdatedDateTime(), other.lastUpdatedDateTime());
    }

    public final String toString() {
        return ToString.builder((String)"Algorithm").add("Name", (Object)this.name()).add("AlgorithmArn", (Object)this.algorithmArn()).add("AlgorithmImage", (Object)this.algorithmImage()).add("DefaultHyperParameters", this.hasDefaultHyperParameters() ? this.defaultHyperParameters() : null).add("DefaultHyperParameterRanges", (Object)this.defaultHyperParameterRanges()).add("DefaultResourceConfig", this.hasDefaultResourceConfig() ? this.defaultResourceConfig() : null).add("TrainingInputMode", (Object)this.trainingInputMode()).add("RoleArn", (Object)this.roleArn()).add("CreationDateTime", (Object)this.creationDateTime()).add("LastUpdatedDateTime", (Object)this.lastUpdatedDateTime()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "algorithmArn": {
                return Optional.ofNullable(clazz.cast(this.algorithmArn()));
            }
            case "algorithmImage": {
                return Optional.ofNullable(clazz.cast(this.algorithmImage()));
            }
            case "defaultHyperParameters": {
                return Optional.ofNullable(clazz.cast(this.defaultHyperParameters()));
            }
            case "defaultHyperParameterRanges": {
                return Optional.ofNullable(clazz.cast(this.defaultHyperParameterRanges()));
            }
            case "defaultResourceConfig": {
                return Optional.ofNullable(clazz.cast(this.defaultResourceConfig()));
            }
            case "trainingInputMode": {
                return Optional.ofNullable(clazz.cast(this.trainingInputMode()));
            }
            case "roleArn": {
                return Optional.ofNullable(clazz.cast(this.roleArn()));
            }
            case "creationDateTime": {
                return Optional.ofNullable(clazz.cast(this.creationDateTime()));
            }
            case "lastUpdatedDateTime": {
                return Optional.ofNullable(clazz.cast(this.lastUpdatedDateTime()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("name", NAME_FIELD);
        map.put("algorithmArn", ALGORITHM_ARN_FIELD);
        map.put("algorithmImage", ALGORITHM_IMAGE_FIELD);
        map.put("defaultHyperParameters", DEFAULT_HYPER_PARAMETERS_FIELD);
        map.put("defaultHyperParameterRanges", DEFAULT_HYPER_PARAMETER_RANGES_FIELD);
        map.put("defaultResourceConfig", DEFAULT_RESOURCE_CONFIG_FIELD);
        map.put("trainingInputMode", TRAINING_INPUT_MODE_FIELD);
        map.put("roleArn", ROLE_ARN_FIELD);
        map.put("creationDateTime", CREATION_DATE_TIME_FIELD);
        map.put("lastUpdatedDateTime", LAST_UPDATED_DATE_TIME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<Algorithm, T> g) {
        return obj -> g.apply((Algorithm)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String name;
        private String algorithmArn;
        private AlgorithmImage algorithmImage;
        private Map<String, String> defaultHyperParameters = DefaultSdkAutoConstructMap.getInstance();
        private DefaultHyperParameterRanges defaultHyperParameterRanges;
        private Map<String, String> defaultResourceConfig = DefaultSdkAutoConstructMap.getInstance();
        private String trainingInputMode;
        private String roleArn;
        private Instant creationDateTime;
        private Instant lastUpdatedDateTime;

        private BuilderImpl() {
        }

        private BuilderImpl(Algorithm model) {
            this.name(model.name);
            this.algorithmArn(model.algorithmArn);
            this.algorithmImage(model.algorithmImage);
            this.defaultHyperParameters(model.defaultHyperParameters);
            this.defaultHyperParameterRanges(model.defaultHyperParameterRanges);
            this.defaultResourceConfig(model.defaultResourceConfig);
            this.trainingInputMode(model.trainingInputMode);
            this.roleArn(model.roleArn);
            this.creationDateTime(model.creationDateTime);
            this.lastUpdatedDateTime(model.lastUpdatedDateTime);
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getAlgorithmArn() {
            return this.algorithmArn;
        }

        public final void setAlgorithmArn(String algorithmArn) {
            this.algorithmArn = algorithmArn;
        }

        @Override
        public final Builder algorithmArn(String algorithmArn) {
            this.algorithmArn = algorithmArn;
            return this;
        }

        public final AlgorithmImage.Builder getAlgorithmImage() {
            return this.algorithmImage != null ? this.algorithmImage.toBuilder() : null;
        }

        public final void setAlgorithmImage(AlgorithmImage.BuilderImpl algorithmImage) {
            this.algorithmImage = algorithmImage != null ? algorithmImage.build() : null;
        }

        @Override
        public final Builder algorithmImage(AlgorithmImage algorithmImage) {
            this.algorithmImage = algorithmImage;
            return this;
        }

        public final Map<String, String> getDefaultHyperParameters() {
            if (this.defaultHyperParameters instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.defaultHyperParameters;
        }

        public final void setDefaultHyperParameters(Map<String, String> defaultHyperParameters) {
            this.defaultHyperParameters = HyperParametersCopier.copy(defaultHyperParameters);
        }

        @Override
        public final Builder defaultHyperParameters(Map<String, String> defaultHyperParameters) {
            this.defaultHyperParameters = HyperParametersCopier.copy(defaultHyperParameters);
            return this;
        }

        public final DefaultHyperParameterRanges.Builder getDefaultHyperParameterRanges() {
            return this.defaultHyperParameterRanges != null ? this.defaultHyperParameterRanges.toBuilder() : null;
        }

        public final void setDefaultHyperParameterRanges(DefaultHyperParameterRanges.BuilderImpl defaultHyperParameterRanges) {
            this.defaultHyperParameterRanges = defaultHyperParameterRanges != null ? defaultHyperParameterRanges.build() : null;
        }

        @Override
        public final Builder defaultHyperParameterRanges(DefaultHyperParameterRanges defaultHyperParameterRanges) {
            this.defaultHyperParameterRanges = defaultHyperParameterRanges;
            return this;
        }

        public final Map<String, String> getDefaultResourceConfig() {
            if (this.defaultResourceConfig instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.defaultResourceConfig;
        }

        public final void setDefaultResourceConfig(Map<String, String> defaultResourceConfig) {
            this.defaultResourceConfig = ResourceConfigCopier.copy(defaultResourceConfig);
        }

        @Override
        public final Builder defaultResourceConfig(Map<String, String> defaultResourceConfig) {
            this.defaultResourceConfig = ResourceConfigCopier.copy(defaultResourceConfig);
            return this;
        }

        public final String getTrainingInputMode() {
            return this.trainingInputMode;
        }

        public final void setTrainingInputMode(String trainingInputMode) {
            this.trainingInputMode = trainingInputMode;
        }

        @Override
        public final Builder trainingInputMode(String trainingInputMode) {
            this.trainingInputMode = trainingInputMode;
            return this;
        }

        public final String getRoleArn() {
            return this.roleArn;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public final Instant getCreationDateTime() {
            return this.creationDateTime;
        }

        public final void setCreationDateTime(Instant creationDateTime) {
            this.creationDateTime = creationDateTime;
        }

        @Override
        public final Builder creationDateTime(Instant creationDateTime) {
            this.creationDateTime = creationDateTime;
            return this;
        }

        public final Instant getLastUpdatedDateTime() {
            return this.lastUpdatedDateTime;
        }

        public final void setLastUpdatedDateTime(Instant lastUpdatedDateTime) {
            this.lastUpdatedDateTime = lastUpdatedDateTime;
        }

        @Override
        public final Builder lastUpdatedDateTime(Instant lastUpdatedDateTime) {
            this.lastUpdatedDateTime = lastUpdatedDateTime;
            return this;
        }

        public Algorithm build() {
            return new Algorithm(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Algorithm> {
        public Builder name(String var1);

        public Builder algorithmArn(String var1);

        public Builder algorithmImage(AlgorithmImage var1);

        default public Builder algorithmImage(Consumer<AlgorithmImage.Builder> algorithmImage) {
            return this.algorithmImage((AlgorithmImage)((AlgorithmImage.Builder)AlgorithmImage.builder().applyMutation(algorithmImage)).build());
        }

        public Builder defaultHyperParameters(Map<String, String> var1);

        public Builder defaultHyperParameterRanges(DefaultHyperParameterRanges var1);

        default public Builder defaultHyperParameterRanges(Consumer<DefaultHyperParameterRanges.Builder> defaultHyperParameterRanges) {
            return this.defaultHyperParameterRanges((DefaultHyperParameterRanges)((DefaultHyperParameterRanges.Builder)DefaultHyperParameterRanges.builder().applyMutation(defaultHyperParameterRanges)).build());
        }

        public Builder defaultResourceConfig(Map<String, String> var1);

        public Builder trainingInputMode(String var1);

        public Builder roleArn(String var1);

        public Builder creationDateTime(Instant var1);

        public Builder lastUpdatedDateTime(Instant var1);
    }
}

