/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.personalize.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.personalize.model.AutoMLConfig;
import software.amazon.awssdk.services.personalize.model.AutoTrainingConfig;
import software.amazon.awssdk.services.personalize.model.EventsConfig;
import software.amazon.awssdk.services.personalize.model.FeatureTransformationParametersCopier;
import software.amazon.awssdk.services.personalize.model.HPOConfig;
import software.amazon.awssdk.services.personalize.model.HyperParametersCopier;
import software.amazon.awssdk.services.personalize.model.OptimizationObjective;
import software.amazon.awssdk.services.personalize.model.TrainingDataConfig;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SolutionConfig
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, SolutionConfig> {
    private static final SdkField<String> EVENT_VALUE_THRESHOLD_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("eventValueThreshold").getter(SolutionConfig.getter(SolutionConfig::eventValueThreshold)).setter(SolutionConfig.setter(Builder::eventValueThreshold)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("eventValueThreshold").build()}).build();
    private static final SdkField<HPOConfig> HPO_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("hpoConfig").getter(SolutionConfig.getter(SolutionConfig::hpoConfig)).setter(SolutionConfig.setter(Builder::hpoConfig)).constructor(HPOConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("hpoConfig").build()}).build();
    private static final SdkField<Map<String, String>> ALGORITHM_HYPER_PARAMETERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("algorithmHyperParameters").getter(SolutionConfig.getter(SolutionConfig::algorithmHyperParameters)).setter(SolutionConfig.setter(Builder::algorithmHyperParameters)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("algorithmHyperParameters").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<Map<String, String>> FEATURE_TRANSFORMATION_PARAMETERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("featureTransformationParameters").getter(SolutionConfig.getter(SolutionConfig::featureTransformationParameters)).setter(SolutionConfig.setter(Builder::featureTransformationParameters)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("featureTransformationParameters").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<AutoMLConfig> AUTO_ML_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("autoMLConfig").getter(SolutionConfig.getter(SolutionConfig::autoMLConfig)).setter(SolutionConfig.setter(Builder::autoMLConfig)).constructor(AutoMLConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("autoMLConfig").build()}).build();
    private static final SdkField<EventsConfig> EVENTS_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("eventsConfig").getter(SolutionConfig.getter(SolutionConfig::eventsConfig)).setter(SolutionConfig.setter(Builder::eventsConfig)).constructor(EventsConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("eventsConfig").build()}).build();
    private static final SdkField<OptimizationObjective> OPTIMIZATION_OBJECTIVE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("optimizationObjective").getter(SolutionConfig.getter(SolutionConfig::optimizationObjective)).setter(SolutionConfig.setter(Builder::optimizationObjective)).constructor(OptimizationObjective::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("optimizationObjective").build()}).build();
    private static final SdkField<TrainingDataConfig> TRAINING_DATA_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("trainingDataConfig").getter(SolutionConfig.getter(SolutionConfig::trainingDataConfig)).setter(SolutionConfig.setter(Builder::trainingDataConfig)).constructor(TrainingDataConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("trainingDataConfig").build()}).build();
    private static final SdkField<AutoTrainingConfig> AUTO_TRAINING_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("autoTrainingConfig").getter(SolutionConfig.getter(SolutionConfig::autoTrainingConfig)).setter(SolutionConfig.setter(Builder::autoTrainingConfig)).constructor(AutoTrainingConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("autoTrainingConfig").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EVENT_VALUE_THRESHOLD_FIELD, HPO_CONFIG_FIELD, ALGORITHM_HYPER_PARAMETERS_FIELD, FEATURE_TRANSFORMATION_PARAMETERS_FIELD, AUTO_ML_CONFIG_FIELD, EVENTS_CONFIG_FIELD, OPTIMIZATION_OBJECTIVE_FIELD, TRAINING_DATA_CONFIG_FIELD, AUTO_TRAINING_CONFIG_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = SolutionConfig.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String eventValueThreshold;
    private final HPOConfig hpoConfig;
    private final Map<String, String> algorithmHyperParameters;
    private final Map<String, String> featureTransformationParameters;
    private final AutoMLConfig autoMLConfig;
    private final EventsConfig eventsConfig;
    private final OptimizationObjective optimizationObjective;
    private final TrainingDataConfig trainingDataConfig;
    private final AutoTrainingConfig autoTrainingConfig;

    private SolutionConfig(BuilderImpl builder) {
        this.eventValueThreshold = builder.eventValueThreshold;
        this.hpoConfig = builder.hpoConfig;
        this.algorithmHyperParameters = builder.algorithmHyperParameters;
        this.featureTransformationParameters = builder.featureTransformationParameters;
        this.autoMLConfig = builder.autoMLConfig;
        this.eventsConfig = builder.eventsConfig;
        this.optimizationObjective = builder.optimizationObjective;
        this.trainingDataConfig = builder.trainingDataConfig;
        this.autoTrainingConfig = builder.autoTrainingConfig;
    }

    public final String eventValueThreshold() {
        return this.eventValueThreshold;
    }

    public final HPOConfig hpoConfig() {
        return this.hpoConfig;
    }

    public final boolean hasAlgorithmHyperParameters() {
        return this.algorithmHyperParameters != null && !(this.algorithmHyperParameters instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> algorithmHyperParameters() {
        return this.algorithmHyperParameters;
    }

    public final boolean hasFeatureTransformationParameters() {
        return this.featureTransformationParameters != null && !(this.featureTransformationParameters instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> featureTransformationParameters() {
        return this.featureTransformationParameters;
    }

    public final AutoMLConfig autoMLConfig() {
        return this.autoMLConfig;
    }

    public final EventsConfig eventsConfig() {
        return this.eventsConfig;
    }

    public final OptimizationObjective optimizationObjective() {
        return this.optimizationObjective;
    }

    public final TrainingDataConfig trainingDataConfig() {
        return this.trainingDataConfig;
    }

    public final AutoTrainingConfig autoTrainingConfig() {
        return this.autoTrainingConfig;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.eventValueThreshold());
        hashCode = 31 * hashCode + Objects.hashCode(this.hpoConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAlgorithmHyperParameters() ? this.algorithmHyperParameters() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasFeatureTransformationParameters() ? this.featureTransformationParameters() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.autoMLConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.eventsConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.optimizationObjective());
        hashCode = 31 * hashCode + Objects.hashCode(this.trainingDataConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.autoTrainingConfig());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SolutionConfig)) {
            return false;
        }
        SolutionConfig other = (SolutionConfig)obj;
        return Objects.equals(this.eventValueThreshold(), other.eventValueThreshold()) && Objects.equals(this.hpoConfig(), other.hpoConfig()) && this.hasAlgorithmHyperParameters() == other.hasAlgorithmHyperParameters() && Objects.equals(this.algorithmHyperParameters(), other.algorithmHyperParameters()) && this.hasFeatureTransformationParameters() == other.hasFeatureTransformationParameters() && Objects.equals(this.featureTransformationParameters(), other.featureTransformationParameters()) && Objects.equals(this.autoMLConfig(), other.autoMLConfig()) && Objects.equals(this.eventsConfig(), other.eventsConfig()) && Objects.equals(this.optimizationObjective(), other.optimizationObjective()) && Objects.equals(this.trainingDataConfig(), other.trainingDataConfig()) && Objects.equals(this.autoTrainingConfig(), other.autoTrainingConfig());
    }

    public final String toString() {
        return ToString.builder((String)"SolutionConfig").add("EventValueThreshold", (Object)this.eventValueThreshold()).add("HpoConfig", (Object)this.hpoConfig()).add("AlgorithmHyperParameters", this.hasAlgorithmHyperParameters() ? this.algorithmHyperParameters() : null).add("FeatureTransformationParameters", this.hasFeatureTransformationParameters() ? this.featureTransformationParameters() : null).add("AutoMLConfig", (Object)this.autoMLConfig()).add("EventsConfig", (Object)this.eventsConfig()).add("OptimizationObjective", (Object)this.optimizationObjective()).add("TrainingDataConfig", (Object)this.trainingDataConfig()).add("AutoTrainingConfig", (Object)this.autoTrainingConfig()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "eventValueThreshold": {
                return Optional.ofNullable(clazz.cast(this.eventValueThreshold()));
            }
            case "hpoConfig": {
                return Optional.ofNullable(clazz.cast(this.hpoConfig()));
            }
            case "algorithmHyperParameters": {
                return Optional.ofNullable(clazz.cast(this.algorithmHyperParameters()));
            }
            case "featureTransformationParameters": {
                return Optional.ofNullable(clazz.cast(this.featureTransformationParameters()));
            }
            case "autoMLConfig": {
                return Optional.ofNullable(clazz.cast(this.autoMLConfig()));
            }
            case "eventsConfig": {
                return Optional.ofNullable(clazz.cast(this.eventsConfig()));
            }
            case "optimizationObjective": {
                return Optional.ofNullable(clazz.cast(this.optimizationObjective()));
            }
            case "trainingDataConfig": {
                return Optional.ofNullable(clazz.cast(this.trainingDataConfig()));
            }
            case "autoTrainingConfig": {
                return Optional.ofNullable(clazz.cast(this.autoTrainingConfig()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("eventValueThreshold", EVENT_VALUE_THRESHOLD_FIELD);
        map.put("hpoConfig", HPO_CONFIG_FIELD);
        map.put("algorithmHyperParameters", ALGORITHM_HYPER_PARAMETERS_FIELD);
        map.put("featureTransformationParameters", FEATURE_TRANSFORMATION_PARAMETERS_FIELD);
        map.put("autoMLConfig", AUTO_ML_CONFIG_FIELD);
        map.put("eventsConfig", EVENTS_CONFIG_FIELD);
        map.put("optimizationObjective", OPTIMIZATION_OBJECTIVE_FIELD);
        map.put("trainingDataConfig", TRAINING_DATA_CONFIG_FIELD);
        map.put("autoTrainingConfig", AUTO_TRAINING_CONFIG_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<SolutionConfig, T> g) {
        return obj -> g.apply((SolutionConfig)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String eventValueThreshold;
        private HPOConfig hpoConfig;
        private Map<String, String> algorithmHyperParameters = DefaultSdkAutoConstructMap.getInstance();
        private Map<String, String> featureTransformationParameters = DefaultSdkAutoConstructMap.getInstance();
        private AutoMLConfig autoMLConfig;
        private EventsConfig eventsConfig;
        private OptimizationObjective optimizationObjective;
        private TrainingDataConfig trainingDataConfig;
        private AutoTrainingConfig autoTrainingConfig;

        private BuilderImpl() {
        }

        private BuilderImpl(SolutionConfig model) {
            this.eventValueThreshold(model.eventValueThreshold);
            this.hpoConfig(model.hpoConfig);
            this.algorithmHyperParameters(model.algorithmHyperParameters);
            this.featureTransformationParameters(model.featureTransformationParameters);
            this.autoMLConfig(model.autoMLConfig);
            this.eventsConfig(model.eventsConfig);
            this.optimizationObjective(model.optimizationObjective);
            this.trainingDataConfig(model.trainingDataConfig);
            this.autoTrainingConfig(model.autoTrainingConfig);
        }

        public final String getEventValueThreshold() {
            return this.eventValueThreshold;
        }

        public final void setEventValueThreshold(String eventValueThreshold) {
            this.eventValueThreshold = eventValueThreshold;
        }

        @Override
        public final Builder eventValueThreshold(String eventValueThreshold) {
            this.eventValueThreshold = eventValueThreshold;
            return this;
        }

        public final HPOConfig.Builder getHpoConfig() {
            return this.hpoConfig != null ? this.hpoConfig.toBuilder() : null;
        }

        public final void setHpoConfig(HPOConfig.BuilderImpl hpoConfig) {
            this.hpoConfig = hpoConfig != null ? hpoConfig.build() : null;
        }

        @Override
        public final Builder hpoConfig(HPOConfig hpoConfig) {
            this.hpoConfig = hpoConfig;
            return this;
        }

        public final Map<String, String> getAlgorithmHyperParameters() {
            if (this.algorithmHyperParameters instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.algorithmHyperParameters;
        }

        public final void setAlgorithmHyperParameters(Map<String, String> algorithmHyperParameters) {
            this.algorithmHyperParameters = HyperParametersCopier.copy(algorithmHyperParameters);
        }

        @Override
        public final Builder algorithmHyperParameters(Map<String, String> algorithmHyperParameters) {
            this.algorithmHyperParameters = HyperParametersCopier.copy(algorithmHyperParameters);
            return this;
        }

        public final Map<String, String> getFeatureTransformationParameters() {
            if (this.featureTransformationParameters instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.featureTransformationParameters;
        }

        public final void setFeatureTransformationParameters(Map<String, String> featureTransformationParameters) {
            this.featureTransformationParameters = FeatureTransformationParametersCopier.copy(featureTransformationParameters);
        }

        @Override
        public final Builder featureTransformationParameters(Map<String, String> featureTransformationParameters) {
            this.featureTransformationParameters = FeatureTransformationParametersCopier.copy(featureTransformationParameters);
            return this;
        }

        public final AutoMLConfig.Builder getAutoMLConfig() {
            return this.autoMLConfig != null ? this.autoMLConfig.toBuilder() : null;
        }

        public final void setAutoMLConfig(AutoMLConfig.BuilderImpl autoMLConfig) {
            this.autoMLConfig = autoMLConfig != null ? autoMLConfig.build() : null;
        }

        @Override
        public final Builder autoMLConfig(AutoMLConfig autoMLConfig) {
            this.autoMLConfig = autoMLConfig;
            return this;
        }

        public final EventsConfig.Builder getEventsConfig() {
            return this.eventsConfig != null ? this.eventsConfig.toBuilder() : null;
        }

        public final void setEventsConfig(EventsConfig.BuilderImpl eventsConfig) {
            this.eventsConfig = eventsConfig != null ? eventsConfig.build() : null;
        }

        @Override
        public final Builder eventsConfig(EventsConfig eventsConfig) {
            this.eventsConfig = eventsConfig;
            return this;
        }

        public final OptimizationObjective.Builder getOptimizationObjective() {
            return this.optimizationObjective != null ? this.optimizationObjective.toBuilder() : null;
        }

        public final void setOptimizationObjective(OptimizationObjective.BuilderImpl optimizationObjective) {
            this.optimizationObjective = optimizationObjective != null ? optimizationObjective.build() : null;
        }

        @Override
        public final Builder optimizationObjective(OptimizationObjective optimizationObjective) {
            this.optimizationObjective = optimizationObjective;
            return this;
        }

        public final TrainingDataConfig.Builder getTrainingDataConfig() {
            return this.trainingDataConfig != null ? this.trainingDataConfig.toBuilder() : null;
        }

        public final void setTrainingDataConfig(TrainingDataConfig.BuilderImpl trainingDataConfig) {
            this.trainingDataConfig = trainingDataConfig != null ? trainingDataConfig.build() : null;
        }

        @Override
        public final Builder trainingDataConfig(TrainingDataConfig trainingDataConfig) {
            this.trainingDataConfig = trainingDataConfig;
            return this;
        }

        public final AutoTrainingConfig.Builder getAutoTrainingConfig() {
            return this.autoTrainingConfig != null ? this.autoTrainingConfig.toBuilder() : null;
        }

        public final void setAutoTrainingConfig(AutoTrainingConfig.BuilderImpl autoTrainingConfig) {
            this.autoTrainingConfig = autoTrainingConfig != null ? autoTrainingConfig.build() : null;
        }

        @Override
        public final Builder autoTrainingConfig(AutoTrainingConfig autoTrainingConfig) {
            this.autoTrainingConfig = autoTrainingConfig;
            return this;
        }

        public SolutionConfig build() {
            return new SolutionConfig(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, SolutionConfig> {
        public Builder eventValueThreshold(String var1);

        public Builder hpoConfig(HPOConfig var1);

        default public Builder hpoConfig(Consumer<HPOConfig.Builder> hpoConfig) {
            return this.hpoConfig((HPOConfig)((HPOConfig.Builder)HPOConfig.builder().applyMutation(hpoConfig)).build());
        }

        public Builder algorithmHyperParameters(Map<String, String> var1);

        public Builder featureTransformationParameters(Map<String, String> var1);

        public Builder autoMLConfig(AutoMLConfig var1);

        default public Builder autoMLConfig(Consumer<AutoMLConfig.Builder> autoMLConfig) {
            return this.autoMLConfig((AutoMLConfig)((AutoMLConfig.Builder)AutoMLConfig.builder().applyMutation(autoMLConfig)).build());
        }

        public Builder eventsConfig(EventsConfig var1);

        default public Builder eventsConfig(Consumer<EventsConfig.Builder> eventsConfig) {
            return this.eventsConfig((EventsConfig)((EventsConfig.Builder)EventsConfig.builder().applyMutation(eventsConfig)).build());
        }

        public Builder optimizationObjective(OptimizationObjective var1);

        default public Builder optimizationObjective(Consumer<OptimizationObjective.Builder> optimizationObjective) {
            return this.optimizationObjective((OptimizationObjective)((OptimizationObjective.Builder)OptimizationObjective.builder().applyMutation(optimizationObjective)).build());
        }

        public Builder trainingDataConfig(TrainingDataConfig var1);

        default public Builder trainingDataConfig(Consumer<TrainingDataConfig.Builder> trainingDataConfig) {
            return this.trainingDataConfig((TrainingDataConfig)((TrainingDataConfig.Builder)TrainingDataConfig.builder().applyMutation(trainingDataConfig)).build());
        }

        public Builder autoTrainingConfig(AutoTrainingConfig var1);

        default public Builder autoTrainingConfig(Consumer<AutoTrainingConfig.Builder> autoTrainingConfig) {
            return this.autoTrainingConfig((AutoTrainingConfig)((AutoTrainingConfig.Builder)AutoTrainingConfig.builder().applyMutation(autoTrainingConfig)).build());
        }
    }
}

