/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.personalize.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.personalize.model.DataSource;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DataDeletionJob
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, DataDeletionJob> {
    private static final SdkField<String> JOB_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("jobName").getter(DataDeletionJob.getter(DataDeletionJob::jobName)).setter(DataDeletionJob.setter(Builder::jobName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("jobName").build()}).build();
    private static final SdkField<String> DATA_DELETION_JOB_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("dataDeletionJobArn").getter(DataDeletionJob.getter(DataDeletionJob::dataDeletionJobArn)).setter(DataDeletionJob.setter(Builder::dataDeletionJobArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dataDeletionJobArn").build()}).build();
    private static final SdkField<String> DATASET_GROUP_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("datasetGroupArn").getter(DataDeletionJob.getter(DataDeletionJob::datasetGroupArn)).setter(DataDeletionJob.setter(Builder::datasetGroupArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("datasetGroupArn").build()}).build();
    private static final SdkField<DataSource> DATA_SOURCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("dataSource").getter(DataDeletionJob.getter(DataDeletionJob::dataSource)).setter(DataDeletionJob.setter(Builder::dataSource)).constructor(DataSource::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dataSource").build()}).build();
    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("roleArn").getter(DataDeletionJob.getter(DataDeletionJob::roleArn)).setter(DataDeletionJob.setter(Builder::roleArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("roleArn").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("status").getter(DataDeletionJob.getter(DataDeletionJob::status)).setter(DataDeletionJob.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()}).build();
    private static final SdkField<Integer> NUM_DELETED_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("numDeleted").getter(DataDeletionJob.getter(DataDeletionJob::numDeleted)).setter(DataDeletionJob.setter(Builder::numDeleted)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("numDeleted").build()}).build();
    private static final SdkField<Instant> CREATION_DATE_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("creationDateTime").getter(DataDeletionJob.getter(DataDeletionJob::creationDateTime)).setter(DataDeletionJob.setter(Builder::creationDateTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("creationDateTime").build()}).build();
    private static final SdkField<Instant> LAST_UPDATED_DATE_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("lastUpdatedDateTime").getter(DataDeletionJob.getter(DataDeletionJob::lastUpdatedDateTime)).setter(DataDeletionJob.setter(Builder::lastUpdatedDateTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastUpdatedDateTime").build()}).build();
    private static final SdkField<String> FAILURE_REASON_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("failureReason").getter(DataDeletionJob.getter(DataDeletionJob::failureReason)).setter(DataDeletionJob.setter(Builder::failureReason)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("failureReason").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(JOB_NAME_FIELD, DATA_DELETION_JOB_ARN_FIELD, DATASET_GROUP_ARN_FIELD, DATA_SOURCE_FIELD, ROLE_ARN_FIELD, STATUS_FIELD, NUM_DELETED_FIELD, CREATION_DATE_TIME_FIELD, LAST_UPDATED_DATE_TIME_FIELD, FAILURE_REASON_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DataDeletionJob.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String jobName;
    private final String dataDeletionJobArn;
    private final String datasetGroupArn;
    private final DataSource dataSource;
    private final String roleArn;
    private final String status;
    private final Integer numDeleted;
    private final Instant creationDateTime;
    private final Instant lastUpdatedDateTime;
    private final String failureReason;

    private DataDeletionJob(BuilderImpl builder) {
        this.jobName = builder.jobName;
        this.dataDeletionJobArn = builder.dataDeletionJobArn;
        this.datasetGroupArn = builder.datasetGroupArn;
        this.dataSource = builder.dataSource;
        this.roleArn = builder.roleArn;
        this.status = builder.status;
        this.numDeleted = builder.numDeleted;
        this.creationDateTime = builder.creationDateTime;
        this.lastUpdatedDateTime = builder.lastUpdatedDateTime;
        this.failureReason = builder.failureReason;
    }

    public final String jobName() {
        return this.jobName;
    }

    public final String dataDeletionJobArn() {
        return this.dataDeletionJobArn;
    }

    public final String datasetGroupArn() {
        return this.datasetGroupArn;
    }

    public final DataSource dataSource() {
        return this.dataSource;
    }

    public final String roleArn() {
        return this.roleArn;
    }

    public final String status() {
        return this.status;
    }

    public final Integer numDeleted() {
        return this.numDeleted;
    }

    public final Instant creationDateTime() {
        return this.creationDateTime;
    }

    public final Instant lastUpdatedDateTime() {
        return this.lastUpdatedDateTime;
    }

    public final String failureReason() {
        return this.failureReason;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.jobName());
        hashCode = 31 * hashCode + Objects.hashCode(this.dataDeletionJobArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.datasetGroupArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.dataSource());
        hashCode = 31 * hashCode + Objects.hashCode(this.roleArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.status());
        hashCode = 31 * hashCode + Objects.hashCode(this.numDeleted());
        hashCode = 31 * hashCode + Objects.hashCode(this.creationDateTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastUpdatedDateTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.failureReason());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DataDeletionJob)) {
            return false;
        }
        DataDeletionJob other = (DataDeletionJob)obj;
        return Objects.equals(this.jobName(), other.jobName()) && Objects.equals(this.dataDeletionJobArn(), other.dataDeletionJobArn()) && Objects.equals(this.datasetGroupArn(), other.datasetGroupArn()) && Objects.equals(this.dataSource(), other.dataSource()) && Objects.equals(this.roleArn(), other.roleArn()) && Objects.equals(this.status(), other.status()) && Objects.equals(this.numDeleted(), other.numDeleted()) && Objects.equals(this.creationDateTime(), other.creationDateTime()) && Objects.equals(this.lastUpdatedDateTime(), other.lastUpdatedDateTime()) && Objects.equals(this.failureReason(), other.failureReason());
    }

    public final String toString() {
        return ToString.builder((String)"DataDeletionJob").add("JobName", (Object)this.jobName()).add("DataDeletionJobArn", (Object)this.dataDeletionJobArn()).add("DatasetGroupArn", (Object)this.datasetGroupArn()).add("DataSource", (Object)this.dataSource()).add("RoleArn", (Object)this.roleArn()).add("Status", (Object)this.status()).add("NumDeleted", (Object)this.numDeleted()).add("CreationDateTime", (Object)this.creationDateTime()).add("LastUpdatedDateTime", (Object)this.lastUpdatedDateTime()).add("FailureReason", (Object)this.failureReason()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "jobName": {
                return Optional.ofNullable(clazz.cast(this.jobName()));
            }
            case "dataDeletionJobArn": {
                return Optional.ofNullable(clazz.cast(this.dataDeletionJobArn()));
            }
            case "datasetGroupArn": {
                return Optional.ofNullable(clazz.cast(this.datasetGroupArn()));
            }
            case "dataSource": {
                return Optional.ofNullable(clazz.cast(this.dataSource()));
            }
            case "roleArn": {
                return Optional.ofNullable(clazz.cast(this.roleArn()));
            }
            case "status": {
                return Optional.ofNullable(clazz.cast(this.status()));
            }
            case "numDeleted": {
                return Optional.ofNullable(clazz.cast(this.numDeleted()));
            }
            case "creationDateTime": {
                return Optional.ofNullable(clazz.cast(this.creationDateTime()));
            }
            case "lastUpdatedDateTime": {
                return Optional.ofNullable(clazz.cast(this.lastUpdatedDateTime()));
            }
            case "failureReason": {
                return Optional.ofNullable(clazz.cast(this.failureReason()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("jobName", JOB_NAME_FIELD);
        map.put("dataDeletionJobArn", DATA_DELETION_JOB_ARN_FIELD);
        map.put("datasetGroupArn", DATASET_GROUP_ARN_FIELD);
        map.put("dataSource", DATA_SOURCE_FIELD);
        map.put("roleArn", ROLE_ARN_FIELD);
        map.put("status", STATUS_FIELD);
        map.put("numDeleted", NUM_DELETED_FIELD);
        map.put("creationDateTime", CREATION_DATE_TIME_FIELD);
        map.put("lastUpdatedDateTime", LAST_UPDATED_DATE_TIME_FIELD);
        map.put("failureReason", FAILURE_REASON_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DataDeletionJob, T> g) {
        return obj -> g.apply((DataDeletionJob)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String jobName;
        private String dataDeletionJobArn;
        private String datasetGroupArn;
        private DataSource dataSource;
        private String roleArn;
        private String status;
        private Integer numDeleted;
        private Instant creationDateTime;
        private Instant lastUpdatedDateTime;
        private String failureReason;

        private BuilderImpl() {
        }

        private BuilderImpl(DataDeletionJob model) {
            this.jobName(model.jobName);
            this.dataDeletionJobArn(model.dataDeletionJobArn);
            this.datasetGroupArn(model.datasetGroupArn);
            this.dataSource(model.dataSource);
            this.roleArn(model.roleArn);
            this.status(model.status);
            this.numDeleted(model.numDeleted);
            this.creationDateTime(model.creationDateTime);
            this.lastUpdatedDateTime(model.lastUpdatedDateTime);
            this.failureReason(model.failureReason);
        }

        public final String getJobName() {
            return this.jobName;
        }

        public final void setJobName(String jobName) {
            this.jobName = jobName;
        }

        @Override
        public final Builder jobName(String jobName) {
            this.jobName = jobName;
            return this;
        }

        public final String getDataDeletionJobArn() {
            return this.dataDeletionJobArn;
        }

        public final void setDataDeletionJobArn(String dataDeletionJobArn) {
            this.dataDeletionJobArn = dataDeletionJobArn;
        }

        @Override
        public final Builder dataDeletionJobArn(String dataDeletionJobArn) {
            this.dataDeletionJobArn = dataDeletionJobArn;
            return this;
        }

        public final String getDatasetGroupArn() {
            return this.datasetGroupArn;
        }

        public final void setDatasetGroupArn(String datasetGroupArn) {
            this.datasetGroupArn = datasetGroupArn;
        }

        @Override
        public final Builder datasetGroupArn(String datasetGroupArn) {
            this.datasetGroupArn = datasetGroupArn;
            return this;
        }

        public final DataSource.Builder getDataSource() {
            return this.dataSource != null ? this.dataSource.toBuilder() : null;
        }

        public final void setDataSource(DataSource.BuilderImpl dataSource) {
            this.dataSource = dataSource != null ? dataSource.build() : null;
        }

        @Override
        public final Builder dataSource(DataSource dataSource) {
            this.dataSource = dataSource;
            return this;
        }

        public final String getRoleArn() {
            return this.roleArn;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        public final Integer getNumDeleted() {
            return this.numDeleted;
        }

        public final void setNumDeleted(Integer numDeleted) {
            this.numDeleted = numDeleted;
        }

        @Override
        public final Builder numDeleted(Integer numDeleted) {
            this.numDeleted = numDeleted;
            return this;
        }

        public final Instant getCreationDateTime() {
            return this.creationDateTime;
        }

        public final void setCreationDateTime(Instant creationDateTime) {
            this.creationDateTime = creationDateTime;
        }

        @Override
        public final Builder creationDateTime(Instant creationDateTime) {
            this.creationDateTime = creationDateTime;
            return this;
        }

        public final Instant getLastUpdatedDateTime() {
            return this.lastUpdatedDateTime;
        }

        public final void setLastUpdatedDateTime(Instant lastUpdatedDateTime) {
            this.lastUpdatedDateTime = lastUpdatedDateTime;
        }

        @Override
        public final Builder lastUpdatedDateTime(Instant lastUpdatedDateTime) {
            this.lastUpdatedDateTime = lastUpdatedDateTime;
            return this;
        }

        public final String getFailureReason() {
            return this.failureReason;
        }

        public final void setFailureReason(String failureReason) {
            this.failureReason = failureReason;
        }

        @Override
        public final Builder failureReason(String failureReason) {
            this.failureReason = failureReason;
            return this;
        }

        public DataDeletionJob build() {
            return new DataDeletionJob(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, DataDeletionJob> {
        public Builder jobName(String var1);

        public Builder dataDeletionJobArn(String var1);

        public Builder datasetGroupArn(String var1);

        public Builder dataSource(DataSource var1);

        default public Builder dataSource(Consumer<DataSource.Builder> dataSource) {
            return this.dataSource((DataSource)((DataSource.Builder)DataSource.builder().applyMutation(dataSource)).build());
        }

        public Builder roleArn(String var1);

        public Builder status(String var1);

        public Builder numDeleted(Integer var1);

        public Builder creationDateTime(Instant var1);

        public Builder lastUpdatedDateTime(Instant var1);

        public Builder failureReason(String var1);
    }
}

