/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.personalize.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.personalize.model.MetricAttribute;
import software.amazon.awssdk.services.personalize.model.MetricAttributesCopier;
import software.amazon.awssdk.services.personalize.model.MetricAttributesNamesListCopier;
import software.amazon.awssdk.services.personalize.model.MetricAttributionOutput;
import software.amazon.awssdk.services.personalize.model.PersonalizeRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateMetricAttributionRequest
extends PersonalizeRequest
implements ToCopyableBuilder<Builder, UpdateMetricAttributionRequest> {
    private static final SdkField<List<MetricAttribute>> ADD_METRICS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("addMetrics").getter(UpdateMetricAttributionRequest.getter(UpdateMetricAttributionRequest::addMetrics)).setter(UpdateMetricAttributionRequest.setter(Builder::addMetrics)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("addMetrics").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(MetricAttribute::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> REMOVE_METRICS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("removeMetrics").getter(UpdateMetricAttributionRequest.getter(UpdateMetricAttributionRequest::removeMetrics)).setter(UpdateMetricAttributionRequest.setter(Builder::removeMetrics)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("removeMetrics").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<MetricAttributionOutput> METRICS_OUTPUT_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("metricsOutputConfig").getter(UpdateMetricAttributionRequest.getter(UpdateMetricAttributionRequest::metricsOutputConfig)).setter(UpdateMetricAttributionRequest.setter(Builder::metricsOutputConfig)).constructor(MetricAttributionOutput::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("metricsOutputConfig").build()}).build();
    private static final SdkField<String> METRIC_ATTRIBUTION_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("metricAttributionArn").getter(UpdateMetricAttributionRequest.getter(UpdateMetricAttributionRequest::metricAttributionArn)).setter(UpdateMetricAttributionRequest.setter(Builder::metricAttributionArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("metricAttributionArn").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ADD_METRICS_FIELD, REMOVE_METRICS_FIELD, METRICS_OUTPUT_CONFIG_FIELD, METRIC_ATTRIBUTION_ARN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = UpdateMetricAttributionRequest.memberNameToFieldInitializer();
    private final List<MetricAttribute> addMetrics;
    private final List<String> removeMetrics;
    private final MetricAttributionOutput metricsOutputConfig;
    private final String metricAttributionArn;

    private UpdateMetricAttributionRequest(BuilderImpl builder) {
        super(builder);
        this.addMetrics = builder.addMetrics;
        this.removeMetrics = builder.removeMetrics;
        this.metricsOutputConfig = builder.metricsOutputConfig;
        this.metricAttributionArn = builder.metricAttributionArn;
    }

    public final boolean hasAddMetrics() {
        return this.addMetrics != null && !(this.addMetrics instanceof SdkAutoConstructList);
    }

    public final List<MetricAttribute> addMetrics() {
        return this.addMetrics;
    }

    public final boolean hasRemoveMetrics() {
        return this.removeMetrics != null && !(this.removeMetrics instanceof SdkAutoConstructList);
    }

    public final List<String> removeMetrics() {
        return this.removeMetrics;
    }

    public final MetricAttributionOutput metricsOutputConfig() {
        return this.metricsOutputConfig;
    }

    public final String metricAttributionArn() {
        return this.metricAttributionArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAddMetrics() ? this.addMetrics() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasRemoveMetrics() ? this.removeMetrics() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.metricsOutputConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.metricAttributionArn());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateMetricAttributionRequest)) {
            return false;
        }
        UpdateMetricAttributionRequest other = (UpdateMetricAttributionRequest)((Object)obj);
        return this.hasAddMetrics() == other.hasAddMetrics() && Objects.equals(this.addMetrics(), other.addMetrics()) && this.hasRemoveMetrics() == other.hasRemoveMetrics() && Objects.equals(this.removeMetrics(), other.removeMetrics()) && Objects.equals(this.metricsOutputConfig(), other.metricsOutputConfig()) && Objects.equals(this.metricAttributionArn(), other.metricAttributionArn());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateMetricAttributionRequest").add("AddMetrics", this.hasAddMetrics() ? this.addMetrics() : null).add("RemoveMetrics", this.hasRemoveMetrics() ? this.removeMetrics() : null).add("MetricsOutputConfig", (Object)this.metricsOutputConfig()).add("MetricAttributionArn", (Object)this.metricAttributionArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "addMetrics": {
                return Optional.ofNullable(clazz.cast(this.addMetrics()));
            }
            case "removeMetrics": {
                return Optional.ofNullable(clazz.cast(this.removeMetrics()));
            }
            case "metricsOutputConfig": {
                return Optional.ofNullable(clazz.cast(this.metricsOutputConfig()));
            }
            case "metricAttributionArn": {
                return Optional.ofNullable(clazz.cast(this.metricAttributionArn()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("addMetrics", ADD_METRICS_FIELD);
        map.put("removeMetrics", REMOVE_METRICS_FIELD);
        map.put("metricsOutputConfig", METRICS_OUTPUT_CONFIG_FIELD);
        map.put("metricAttributionArn", METRIC_ATTRIBUTION_ARN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateMetricAttributionRequest, T> g) {
        return obj -> g.apply((UpdateMetricAttributionRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends PersonalizeRequest.BuilderImpl
    implements Builder {
        private List<MetricAttribute> addMetrics = DefaultSdkAutoConstructList.getInstance();
        private List<String> removeMetrics = DefaultSdkAutoConstructList.getInstance();
        private MetricAttributionOutput metricsOutputConfig;
        private String metricAttributionArn;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateMetricAttributionRequest model) {
            super(model);
            this.addMetrics(model.addMetrics);
            this.removeMetrics(model.removeMetrics);
            this.metricsOutputConfig(model.metricsOutputConfig);
            this.metricAttributionArn(model.metricAttributionArn);
        }

        public final List<MetricAttribute.Builder> getAddMetrics() {
            List<MetricAttribute.Builder> result = MetricAttributesCopier.copyToBuilder(this.addMetrics);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAddMetrics(Collection<MetricAttribute.BuilderImpl> addMetrics) {
            this.addMetrics = MetricAttributesCopier.copyFromBuilder(addMetrics);
        }

        @Override
        public final Builder addMetrics(Collection<MetricAttribute> addMetrics) {
            this.addMetrics = MetricAttributesCopier.copy(addMetrics);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder addMetrics(MetricAttribute ... addMetrics) {
            this.addMetrics(Arrays.asList(addMetrics));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder addMetrics(Consumer<MetricAttribute.Builder> ... addMetrics) {
            this.addMetrics(Stream.of(addMetrics).map(c -> (MetricAttribute)((MetricAttribute.Builder)MetricAttribute.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final Collection<String> getRemoveMetrics() {
            if (this.removeMetrics instanceof SdkAutoConstructList) {
                return null;
            }
            return this.removeMetrics;
        }

        public final void setRemoveMetrics(Collection<String> removeMetrics) {
            this.removeMetrics = MetricAttributesNamesListCopier.copy(removeMetrics);
        }

        @Override
        public final Builder removeMetrics(Collection<String> removeMetrics) {
            this.removeMetrics = MetricAttributesNamesListCopier.copy(removeMetrics);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder removeMetrics(String ... removeMetrics) {
            this.removeMetrics(Arrays.asList(removeMetrics));
            return this;
        }

        public final MetricAttributionOutput.Builder getMetricsOutputConfig() {
            return this.metricsOutputConfig != null ? this.metricsOutputConfig.toBuilder() : null;
        }

        public final void setMetricsOutputConfig(MetricAttributionOutput.BuilderImpl metricsOutputConfig) {
            this.metricsOutputConfig = metricsOutputConfig != null ? metricsOutputConfig.build() : null;
        }

        @Override
        public final Builder metricsOutputConfig(MetricAttributionOutput metricsOutputConfig) {
            this.metricsOutputConfig = metricsOutputConfig;
            return this;
        }

        public final String getMetricAttributionArn() {
            return this.metricAttributionArn;
        }

        public final void setMetricAttributionArn(String metricAttributionArn) {
            this.metricAttributionArn = metricAttributionArn;
        }

        @Override
        public final Builder metricAttributionArn(String metricAttributionArn) {
            this.metricAttributionArn = metricAttributionArn;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateMetricAttributionRequest build() {
            return new UpdateMetricAttributionRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends PersonalizeRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateMetricAttributionRequest> {
        public Builder addMetrics(Collection<MetricAttribute> var1);

        public Builder addMetrics(MetricAttribute ... var1);

        public Builder addMetrics(Consumer<MetricAttribute.Builder> ... var1);

        public Builder removeMetrics(Collection<String> var1);

        public Builder removeMetrics(String ... var1);

        public Builder metricsOutputConfig(MetricAttributionOutput var1);

        default public Builder metricsOutputConfig(Consumer<MetricAttributionOutput.Builder> metricsOutputConfig) {
            return this.metricsOutputConfig((MetricAttributionOutput)((MetricAttributionOutput.Builder)MetricAttributionOutput.builder().applyMutation(metricsOutputConfig)).build());
        }

        public Builder metricAttributionArn(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

