/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.personalize.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.personalize.model.AutoTrainingConfig;
import software.amazon.awssdk.services.personalize.model.EventsConfig;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SolutionUpdateConfig
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, SolutionUpdateConfig> {
    private static final SdkField<AutoTrainingConfig> AUTO_TRAINING_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("autoTrainingConfig").getter(SolutionUpdateConfig.getter(SolutionUpdateConfig::autoTrainingConfig)).setter(SolutionUpdateConfig.setter(Builder::autoTrainingConfig)).constructor(AutoTrainingConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("autoTrainingConfig").build()}).build();
    private static final SdkField<EventsConfig> EVENTS_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("eventsConfig").getter(SolutionUpdateConfig.getter(SolutionUpdateConfig::eventsConfig)).setter(SolutionUpdateConfig.setter(Builder::eventsConfig)).constructor(EventsConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("eventsConfig").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AUTO_TRAINING_CONFIG_FIELD, EVENTS_CONFIG_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = SolutionUpdateConfig.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final AutoTrainingConfig autoTrainingConfig;
    private final EventsConfig eventsConfig;

    private SolutionUpdateConfig(BuilderImpl builder) {
        this.autoTrainingConfig = builder.autoTrainingConfig;
        this.eventsConfig = builder.eventsConfig;
    }

    public final AutoTrainingConfig autoTrainingConfig() {
        return this.autoTrainingConfig;
    }

    public final EventsConfig eventsConfig() {
        return this.eventsConfig;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.autoTrainingConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.eventsConfig());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SolutionUpdateConfig)) {
            return false;
        }
        SolutionUpdateConfig other = (SolutionUpdateConfig)obj;
        return Objects.equals(this.autoTrainingConfig(), other.autoTrainingConfig()) && Objects.equals(this.eventsConfig(), other.eventsConfig());
    }

    public final String toString() {
        return ToString.builder((String)"SolutionUpdateConfig").add("AutoTrainingConfig", (Object)this.autoTrainingConfig()).add("EventsConfig", (Object)this.eventsConfig()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "autoTrainingConfig": {
                return Optional.ofNullable(clazz.cast(this.autoTrainingConfig()));
            }
            case "eventsConfig": {
                return Optional.ofNullable(clazz.cast(this.eventsConfig()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("autoTrainingConfig", AUTO_TRAINING_CONFIG_FIELD);
        map.put("eventsConfig", EVENTS_CONFIG_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<SolutionUpdateConfig, T> g) {
        return obj -> g.apply((SolutionUpdateConfig)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private AutoTrainingConfig autoTrainingConfig;
        private EventsConfig eventsConfig;

        private BuilderImpl() {
        }

        private BuilderImpl(SolutionUpdateConfig model) {
            this.autoTrainingConfig(model.autoTrainingConfig);
            this.eventsConfig(model.eventsConfig);
        }

        public final AutoTrainingConfig.Builder getAutoTrainingConfig() {
            return this.autoTrainingConfig != null ? this.autoTrainingConfig.toBuilder() : null;
        }

        public final void setAutoTrainingConfig(AutoTrainingConfig.BuilderImpl autoTrainingConfig) {
            this.autoTrainingConfig = autoTrainingConfig != null ? autoTrainingConfig.build() : null;
        }

        @Override
        public final Builder autoTrainingConfig(AutoTrainingConfig autoTrainingConfig) {
            this.autoTrainingConfig = autoTrainingConfig;
            return this;
        }

        public final EventsConfig.Builder getEventsConfig() {
            return this.eventsConfig != null ? this.eventsConfig.toBuilder() : null;
        }

        public final void setEventsConfig(EventsConfig.BuilderImpl eventsConfig) {
            this.eventsConfig = eventsConfig != null ? eventsConfig.build() : null;
        }

        @Override
        public final Builder eventsConfig(EventsConfig eventsConfig) {
            this.eventsConfig = eventsConfig;
            return this;
        }

        public SolutionUpdateConfig build() {
            return new SolutionUpdateConfig(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, SolutionUpdateConfig> {
        public Builder autoTrainingConfig(AutoTrainingConfig var1);

        default public Builder autoTrainingConfig(Consumer<AutoTrainingConfig.Builder> autoTrainingConfig) {
            return this.autoTrainingConfig((AutoTrainingConfig)((AutoTrainingConfig.Builder)AutoTrainingConfig.builder().applyMutation(autoTrainingConfig)).build());
        }

        public Builder eventsConfig(EventsConfig var1);

        default public Builder eventsConfig(Consumer<EventsConfig.Builder> eventsConfig) {
            return this.eventsConfig((EventsConfig)((EventsConfig.Builder)EventsConfig.builder().applyMutation(eventsConfig)).build());
        }
    }
}

