/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.personalize.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.personalize.model.PersonalizeResponse;
import software.amazon.awssdk.services.personalize.model.SolutionVersionSummary;
import software.amazon.awssdk.services.personalize.model.SolutionVersionsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListSolutionVersionsResponse
extends PersonalizeResponse
implements ToCopyableBuilder<Builder, ListSolutionVersionsResponse> {
    private static final SdkField<List<SolutionVersionSummary>> SOLUTION_VERSIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("solutionVersions").getter(ListSolutionVersionsResponse.getter(ListSolutionVersionsResponse::solutionVersions)).setter(ListSolutionVersionsResponse.setter(Builder::solutionVersions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("solutionVersions").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(SolutionVersionSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(ListSolutionVersionsResponse.getter(ListSolutionVersionsResponse::nextToken)).setter(ListSolutionVersionsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SOLUTION_VERSIONS_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListSolutionVersionsResponse.memberNameToFieldInitializer();
    private final List<SolutionVersionSummary> solutionVersions;
    private final String nextToken;

    private ListSolutionVersionsResponse(BuilderImpl builder) {
        super(builder);
        this.solutionVersions = builder.solutionVersions;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasSolutionVersions() {
        return this.solutionVersions != null && !(this.solutionVersions instanceof SdkAutoConstructList);
    }

    public final List<SolutionVersionSummary> solutionVersions() {
        return this.solutionVersions;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSolutionVersions() ? this.solutionVersions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListSolutionVersionsResponse)) {
            return false;
        }
        ListSolutionVersionsResponse other = (ListSolutionVersionsResponse)((Object)obj);
        return this.hasSolutionVersions() == other.hasSolutionVersions() && Objects.equals(this.solutionVersions(), other.solutionVersions()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListSolutionVersionsResponse").add("SolutionVersions", this.hasSolutionVersions() ? this.solutionVersions() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "solutionVersions": {
                return Optional.ofNullable(clazz.cast(this.solutionVersions()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("solutionVersions", SOLUTION_VERSIONS_FIELD);
        map.put("nextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListSolutionVersionsResponse, T> g) {
        return obj -> g.apply((ListSolutionVersionsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends PersonalizeResponse.BuilderImpl
    implements Builder {
        private List<SolutionVersionSummary> solutionVersions = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListSolutionVersionsResponse model) {
            super(model);
            this.solutionVersions(model.solutionVersions);
            this.nextToken(model.nextToken);
        }

        public final List<SolutionVersionSummary.Builder> getSolutionVersions() {
            List<SolutionVersionSummary.Builder> result = SolutionVersionsCopier.copyToBuilder(this.solutionVersions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSolutionVersions(Collection<SolutionVersionSummary.BuilderImpl> solutionVersions) {
            this.solutionVersions = SolutionVersionsCopier.copyFromBuilder(solutionVersions);
        }

        @Override
        public final Builder solutionVersions(Collection<SolutionVersionSummary> solutionVersions) {
            this.solutionVersions = SolutionVersionsCopier.copy(solutionVersions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder solutionVersions(SolutionVersionSummary ... solutionVersions) {
            this.solutionVersions(Arrays.asList(solutionVersions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder solutionVersions(Consumer<SolutionVersionSummary.Builder> ... solutionVersions) {
            this.solutionVersions(Stream.of(solutionVersions).map(c -> (SolutionVersionSummary)((SolutionVersionSummary.Builder)SolutionVersionSummary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListSolutionVersionsResponse build() {
            return new ListSolutionVersionsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends PersonalizeResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListSolutionVersionsResponse> {
        public Builder solutionVersions(Collection<SolutionVersionSummary> var1);

        public Builder solutionVersions(SolutionVersionSummary ... var1);

        public Builder solutionVersions(Consumer<SolutionVersionSummary.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

