/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.personalize.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class S3DataConfig
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, S3DataConfig> {
    private static final SdkField<String> PATH_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("path").getter(S3DataConfig.getter(S3DataConfig::path)).setter(S3DataConfig.setter(Builder::path)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("path").build()}).build();
    private static final SdkField<String> KMS_KEY_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("kmsKeyArn").getter(S3DataConfig.getter(S3DataConfig::kmsKeyArn)).setter(S3DataConfig.setter(Builder::kmsKeyArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("kmsKeyArn").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PATH_FIELD, KMS_KEY_ARN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("path", PATH_FIELD);
            this.put("kmsKeyArn", KMS_KEY_ARN_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String path;
    private final String kmsKeyArn;

    private S3DataConfig(BuilderImpl builder) {
        this.path = builder.path;
        this.kmsKeyArn = builder.kmsKeyArn;
    }

    public final String path() {
        return this.path;
    }

    public final String kmsKeyArn() {
        return this.kmsKeyArn;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.path());
        hashCode = 31 * hashCode + Objects.hashCode(this.kmsKeyArn());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof S3DataConfig)) {
            return false;
        }
        S3DataConfig other = (S3DataConfig)obj;
        return Objects.equals(this.path(), other.path()) && Objects.equals(this.kmsKeyArn(), other.kmsKeyArn());
    }

    public final String toString() {
        return ToString.builder((String)"S3DataConfig").add("Path", (Object)this.path()).add("KmsKeyArn", (Object)this.kmsKeyArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "path": {
                return Optional.ofNullable(clazz.cast(this.path()));
            }
            case "kmsKeyArn": {
                return Optional.ofNullable(clazz.cast(this.kmsKeyArn()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<S3DataConfig, T> g) {
        return obj -> g.apply((S3DataConfig)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String path;
        private String kmsKeyArn;

        private BuilderImpl() {
        }

        private BuilderImpl(S3DataConfig model) {
            this.path(model.path);
            this.kmsKeyArn(model.kmsKeyArn);
        }

        public final String getPath() {
            return this.path;
        }

        public final void setPath(String path) {
            this.path = path;
        }

        @Override
        public final Builder path(String path) {
            this.path = path;
            return this;
        }

        public final String getKmsKeyArn() {
            return this.kmsKeyArn;
        }

        public final void setKmsKeyArn(String kmsKeyArn) {
            this.kmsKeyArn = kmsKeyArn;
        }

        @Override
        public final Builder kmsKeyArn(String kmsKeyArn) {
            this.kmsKeyArn = kmsKeyArn;
            return this;
        }

        public S3DataConfig build() {
            return new S3DataConfig(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, S3DataConfig> {
        public Builder path(String var1);

        public Builder kmsKeyArn(String var1);
    }
}

